/*
 * Decompiled with CFR 0.152.
 */
package com.kontakt.sdk.android.http;

import com.kontakt.sdk.android.common.interfaces.SDKFunction;
import com.kontakt.sdk.android.common.interfaces.SDKPredicate;
import com.kontakt.sdk.android.common.interfaces.SDKThrowableFunction;
import com.kontakt.sdk.android.common.model.CloudConfig;
import com.kontakt.sdk.android.common.model.Config;
import com.kontakt.sdk.android.common.model.DeviceType;
import com.kontakt.sdk.android.common.model.ICloudConfig;
import com.kontakt.sdk.android.common.model.IConfig;
import com.kontakt.sdk.android.common.model.IPreset;
import com.kontakt.sdk.android.common.model.Preset;
import com.kontakt.sdk.android.common.model.SecureSingleConfig;
import com.kontakt.sdk.android.common.util.HttpUtils;
import com.kontakt.sdk.android.common.util.SDKOptional;
import com.kontakt.sdk.android.http.AbstractApiAccessor;
import com.kontakt.sdk.android.http.ETag;
import com.kontakt.sdk.android.http.ExtractUtils;
import com.kontakt.sdk.android.http.HttpResult;
import com.kontakt.sdk.android.http.RequestDescription;
import com.kontakt.sdk.android.http.data.ConfigData;
import com.kontakt.sdk.android.http.exception.ClientException;
import com.kontakt.sdk.android.http.interfaces.ConfigurationApiAccessor;
import com.kontakt.sdk.android.http.interfaces.ResultApiCallback;
import com.squareup.okhttp.ResponseBody;
import java.util.Collection;
import java.util.List;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

final class ConfigurationApiAccessorImpl
extends AbstractApiAccessor
implements ConfigurationApiAccessor {
    ConfigurationApiAccessorImpl(String apiKey, String apiUrl) {
        super(apiKey, apiUrl);
    }

    @Override
    public HttpResult<IConfig> createConfig(ConfigData configData) throws ClientException {
        return this.createAndTransform("config/create", configData, new SDKThrowableFunction<ResponseBody, JSONArray, Exception>(){

            public JSONArray apply(ResponseBody object) throws Exception {
                return new JSONArray(object.string());
            }
        }, new SDKFunction<JSONArray, IConfig>(){

            public Config apply(JSONArray object) {
                try {
                    return Config.from((JSONObject)object.getJSONObject(0));
                }
                catch (JSONException e) {
                    throw new IllegalStateException(e);
                }
            }
        });
    }

    @Override
    public void createConfig(ConfigData configData, ResultApiCallback<IConfig> apiCallback) {
        RequestDescription requestDescription = RequestDescription.start().addParameters(configData.getParameters()).build();
        this.postAsync("config/create", requestDescription, new int[]{201}, apiCallback, new SDKThrowableFunction<ResponseBody, JSONArray, Exception>(){

            public JSONArray apply(ResponseBody object) throws Exception {
                return new JSONArray(object.string());
            }
        }, new SDKFunction<JSONArray, IConfig>(){

            public IConfig apply(JSONArray object) {
                try {
                    return Config.from((JSONObject)object.getJSONObject(0));
                }
                catch (JSONException e) {
                    throw new IllegalStateException(e);
                }
            }
        });
    }

    @Override
    public HttpResult<ICloudConfig> createCloudConfig(ConfigData configData) throws ClientException {
        return this.createAndTransform("config/create", configData, new SDKThrowableFunction<ResponseBody, JSONArray, Exception>(){

            public JSONArray apply(ResponseBody object) throws Exception {
                return new JSONArray(object.string());
            }
        }, new SDKFunction<JSONArray, ICloudConfig>(){

            public CloudConfig apply(JSONArray object) {
                try {
                    return CloudConfig.from((JSONObject)object.getJSONObject(0));
                }
                catch (JSONException e) {
                    throw new IllegalStateException(e);
                }
            }
        });
    }

    @Override
    public void createCloudConfig(ConfigData configData, ResultApiCallback<ICloudConfig> apiCallback) {
        RequestDescription requestDescription = RequestDescription.start().addParameters(configData.getParameters()).build();
        this.postAsync("config/create", requestDescription, 201, apiCallback, JSON_ARRAY_EXTRACT_FUNCTION, new SDKFunction<JSONArray, ICloudConfig>(){

            public ICloudConfig apply(JSONArray object) {
                try {
                    return CloudConfig.from((JSONObject)object.getJSONObject(0));
                }
                catch (JSONException e) {
                    throw new IllegalStateException(e);
                }
            }
        });
    }

    @Override
    public HttpResult<List<IPreset>> getPresets(SDKOptional<ETag> eTag) throws ClientException {
        RequestDescription requestDescription = RequestDescription.start().setETag(eTag.isPresent() ? (ETag)eTag.get() : null).build();
        return this.getAndTransformToList("preset", requestDescription, new SDKThrowableFunction<ResponseBody, JSONObject, Exception>(){

            public JSONObject apply(ResponseBody object) throws Exception {
                return new JSONObject(object.string());
            }
        }, new SDKFunction<JSONObject, List<IPreset>>(){

            public List<IPreset> apply(JSONObject object) {
                try {
                    return ExtractUtils.toProfileList(object);
                }
                catch (Exception e) {
                    throw new IllegalStateException(e);
                }
            }
        });
    }

    @Override
    public HttpResult<List<IPreset>> getPresets() throws ClientException {
        return this.getPresets((SDKOptional<ETag>)SDKOptional.absent());
    }

    @Override
    public void getPresets(SDKOptional<ETag> eTag, ResultApiCallback<List<IPreset>> apiCallback) {
        RequestDescription requestDescription = RequestDescription.start().setETag(eTag.isPresent() ? (ETag)eTag.get() : null).build();
        this.getAsync("preset", requestDescription, 200, apiCallback, JSON_OBJECT_EXTRACT_FUNCTION, new SDKFunction<JSONObject, List<IPreset>>(){

            public List<IPreset> apply(JSONObject object) {
                try {
                    return ExtractUtils.toProfileList(object);
                }
                catch (JSONException e) {
                    throw new IllegalStateException(e);
                }
            }
        });
    }

    @Override
    public void getPresets(ResultApiCallback<List<IPreset>> apiCallback) {
        this.getPresets((SDKOptional<ETag>)SDKOptional.absent(), apiCallback);
    }

    @Override
    public HttpResult<IPreset> getPreset(String profileName, SDKOptional<ETag> eTag) throws ClientException {
        String uri = String.format("preset/%s", profileName);
        RequestDescription requestDescription = RequestDescription.start().setETag(eTag.isPresent() ? (ETag)eTag.get() : null).build();
        return this.getAndTransform(uri, requestDescription, new SDKFunction<JSONObject, IPreset>(){

            public Preset apply(JSONObject object) {
                return Preset.from((JSONObject)object);
            }
        });
    }

    @Override
    public HttpResult<IPreset> getPreset(String profileName) throws ClientException {
        return this.getPreset(profileName, (SDKOptional<ETag>)SDKOptional.absent());
    }

    @Override
    public void getPreset(String profileName, SDKOptional<ETag> etag, ResultApiCallback<IPreset> apiCallback) {
        String uri = String.format("preset/%s", profileName);
        RequestDescription requestDescription = RequestDescription.start().setETag(etag.isPresent() ? (ETag)etag.get() : null).build();
        this.getAsync(uri, requestDescription, 200, apiCallback, JSON_OBJECT_EXTRACT_FUNCTION, new SDKFunction<JSONObject, IPreset>(){

            public Preset apply(JSONObject object) {
                return Preset.from((JSONObject)object);
            }
        });
    }

    @Override
    public void getPreset(String profileName, ResultApiCallback<IPreset> apiCallback) {
        this.getPreset(profileName, (SDKOptional<ETag>)SDKOptional.absent(), apiCallback);
    }

    @Override
    public HttpResult<List<SecureSingleConfig>> listSecureConfigs(RequestDescription requestDescription) throws ClientException {
        return this.getAndTransformToList("config/encrypt", requestDescription, "configs", new SDKFunction<JSONObject, SecureSingleConfig>(){

            public SecureSingleConfig apply(JSONObject object) {
                return SecureSingleConfig.fromJson((JSONObject)object);
            }
        });
    }

    @Override
    public HttpResult<List<SecureSingleConfig>> listSecureConfigs(SDKOptional<ETag> etag) throws ClientException {
        RequestDescription requestDescription = RequestDescription.start().setETag(etag.isPresent() ? (ETag)etag.get() : null).build();
        return this.listSecureConfigs(requestDescription);
    }

    @Override
    public void listSecureConfigs(SDKOptional<ETag> eTag, ResultApiCallback<List<SecureSingleConfig>> apiCallback) {
        RequestDescription requestDescription = RequestDescription.start().setETag(eTag.isPresent() ? (ETag)eTag.get() : null).build();
        this.listSecureConfigs(requestDescription, apiCallback);
    }

    @Override
    public void listSecureConfigs(RequestDescription requestDescription, ResultApiCallback<List<SecureSingleConfig>> apiCallback) {
        this.transformToListAsynchronously("config/encrypt", requestDescription, 200, "configs", apiCallback, new SDKFunction<JSONObject, SecureSingleConfig>(){

            public SecureSingleConfig apply(JSONObject object) {
                return SecureSingleConfig.fromJson((JSONObject)object);
            }
        });
    }

    @Override
    public HttpResult<List<SecureSingleConfig>> listSecureConfigs(Collection<String> uniqueId, SDKOptional<ETag> eTag) throws ClientException {
        String endpoint = "config/encrypt";
        RequestDescription requestDescription = RequestDescription.start().setETag(eTag.isPresent() ? (ETag)eTag.get() : null).addParameters(HttpUtils.toUrlParameterList((String)"uniqueId", uniqueId)).setOffset(uniqueId.size()).build();
        return this.getAndTransformToList(endpoint, requestDescription, "configs", new SDKFunction<JSONObject, SecureSingleConfig>(){

            public SecureSingleConfig apply(JSONObject object) {
                return SecureSingleConfig.fromJson((JSONObject)object);
            }
        });
    }

    @Override
    public void listSecureConfigs(Collection<String> uniqueId, SDKOptional<ETag> eTag, ResultApiCallback<List<SecureSingleConfig>> apiCallback) {
        String endpoint = "config/encrypt";
        RequestDescription requestDescription = RequestDescription.start().setETag(eTag.isPresent() ? (ETag)eTag.get() : null).addParameters(HttpUtils.toUrlParameterList((String)"uniqueId", uniqueId)).setOffset(uniqueId.size()).build();
        this.transformToListAsynchronously(endpoint, requestDescription, 200, "configs", apiCallback, new SDKFunction<JSONObject, SecureSingleConfig>(){

            public SecureSingleConfig apply(JSONObject object) {
                return SecureSingleConfig.fromJson((JSONObject)object);
            }
        });
    }

    @Override
    public HttpResult<List<IConfig>> listConfigs(RequestDescription requestDescription) throws ClientException {
        return this.getAndTransformToList("config", requestDescription, "configs", new SDKFunction<JSONObject, IConfig>(){

            public Config apply(JSONObject object) {
                return Config.from((JSONObject)object);
            }
        });
    }

    @Override
    public HttpResult<List<IConfig>> listConfigs() throws ClientException {
        return this.listConfigs(DEFAULT_REQUEST_DESCRIPTION);
    }

    @Override
    public void listConfigs(RequestDescription requestDescription, ResultApiCallback<List<IConfig>> apiCallback) {
        this.transformToListAsynchronously("config", requestDescription, 200, "configs", apiCallback, new SDKFunction<JSONObject, IConfig>(){

            public Config apply(JSONObject object) {
                return Config.from((JSONObject)object);
            }
        });
    }

    @Override
    public void listConfigs(ResultApiCallback<List<IConfig>> apiCallback) {
        this.listConfigs(DEFAULT_REQUEST_DESCRIPTION, apiCallback);
    }

    @Override
    public HttpResult<List<ICloudConfig>> listCloudConfigs(RequestDescription requestDescription) throws ClientException {
        return this.getAndTransformToList("config", requestDescription, "configs", new SDKFunction<JSONObject, ICloudConfig>(){

            public CloudConfig apply(JSONObject object) {
                return CloudConfig.from((JSONObject)object);
            }
        });
    }

    @Override
    public HttpResult<List<ICloudConfig>> listCloudConfigs() throws ClientException {
        return this.listCloudConfigs(DEFAULT_REQUEST_DESCRIPTION);
    }

    @Override
    public void listCloudConfigs(RequestDescription requestDescription, ResultApiCallback<List<ICloudConfig>> apiCallback) {
        this.transformToListAsynchronously("config", requestDescription, 200, "configs", apiCallback, new SDKFunction<JSONObject, ICloudConfig>(){

            public CloudConfig apply(JSONObject object) {
                return CloudConfig.from((JSONObject)object);
            }
        });
    }

    @Override
    public void listCloudConfigs(ResultApiCallback<List<ICloudConfig>> apiCallback) {
        this.listCloudConfigs(DEFAULT_REQUEST_DESCRIPTION, apiCallback);
    }

    @Override
    public HttpResult<IConfig> getConfigForDevice(final String deviceUniqueId, SDKOptional<ETag> eTag) throws ClientException {
        RequestDescription requestDescription = RequestDescription.start().addParameter("deviceType", DeviceType.BEACON.name()).setETag(eTag.isPresent() ? (ETag)eTag.get() : null).build();
        return this.selectFirstOrReturnAbsent(this.listConfigs(requestDescription), new SDKPredicate<IConfig>(){

            public boolean test(IConfig target) {
                return target.getDeviceUniqueId().equals(deviceUniqueId);
            }
        });
    }

    @Override
    public HttpResult<IConfig> getConfigForDevice(String beaconUniqueId) throws ClientException {
        return this.getConfigForDevice(beaconUniqueId, (SDKOptional<ETag>)SDKOptional.absent());
    }

    @Override
    public void getConfigForDevice(final String deviceUniqueId, SDKOptional<ETag> etag, final ResultApiCallback<IConfig> apiCallback) {
        RequestDescription requestDescription = RequestDescription.start().addParameter("deviceType", DeviceType.BEACON.name()).setETag(etag.isPresent() ? (ETag)etag.get() : null).build();
        this.listConfigs(requestDescription, new ResultApiCallback<List<IConfig>>(){

            @Override
            public void onSuccess(HttpResult<List<IConfig>> result) {
                HttpResult<IConfig> httpResult = ConfigurationApiAccessorImpl.this.selectFirstOrReturnAbsent(result, new SDKPredicate<IConfig>(){

                    public boolean test(IConfig object) {
                        return object.getDeviceUniqueId().equals(deviceUniqueId);
                    }
                });
                if (httpResult.isPresent()) {
                    apiCallback.onSuccess(httpResult);
                } else {
                    this.onFailure(new ClientException("No pending config found for the device."));
                }
            }

            @Override
            public void onFailure(ClientException e) {
                apiCallback.onFailure(e);
            }
        });
    }

    @Override
    public void getConfigForDevice(String beaconUniqueId, ResultApiCallback<IConfig> apiCallback) {
        this.getConfigForDevice(beaconUniqueId, (SDKOptional<ETag>)SDKOptional.absent(), apiCallback);
    }

    @Override
    public HttpResult<ICloudConfig> getCloudConfigForDevice(final String beaconUniqueId, SDKOptional<ETag> eTag) throws ClientException {
        RequestDescription requestDescription = RequestDescription.start().addParameter("deviceType", DeviceType.CLOUD_BEACON.name()).setETag(eTag.isPresent() ? (ETag)eTag.get() : null).build();
        return this.selectFirstOrReturnAbsent(this.listCloudConfigs(requestDescription), new SDKPredicate<ICloudConfig>(){

            public boolean test(ICloudConfig target) {
                return target.getDeviceUniqueId().equals(beaconUniqueId);
            }
        });
    }

    @Override
    public HttpResult<ICloudConfig> getCloudConfigForDevice(String beaconUniqueId) throws ClientException {
        return this.getCloudConfigForDevice(beaconUniqueId, (SDKOptional<ETag>)SDKOptional.absent());
    }

    @Override
    public void getCloudConfigForDevice(final String deviceUniqueId, SDKOptional<ETag> eTag, final ResultApiCallback<ICloudConfig> apiCallback) {
        RequestDescription requestDescription = RequestDescription.start().addParameter("deviceType", DeviceType.CLOUD_BEACON.name()).setETag(eTag.isPresent() ? (ETag)eTag.get() : null).build();
        this.listCloudConfigs(requestDescription, new ResultApiCallback<List<ICloudConfig>>(){

            @Override
            public void onSuccess(HttpResult<List<ICloudConfig>> result) {
                HttpResult<ICloudConfig> httpResult = ConfigurationApiAccessorImpl.this.selectFirstOrReturnAbsent(result, new SDKPredicate<ICloudConfig>(){

                    public boolean test(ICloudConfig object) {
                        return object.getDeviceUniqueId().equals(deviceUniqueId);
                    }
                });
                if (httpResult.isPresent()) {
                    apiCallback.onSuccess(httpResult);
                } else {
                    this.onFailure(new ClientException("No pending config found for the device."));
                }
            }

            @Override
            public void onFailure(ClientException e) {
                apiCallback.onFailure(e);
            }
        });
    }

    @Override
    public void getCloudConfigForDevice(String beaconUniqueId, ResultApiCallback<ICloudConfig> apiCallback) {
        this.getCloudConfigForDevice(beaconUniqueId, (SDKOptional<ETag>)SDKOptional.absent(), apiCallback);
    }
}

