/*
 * Decompiled with CFR 0.152.
 */
package com.kontakt.sdk.android.http;

import com.kontakt.sdk.android.common.interfaces.SDKFunction;
import com.kontakt.sdk.android.common.model.EventPacket;
import com.kontakt.sdk.android.common.model.INamespace;
import com.kontakt.sdk.android.common.model.IProximityUUID;
import com.kontakt.sdk.android.common.model.Namespace;
import com.kontakt.sdk.android.common.model.ProximityUUID;
import com.kontakt.sdk.android.common.util.HttpUtils;
import com.kontakt.sdk.android.common.util.SDKOptional;
import com.kontakt.sdk.android.common.util.SDKPreconditions;
import com.kontakt.sdk.android.http.AbstractApiAccessor;
import com.kontakt.sdk.android.http.ETag;
import com.kontakt.sdk.android.http.HttpResult;
import com.kontakt.sdk.android.http.RequestDescription;
import com.kontakt.sdk.android.http.exception.ClientException;
import com.kontakt.sdk.android.http.interfaces.CommonApiAccessor;
import com.kontakt.sdk.android.http.interfaces.ResultApiCallback;
import java.util.Collections;
import java.util.List;
import java.util.UUID;
import org.json.JSONObject;

final class CommonApiAccessorImpl
extends AbstractApiAccessor
implements CommonApiAccessor {
    CommonApiAccessorImpl(String apiKey, String apiUrl) {
        super(apiKey, apiUrl);
    }

    @Override
    public HttpResult<List<IProximityUUID>> listProximities() throws ClientException {
        return this.listProximities((SDKOptional<ETag>)SDKOptional.absent());
    }

    @Override
    public HttpResult<List<IProximityUUID>> listProximities(SDKOptional<ETag> eTag) throws ClientException {
        return this.resolveProximities((List<UUID>)Collections.EMPTY_LIST, eTag);
    }

    @Override
    public void listProximities(ResultApiCallback<List<IProximityUUID>> apiCallback) {
        this.listProximities((SDKOptional<ETag>)SDKOptional.absent(), apiCallback);
    }

    @Override
    public void listProximities(SDKOptional<ETag> etag, ResultApiCallback<List<IProximityUUID>> apiCallback) {
        this.resolveProximities(Collections.EMPTY_LIST, etag, apiCallback);
    }

    @Override
    public HttpResult<List<IProximityUUID>> resolveProximities(List<UUID> proximities) throws ClientException {
        return this.resolveProximities(proximities, (SDKOptional<ETag>)SDKOptional.absent());
    }

    @Override
    public HttpResult<List<IProximityUUID>> resolveProximities(List<UUID> proximities, SDKOptional<ETag> etag) throws ClientException {
        try {
            SDKPreconditions.checkNotNull(proximities, (Object)"Arguments array is null.");
            RequestDescription.Descriptor builder = RequestDescription.start().setETag(etag.isPresent() ? (ETag)etag.get() : null);
            if (!proximities.isEmpty()) {
                builder.addParameters(HttpUtils.toUrlParameterList((String)"proximity", proximities));
            }
            RequestDescription requestDescription = builder.build();
            return this.getAndTransform("proximities", requestDescription, new SDKFunction<JSONObject, List<IProximityUUID>>(){

                public List<IProximityUUID> apply(JSONObject object) {
                    return ProximityUUID.fromList((JSONObject)object);
                }
            });
        }
        catch (Exception e) {
            throw new ClientException(e);
        }
    }

    @Override
    public void resolveProximities(List<UUID> proximities, ResultApiCallback<List<IProximityUUID>> apiCallback) {
        this.resolveProximities(proximities, (SDKOptional<ETag>)SDKOptional.absent(), apiCallback);
    }

    @Override
    public void resolveProximities(List<UUID> proximities, SDKOptional<ETag> etag, ResultApiCallback<List<IProximityUUID>> apiCallback) {
        SDKPreconditions.checkNotNull(proximities, (Object)"Arguments array is null.");
        RequestDescription.Descriptor builder = RequestDescription.start().setETag(etag.isPresent() ? (ETag)etag.get() : null);
        if (!proximities.isEmpty()) {
            builder.addParameters(HttpUtils.toUrlParameterList((String)"proximity", proximities));
        }
        RequestDescription requestDescription = builder.build();
        this.getAsync("proximities", requestDescription, 200, apiCallback, JSON_OBJECT_EXTRACT_FUNCTION, new SDKFunction<JSONObject, List<IProximityUUID>>(){

            public List<IProximityUUID> apply(JSONObject object) {
                return ProximityUUID.fromList((JSONObject)object);
            }
        });
    }

    @Override
    public HttpResult<List<INamespace>> listNamespaces() throws ClientException {
        return this.listNamespaces((SDKOptional<ETag>)SDKOptional.absent());
    }

    @Override
    public HttpResult<List<INamespace>> listNamespaces(SDKOptional<ETag> etag) throws ClientException {
        return this.resolveNamespaces((List<String>)Collections.EMPTY_LIST, etag);
    }

    @Override
    public void listNamespaces(ResultApiCallback<List<INamespace>> apiCallback) {
        this.listNamespaces((SDKOptional<ETag>)SDKOptional.absent(), apiCallback);
    }

    @Override
    public void listNamespaces(SDKOptional<ETag> etag, ResultApiCallback<List<INamespace>> apiCallback) {
        this.resolveNamespaces(Collections.EMPTY_LIST, etag, apiCallback);
    }

    @Override
    public HttpResult<List<INamespace>> resolveNamespaces(List<String> namespaces) throws ClientException {
        return this.resolveNamespaces(namespaces, (SDKOptional<ETag>)SDKOptional.absent());
    }

    @Override
    public HttpResult<List<INamespace>> resolveNamespaces(List<String> namespaces, SDKOptional<ETag> etag) throws ClientException {
        try {
            SDKPreconditions.checkNotNull(namespaces, (Object)"Arguments array is null.");
            RequestDescription.Descriptor builder = RequestDescription.start().setETag(etag.isPresent() ? (ETag)etag.get() : null);
            if (!namespaces.isEmpty()) {
                builder.addParameters(HttpUtils.toUrlParameterList((String)"namespace", namespaces));
            }
            RequestDescription requestDescription = builder.build();
            return this.getAndTransform("namespaces", requestDescription, new SDKFunction<JSONObject, List<INamespace>>(){

                public List<INamespace> apply(JSONObject object) {
                    return Namespace.fromList((JSONObject)object);
                }
            });
        }
        catch (Exception e) {
            throw new ClientException(e);
        }
    }

    @Override
    public void resolveNamespaces(List<String> namespaces, ResultApiCallback<List<INamespace>> apiCallback) {
        this.resolveNamespaces(namespaces, (SDKOptional<ETag>)SDKOptional.absent(), apiCallback);
    }

    @Override
    public void resolveNamespaces(List<String> namespaces, SDKOptional<ETag> etag, ResultApiCallback<List<INamespace>> apiCallback) {
        SDKPreconditions.checkNotNull(namespaces, (Object)"Arguments array is null.");
        RequestDescription.Descriptor builder = RequestDescription.start().setETag(etag.isPresent() ? (ETag)etag.get() : null);
        if (!namespaces.isEmpty()) {
            builder.addParameters(HttpUtils.toUrlParameterList((String)"namespace", namespaces));
        }
        RequestDescription requestDescription = builder.build();
        this.getAsync("namespaces", requestDescription, 200, apiCallback, JSON_OBJECT_EXTRACT_FUNCTION, new SDKFunction<JSONObject, List<INamespace>>(){

            public List<INamespace> apply(JSONObject object) {
                return Namespace.fromList((JSONObject)object);
            }
        });
    }

    @Override
    public int sendEvents(EventPacket eventPacket) throws ClientException {
        RequestDescription requestDescription = RequestDescription.start().build();
        return this.postAndReturnHttpStatus("event/collect", requestDescription, eventPacket, new SDKFunction<EventPacket, JSONObject>(){

            public JSONObject apply(EventPacket packet) {
                return EventPacket.toJSONObject((EventPacket)packet);
            }
        });
    }
}

