/*
 * Decompiled with CFR 0.152.
 */
package com.kontakt.sdk.android.http;

import android.util.Base64;
import com.kontakt.sdk.android.common.FileData;
import com.kontakt.sdk.android.common.interfaces.SDKFunction;
import com.kontakt.sdk.android.common.model.BrowserAction;
import com.kontakt.sdk.android.common.model.ContentAction;
import com.kontakt.sdk.android.common.model.IAction;
import com.kontakt.sdk.android.common.model.IBrowserAction;
import com.kontakt.sdk.android.common.model.IContentAction;
import com.kontakt.sdk.android.common.util.ConversionUtils;
import com.kontakt.sdk.android.common.util.HttpUtils;
import com.kontakt.sdk.android.common.util.SDKOptional;
import com.kontakt.sdk.android.http.AbstractApiAccessor;
import com.kontakt.sdk.android.http.ETag;
import com.kontakt.sdk.android.http.ExtractUtils;
import com.kontakt.sdk.android.http.HttpResult;
import com.kontakt.sdk.android.http.RequestDescription;
import com.kontakt.sdk.android.http.data.ActionData;
import com.kontakt.sdk.android.http.exception.ClientException;
import com.kontakt.sdk.android.http.interfaces.ActionsApiAccessor;
import com.kontakt.sdk.android.http.interfaces.ResultApiCallback;
import com.kontakt.sdk.android.http.interfaces.UpdateApiCallback;
import com.squareup.okhttp.Response;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.json.JSONException;
import org.json.JSONObject;

final class ActionsApiAccessorImpl
extends AbstractApiAccessor
implements ActionsApiAccessor {
    ActionsApiAccessorImpl(String apiKey, String apiUrl) {
        super(apiKey, apiUrl);
    }

    @Override
    public HttpResult<IContentAction> createContentAction(ActionData actionData, File file) throws ClientException {
        try {
            RequestDescription desc = RequestDescription.start().addParameters(actionData.getParameters()).addParameter("file", Base64.encodeToString((byte[])ConversionUtils.convert((File)file), (int)0)).build();
            return this.createAndTransform("action/create", desc, new SDKFunction<JSONObject, IContentAction>(){

                public ContentAction apply(JSONObject object) {
                    return ContentAction.from((JSONObject)object);
                }
            });
        }
        catch (IOException e) {
            throw new ClientException(e);
        }
    }

    @Override
    public void createContentAction(ActionData actionData, File contentFile, ResultApiCallback<IContentAction> apiCallback) {
        try {
            RequestDescription desc = RequestDescription.start().addParameters(actionData.getParameters()).addParameter("file", Base64.encodeToString((byte[])ConversionUtils.convert((File)contentFile), (int)0)).build();
            this.postAsyncAndBuildFromJSONObject("action/create", desc, 201, apiCallback, new SDKFunction<JSONObject, IContentAction>(){

                public ContentAction apply(JSONObject object) {
                    return ContentAction.from((JSONObject)object);
                }
            });
        }
        catch (IOException e) {
            apiCallback.onFailure(new ClientException(e));
        }
    }

    @Override
    public HttpResult<IBrowserAction> createBrowserAction(ActionData actionData) throws ClientException {
        return this.createAndTransform("action/create", actionData, new SDKFunction<JSONObject, IBrowserAction>(){

            public BrowserAction apply(JSONObject object) {
                return BrowserAction.from((JSONObject)object);
            }
        });
    }

    @Override
    public void createBrowserAction(ActionData actionData, ResultApiCallback<IBrowserAction> resultApiCallback) {
        RequestDescription desc = RequestDescription.start().addParameters(actionData.getParameters()).build();
        this.postAsyncAndBuildFromJSONObject("action/create", desc, 201, resultApiCallback, new SDKFunction<JSONObject, IBrowserAction>(){

            public BrowserAction apply(JSONObject object) {
                return BrowserAction.from((JSONObject)object);
            }
        });
    }

    @Override
    public HttpResult<IAction> getAction(UUID actionId, SDKOptional<ETag> eTag) throws ClientException {
        String uri = String.format("action/%s", actionId.toString());
        RequestDescription requestDescription = RequestDescription.start().setETag(eTag.isPresent() ? (ETag)eTag.get() : null).build();
        return this.getAndTransform(uri, requestDescription, new SDKFunction<JSONObject, IAction>(){

            public IAction apply(JSONObject object) {
                try {
                    String actionType = object.getString("actionType");
                    if ("CONTENT".equals(actionType)) {
                        return ContentAction.from((JSONObject)object);
                    }
                    if ("BROWSER".equals(actionType)) {
                        return BrowserAction.from((JSONObject)object);
                    }
                }
                catch (JSONException jSONException) {
                    // empty catch block
                }
                throw new IllegalStateException("Could not find Action Type: " + object.toString());
            }
        });
    }

    @Override
    public HttpResult<IAction> getAction(UUID actionId) throws ClientException {
        return this.getAction(actionId, (SDKOptional<ETag>)SDKOptional.absent());
    }

    @Override
    public void getAction(UUID actionId, SDKOptional<ETag> etag, ResultApiCallback<IAction> resultApiCallback) {
        String uri = String.format("action/%s", actionId.toString());
        RequestDescription requestDescription = RequestDescription.start().setETag(etag.isPresent() ? (ETag)etag.get() : null).build();
        this.getAsyncAndRetrieveFromJSONObject(uri, requestDescription, 200, resultApiCallback, new SDKFunction<JSONObject, IAction>(){

            public IAction apply(JSONObject object) {
                try {
                    String actionType = object.getString("actionType");
                    if ("CONTENT".equals(actionType)) {
                        return ContentAction.from((JSONObject)object);
                    }
                    if ("BROWSER".equals(actionType)) {
                        return BrowserAction.from((JSONObject)object);
                    }
                }
                catch (JSONException jSONException) {
                    // empty catch block
                }
                throw new IllegalStateException("Could not find Action Type: " + object.toString());
            }
        });
    }

    @Override
    public void getAction(UUID actionId, ResultApiCallback<IAction> resultApiCallback) {
        this.getAction(actionId, (SDKOptional<ETag>)SDKOptional.absent(), resultApiCallback);
    }

    @Override
    public int updateAction(UUID actionId, File file) throws ClientException {
        try {
            RequestDescription requestDescription = RequestDescription.start().addParameter("actionId", actionId.toString()).addParameter("file", Base64.encodeToString((byte[])ConversionUtils.convert((File)file), (int)0)).addHeader("Content-Type", "application/x-www-form-urlencoded").build();
            return this.postAndReturnHttpStatus("action/update", requestDescription);
        }
        catch (Exception e) {
            throw new ClientException(e);
        }
    }

    @Override
    public void updateAction(UUID actionId, File file, UpdateApiCallback callback) {
        try {
            RequestDescription requestDescription = RequestDescription.start().addParameter("actionId", actionId.toString()).addParameter("file", Base64.encodeToString((byte[])ConversionUtils.convert((File)file), (int)0)).addHeader("Content-Type", "application/x-www-form-urlencoded").build();
            this.postAsyncAndReturnHttpStatus("action/update", requestDescription, callback);
        }
        catch (Exception e) {
            callback.onFailure(new ClientException(e));
        }
    }

    @Override
    public void updateAction(UUID actionId, String url, UpdateApiCallback callback) {
        try {
            RequestDescription requestDescription = RequestDescription.start().addParameter("actionId", actionId.toString()).addParameter("url", url).build();
            this.postAsyncAndReturnHttpStatus("action/update", requestDescription, callback);
        }
        catch (Exception e) {
            callback.onFailure(new ClientException(e));
        }
    }

    @Override
    public int updateAction(UUID actionId, String url) throws ClientException {
        try {
            RequestDescription requestDescription = RequestDescription.start().addParameter("actionId", actionId.toString()).addParameter("url", url).build();
            return this.postAndReturnHttpStatus("action/update", requestDescription);
        }
        catch (Exception e) {
            throw new ClientException(e);
        }
    }

    @Override
    public int deleteAction(UUID actionId) throws ClientException {
        ArrayList<Map.Entry<String, String>> arguments = new ArrayList<Map.Entry<String, String>>(1);
        arguments.add(HttpUtils.toUrlParameter((String)"actionId", (String)actionId.toString()));
        try {
            Response httpResponse = this.post("action/delete", arguments);
            return ActionsApiAccessorImpl.httpStatusCode(httpResponse);
        }
        catch (Exception e) {
            throw new ClientException(e);
        }
    }

    @Override
    public void deleteAction(UUID actionId, UpdateApiCallback apiCallback) {
        RequestDescription requestDescription = RequestDescription.start().addParameter("actionId", actionId.toString()).build();
        this.postAsyncAndReturnHttpStatus("action/delete", requestDescription, apiCallback);
    }

    @Override
    public HttpResult<FileData> getActionContent(UUID actionId, SDKOptional<ETag> eTagOptional) throws ClientException {
        String uri = String.format("action/%s/content", actionId.toString());
        RequestDescription requestDescription = RequestDescription.start().setETag(eTagOptional.isPresent() ? (ETag)eTagOptional.get() : null).build();
        return this.getAndTransformByteArray(uri, requestDescription, new SDKFunction<byte[], FileData>(){

            public FileData apply(byte[] object) {
                return FileData.of((byte[])object);
            }
        });
    }

    @Override
    public void getActionContent(UUID actionId, SDKOptional<ETag> eTagSDKOptional, ResultApiCallback<FileData> resultApiCallback) {
        String uri = String.format("action/%s/content", actionId.toString());
        RequestDescription requestDescription = RequestDescription.start().setETag(eTagSDKOptional.isPresent() ? (ETag)eTagSDKOptional.get() : null).build();
        this.getAsyncAndRetrieveFromByteArray(uri, requestDescription, resultApiCallback, new SDKFunction<byte[], FileData>(){

            public FileData apply(byte[] object) {
                return FileData.of((byte[])object);
            }
        });
    }

    @Override
    public HttpResult<List<IAction>> getActionsForDevice(String deviceUniqueId) throws ClientException {
        RequestDescription requestDescription = RequestDescription.start().addParameter("uniqueId", deviceUniqueId).build();
        return this.getAndTransformToList("action", requestDescription, "actions", new SDKFunction<JSONObject, IAction>(){

            public IAction apply(JSONObject object) {
                return ExtractUtils.extractAction(object);
            }
        });
    }

    @Override
    public void getActionsForDevice(String deviceUniqueId, ResultApiCallback<List<IAction>> resultApiCallback) {
        RequestDescription requestDescription = RequestDescription.start().addParameter("uniqueId", deviceUniqueId).build();
        this.getAsync("action", requestDescription, new int[]{200, 204}, resultApiCallback, JSON_OBJECT_EXTRACT_FUNCTION, new SDKFunction<JSONObject, List<IAction>>(){

            public List<IAction> apply(JSONObject object) {
                return ExtractUtils.extractActions(object);
            }
        });
    }
}

