/*
 * Decompiled with CFR 0.152.
 */
package com.kontakt.sdk.android.http;

import android.net.Uri;
import android.os.Build;
import com.kontakt.sdk.android.common.interfaces.SDKFunction;
import com.kontakt.sdk.android.common.interfaces.SDKPredicate;
import com.kontakt.sdk.android.common.interfaces.SDKThrowableFunction;
import com.kontakt.sdk.android.common.log.Logger;
import com.kontakt.sdk.android.common.util.Closeables;
import com.kontakt.sdk.android.common.util.SDKOptional;
import com.kontakt.sdk.android.http.ETag;
import com.kontakt.sdk.android.http.FluentResponse;
import com.kontakt.sdk.android.http.HttpResult;
import com.kontakt.sdk.android.http.RequestDescription;
import com.kontakt.sdk.android.http.URLEncoder;
import com.kontakt.sdk.android.http.data.AbstractEntityData;
import com.kontakt.sdk.android.http.exception.ClientException;
import com.kontakt.sdk.android.http.interfaces.ResultApiCallback;
import com.kontakt.sdk.android.http.interfaces.UpdateApiCallback;
import com.squareup.okhttp.Callback;
import com.squareup.okhttp.FormEncodingBuilder;
import com.squareup.okhttp.Headers;
import com.squareup.okhttp.MediaType;
import com.squareup.okhttp.OkHttpClient;
import com.squareup.okhttp.Request;
import com.squareup.okhttp.RequestBody;
import com.squareup.okhttp.Response;
import com.squareup.okhttp.ResponseBody;
import java.io.Closeable;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.json.JSONArray;
import org.json.JSONObject;

abstract class AbstractApiAccessor
implements Closeable {
    private static final String TAG = AbstractApiAccessor.class.getSimpleName();
    static final RequestDescription DEFAULT_REQUEST_DESCRIPTION = RequestDescription.start().build();
    static final MediaType MEDIA_TYPE_APPLICATION_FORM_URLENCODED = MediaType.parse((String)"application/x-www-form-urlencoded");
    static final MediaType MEDIA_TYPE_JSON = MediaType.parse((String)"application/json; charset=utf-8");
    static final SDKThrowableFunction<ResponseBody, JSONObject, Exception> JSON_OBJECT_EXTRACT_FUNCTION = new SDKThrowableFunction<ResponseBody, JSONObject, Exception>(){

        public JSONObject apply(ResponseBody object) throws Exception {
            return new JSONObject(object.string());
        }
    };
    static final SDKThrowableFunction<ResponseBody, byte[], Exception> BYTE_ARRAY_EXTRACT_FUNCTION = new SDKThrowableFunction<ResponseBody, byte[], Exception>(){

        public byte[] apply(ResponseBody object) throws Exception {
            return object.bytes();
        }
    };
    static final SDKThrowableFunction<ResponseBody, JSONArray, Exception> JSON_ARRAY_EXTRACT_FUNCTION = new SDKThrowableFunction<ResponseBody, JSONArray, Exception>(){

        public JSONArray apply(ResponseBody object) throws Exception {
            return new JSONArray(object.string());
        }
    };
    private static final Headers EMPTY_HEADERS = new Headers.Builder().build();
    private final OkHttpClient httpClient = new OkHttpClient();
    private final Headers standardHeaders;
    private final Uri baseUri;

    protected AbstractApiAccessor(String apiKey, String apiUrl) {
        this.standardHeaders = new Headers.Builder().add("Api-Key", apiKey).add("Accept", String.format("application/vnd.com.kontakt+json; version=%d", 9)).add("x-kontakt-agent", String.format("sdk-%d-Android-%d", 9, Build.VERSION.SDK_INT)).build();
        this.baseUri = Uri.parse((String)apiUrl);
    }

    @Override
    public void close() throws IOException {
    }

    protected static <T> HttpResult<T> transformJSONToEntity(Response response, int expectedSuccessHttpStatus, SDKFunction<JSONObject, T> buildFunction) throws ClientException {
        return FluentResponse.of(response, expectedSuccessHttpStatus).transformToJSON().toSingleEntity(buildFunction);
    }

    protected static <T> HttpResult<List<T>> transformJSONToList(Response httpResponse, int expectedSuccessHttpStatus, String jsonEntry, SDKFunction<JSONObject, T> buildFunction) {
        return FluentResponse.of(httpResponse, expectedSuccessHttpStatus).transformToJSON().toList(jsonEntry, buildFunction);
    }

    protected static <T> HttpResult<List<T>> transformJSONToList(Response response, int[] expectedSucceddHttpStatuses, String jsonEntry, SDKFunction<JSONObject, T> buildFunction) {
        return FluentResponse.of(response, expectedSucceddHttpStatuses).transformToJSON().toList(jsonEntry, buildFunction);
    }

    protected static <T> HttpResult<T> transformByteArrayToHttpResult(Response response, int expectedSuccessHttpStatus, SDKFunction<byte[], T> buildFunction) throws ClientException {
        return FluentResponse.of(response, expectedSuccessHttpStatus).transformToByteArray().toHttpResult(buildFunction);
    }

    protected static <K, T> HttpResult<T> transform(Response response, int[] expectedSuccessHttpStatus, SDKThrowableFunction<ResponseBody, K, Exception> extractFunction, SDKFunction<K, T> buildFunction) throws ClientException {
        ResponseBody body = response.body();
        try {
            int httpStatus = response.code();
            HttpResult.Builder<Object> builder = new HttpResult.Builder().setHttpStatus(httpStatus);
            builder.setETagValue(response.header("ETag"));
            boolean validHttpStatusCode = false;
            for (int statusCodeIndex = 0; statusCodeIndex < expectedSuccessHttpStatus.length; ++statusCodeIndex) {
                if (httpStatus != expectedSuccessHttpStatus[statusCodeIndex]) continue;
                validHttpStatusCode = true;
            }
            if (validHttpStatusCode && response.body().contentLength() > 0L) {
                Object extractedObject = extractFunction.apply((Object)body);
                Object builtObject = buildFunction.apply(extractedObject);
                builder.setValue(builtObject);
            }
            HttpResult httpResult = builder.build();
            return httpResult;
        }
        catch (Exception e) {
            Logger.e((String)(TAG + " Error ocures during transforming"), (Throwable)e);
            throw new ClientException(e);
        }
        finally {
            try {
                Closeables.close((Closeable)body, (boolean)true);
            }
            catch (IOException iOException) {}
        }
    }

    protected static int httpStatusCode(Response httpResponse) {
        try {
            int n = httpResponse.code();
            return n;
        }
        finally {
            try {
                Closeables.close((Closeable)httpResponse.body(), (boolean)true);
            }
            catch (IOException iOException) {}
        }
    }

    final Response post(String uri, Headers headers, List<Map.Entry<String, String>> bodyParametersMap) throws Exception {
        Request request = this.buildPostRequest(uri, headers, bodyParametersMap);
        return this.httpClient.newCall(request).execute();
    }

    final <T> Response post(String uri, RequestDescription requestDescription, T data, SDKFunction<T, JSONObject> toJSON) throws ClientException {
        try {
            JSONObject payload = (JSONObject)toJSON.apply(data);
            Request request = this.buildPostRequest(uri, requestDescription.getHeaders(), payload);
            return this.httpClient.newCall(request).execute();
        }
        catch (Exception e) {
            throw new ClientException(e);
        }
    }

    final <T> int postAndReturnHttpStatus(String uri, RequestDescription requestDescription, T data, SDKFunction<T, JSONObject> toJSON) throws ClientException {
        Response response = this.post(uri, requestDescription, data, toJSON);
        return AbstractApiAccessor.httpStatusCode(response);
    }

    final <T> void postAsyncAndBuildFromJSONObject(String uri, RequestDescription description, int expectedHttpStatus, ResultApiCallback<T> apiCallback, SDKFunction<JSONObject, T> buildFunction) {
        this.postAsync(uri, description, new int[]{expectedHttpStatus}, apiCallback, JSON_OBJECT_EXTRACT_FUNCTION, buildFunction);
    }

    final <T> void postAsyncAndBuildFromJSONObject(String uri, RequestDescription description, int[] expectedHttpStatuses, ResultApiCallback<T> apiCallback, SDKFunction<JSONObject, T> buildFunction) {
        this.postAsync(uri, description, expectedHttpStatuses, apiCallback, JSON_OBJECT_EXTRACT_FUNCTION, buildFunction);
    }

    final void postAsyncAndReturnHttpStatus(String uri, RequestDescription requestDescription, final UpdateApiCallback updateApiCallback) {
        Request request = this.buildPostRequest(uri, requestDescription.getHeaders(), requestDescription.getParameters());
        this.httpClient.newCall(request).enqueue(new Callback(){

            public void onFailure(Request request, IOException e) {
                updateApiCallback.onFailure(new ClientException(e));
            }

            public void onResponse(Response response) throws IOException {
                try {
                    updateApiCallback.onSuccess(AbstractApiAccessor.httpStatusCode(response));
                }
                catch (Exception e) {
                    updateApiCallback.onFailure(new ClientException(response.code(), (Throwable)e));
                }
            }
        });
    }

    final <K, T> void postAsync(String uri, RequestDescription requestDescription, int expectedHttpStatus, ResultApiCallback<T> apiCallback, SDKThrowableFunction<ResponseBody, K, Exception> extractFunction, SDKFunction<K, T> buildFunction) {
        this.postAsync(uri, requestDescription, new int[]{expectedHttpStatus}, apiCallback, extractFunction, buildFunction);
    }

    final <K, T> void postAsync(String uri, RequestDescription requestDescription, final int[] expectedHttpStatus, final ResultApiCallback<T> apiCallback, final SDKThrowableFunction<ResponseBody, K, Exception> extractFunction, final SDKFunction<K, T> buildFunction) {
        Request request = this.buildPostRequest(uri, requestDescription.getHeaders(), requestDescription.getParameters());
        this.httpClient.newCall(request).enqueue(new Callback(){

            public void onFailure(Request request, IOException e) {
                apiCallback.onFailure(new ClientException(e));
            }

            public void onResponse(Response response) throws IOException {
                try {
                    apiCallback.onSuccess(AbstractApiAccessor.transform(response, expectedHttpStatus, extractFunction, buildFunction));
                }
                catch (Exception e) {
                    apiCallback.onFailure(new ClientException(response.code(), (Throwable)e));
                }
            }
        });
    }

    final Response post(String uri, List<Map.Entry<String, String>> bodyParametersMap) throws Exception {
        return this.post(uri, EMPTY_HEADERS, bodyParametersMap);
    }

    final Response get(String uri, Headers headers, List<Map.Entry<String, String>> parameters) throws Exception {
        Request request = this.buildGetRequest(uri, headers, parameters);
        return this.httpClient.newCall(request).execute();
    }

    final Response get(String uri, Headers headers) throws Exception {
        return this.get(uri, headers, Collections.<Map.Entry<String, String>>emptyList());
    }

    final Response get(String uri) throws Exception {
        return this.get(uri, EMPTY_HEADERS);
    }

    final <T> void getAsyncAndRetrieveFromJSONObject(String uri, RequestDescription desc, int expectedHttpStatus, ResultApiCallback<T> apiCallback, SDKFunction<JSONObject, T> buildFunction) {
        this.getAsync(uri, desc, expectedHttpStatus, apiCallback, JSON_OBJECT_EXTRACT_FUNCTION, buildFunction);
    }

    final <T> void getAsyncAndRetrieveFromByteArray(String uri, RequestDescription desc, ResultApiCallback<T> apiCallback, SDKFunction<byte[], T> buildFunction) {
        this.getAsync(uri, desc, 200, apiCallback, BYTE_ARRAY_EXTRACT_FUNCTION, buildFunction);
    }

    final <K, T> void getAsync(String uri, RequestDescription requestDescription, final int[] expectedHttpStatus, final ResultApiCallback<T> apiCallback, final SDKThrowableFunction<ResponseBody, K, Exception> extractFunction, final SDKFunction<K, T> buildFunction) {
        Request request = this.buildGetRequest(uri, requestDescription.getHeaders(), requestDescription.getParameters());
        this.httpClient.newCall(request).enqueue(new Callback(){

            public void onFailure(Request request, IOException e) {
                apiCallback.onFailure(new ClientException(e));
            }

            public void onResponse(Response response) throws IOException {
                try {
                    apiCallback.onSuccess(AbstractApiAccessor.transform(response, expectedHttpStatus, extractFunction, buildFunction));
                }
                catch (Exception e) {
                    apiCallback.onFailure(new ClientException(response.code(), (Throwable)e));
                }
            }
        });
    }

    final <K, T> void getAsync(String uri, RequestDescription requestDescription, int expectedHttpStatus, ResultApiCallback<T> apiCallback, SDKThrowableFunction<ResponseBody, K, Exception> extractFunction, SDKFunction<K, T> buildFunction) {
        this.getAsync(uri, requestDescription, new int[]{expectedHttpStatus}, apiCallback, extractFunction, buildFunction);
    }

    final <T> void transformToListAsynchronously(String uri, RequestDescription requestDescription, final int expectedHttpStatus, final String jsonEntry, final ResultApiCallback<List<T>> apiCallback, final SDKFunction<JSONObject, T> buildFunction) {
        Request request = this.buildGetRequest(uri, requestDescription.getHeaders(), requestDescription.getParameters());
        this.httpClient.newCall(request).enqueue(new Callback(){

            public void onFailure(Request request, IOException e) {
                apiCallback.onFailure(new ClientException(e));
            }

            public void onResponse(Response response) throws IOException {
                try {
                    apiCallback.onSuccess(AbstractApiAccessor.transformJSONToList(response, expectedHttpStatus, jsonEntry, buildFunction));
                }
                catch (Exception e) {
                    apiCallback.onFailure(new ClientException(response.code(), (Throwable)e));
                }
            }
        });
    }

    protected <T> HttpResult<T> getAndTransform(String uri, RequestDescription requestDescription, SDKFunction<JSONObject, T> convertFunction) throws ClientException {
        try {
            Response httpResponse = this.get(uri, requestDescription.getHeaders(), requestDescription.getParameters());
            return AbstractApiAccessor.transformJSONToEntity(httpResponse, 200, convertFunction);
        }
        catch (Exception e) {
            throw new ClientException(e);
        }
    }

    protected <T> HttpResult<T> getAndTransformByteArray(String uri, RequestDescription requestDescription, SDKFunction<byte[], T> convertFunction) throws ClientException {
        try {
            Response httpResponse = this.get(uri, requestDescription.getHeaders(), requestDescription.getParameters());
            return AbstractApiAccessor.transformByteArrayToHttpResult(httpResponse, 200, convertFunction);
        }
        catch (Exception e) {
            throw new ClientException(e);
        }
    }

    protected <T> HttpResult<T> selectFirstOrReturnAbsent(HttpResult<List<T>> listedRecordsResult, SDKPredicate<T> predicate) {
        HttpResult.Builder httpResultBuilder = new HttpResult.Builder();
        httpResultBuilder.setHttpStatus(listedRecordsResult.getStatusCode());
        if (listedRecordsResult.isETagPresent()) {
            httpResultBuilder.setETagValue(listedRecordsResult.getETag().getValue());
        }
        if (!listedRecordsResult.isPresent()) {
            return httpResultBuilder.build();
        }
        List<T> records = listedRecordsResult.get();
        for (T record : records) {
            if (!predicate.test(record)) continue;
            return httpResultBuilder.setHttpStatus(200).setValue(record).build();
        }
        return httpResultBuilder.build();
    }

    protected <T> HttpResult<List<T>> getAndTransformToList(String uri, RequestDescription requestDescription, String jsonEntry, SDKFunction<JSONObject, T> function) throws ClientException {
        Response httpResponse = null;
        try {
            httpResponse = this.get(uri, requestDescription.getHeaders(), requestDescription.getParameters());
            HttpResult<List<T>> httpResult = AbstractApiAccessor.transformJSONToList(httpResponse, 200, jsonEntry, function);
            this.closeSilently(httpResponse);
            return httpResult;
        }
        catch (Exception e) {
            try {
                Logger.e((String)(TAG + " Error ocures when get called"), (Throwable)e);
                throw new ClientException(e);
            }
            catch (Throwable throwable) {
                this.closeSilently(httpResponse);
                throw throwable;
            }
        }
    }

    protected <T> HttpResult<List<T>> getAndTransformToList(String uri, RequestDescription requestDescription, int[] expectedStatuses, String jsonEntry, SDKFunction<JSONObject, T> function) throws ClientException {
        Response response = null;
        try {
            response = this.get(uri, requestDescription.getHeaders(), requestDescription.getParameters());
            HttpResult<List<T>> httpResult = AbstractApiAccessor.transformJSONToList(response, expectedStatuses, jsonEntry, function);
            this.closeSilently(response);
            return httpResult;
        }
        catch (Exception e) {
            try {
                throw new ClientException(e);
            }
            catch (Throwable throwable) {
                this.closeSilently(response);
                throw throwable;
            }
        }
    }

    protected <T> HttpResult<List<T>> postAndTransformToList(String uri, RequestDescription requestDescription, int[] expectedStatuses, String jsonEntry, SDKFunction<JSONObject, T> function) throws ClientException {
        Response response = null;
        try {
            response = this.post(uri, requestDescription.getHeaders(), requestDescription.getParameters());
            HttpResult<List<T>> httpResult = AbstractApiAccessor.transformJSONToList(response, expectedStatuses, jsonEntry, function);
            this.closeSilently(response);
            return httpResult;
        }
        catch (Exception e) {
            try {
                throw new ClientException(e);
            }
            catch (Throwable throwable) {
                this.closeSilently(response);
                throw throwable;
            }
        }
    }

    protected <T> HttpResult<T> createAndTransform(String uri, AbstractEntityData entityData, SDKFunction<JSONObject, T> convertFunction) throws ClientException {
        Response httpResponse = null;
        try {
            httpResponse = this.post(uri, entityData.getParameters());
            HttpResult<T> httpResult = AbstractApiAccessor.transformJSONToEntity(httpResponse, 201, convertFunction);
            this.closeSilently(httpResponse);
            return httpResult;
        }
        catch (Exception e) {
            try {
                throw new ClientException(e);
            }
            catch (Throwable throwable) {
                this.closeSilently(httpResponse);
                throw throwable;
            }
        }
    }

    protected <T> HttpResult<T> createAndTransform(String uri, RequestDescription requestDescription, SDKFunction<JSONObject, T> convertFunction) throws ClientException {
        Response httpResponse = null;
        try {
            httpResponse = this.post(uri, requestDescription.getHeaders(), requestDescription.getParameters());
            HttpResult<T> httpResult = AbstractApiAccessor.transformJSONToEntity(httpResponse, 201, convertFunction);
            this.closeSilently(httpResponse);
            return httpResult;
        }
        catch (Exception e) {
            try {
                throw new ClientException(e);
            }
            catch (Throwable throwable) {
                this.closeSilently(httpResponse);
                throw throwable;
            }
        }
    }

    protected <K, T> HttpResult<T> createAndTransform(String uri, AbstractEntityData entityData, SDKThrowableFunction<ResponseBody, K, Exception> convertFunction, SDKFunction<K, T> buildFunction) throws ClientException {
        Response response = null;
        try {
            response = this.post(uri, entityData.getParameters());
            HttpResult<T> httpResult = AbstractApiAccessor.transform(response, new int[]{201}, convertFunction, buildFunction);
            this.closeSilently(response);
            return httpResult;
        }
        catch (Exception e) {
            try {
                throw new ClientException(e);
            }
            catch (Throwable throwable) {
                this.closeSilently(response);
                throw throwable;
            }
        }
    }

    protected <K, T> HttpResult<T> getAndTransformToList(String uri, RequestDescription requestDescription, SDKThrowableFunction<ResponseBody, K, Exception> convertFunction, SDKFunction<K, T> buildFunction) throws ClientException {
        Response response = null;
        try {
            response = this.get(uri, requestDescription.getHeaders(), requestDescription.getParameters());
            HttpResult<T> httpResult = AbstractApiAccessor.transform(response, new int[]{200}, convertFunction, buildFunction);
            this.closeSilently(response);
            return httpResult;
        }
        catch (Exception e) {
            try {
                throw new ClientException(e);
            }
            catch (Throwable throwable) {
                this.closeSilently(response);
                throw throwable;
            }
        }
    }

    protected int postAndReturnHttpStatus(String uri, RequestDescription requestDescription) throws ClientException {
        Response httpResponse = null;
        try {
            httpResponse = this.post(uri, requestDescription.getHeaders(), requestDescription.getParameters());
            int n = AbstractApiAccessor.httpStatusCode(httpResponse);
            this.closeSilently(httpResponse);
            return n;
        }
        catch (Exception e) {
            try {
                throw new ClientException(e);
            }
            catch (Throwable throwable) {
                this.closeSilently(httpResponse);
                throw throwable;
            }
        }
    }

    private Request buildPostRequest(String uri, Headers headers, List<Map.Entry<String, String>> parameters) {
        Headers.Builder headersBuilder = this.standardHeaders.newBuilder();
        for (String headerName : headers.names()) {
            headersBuilder.add(headerName, headers.get(headerName));
        }
        Headers requestHeaders = headersBuilder.build();
        Request.Builder requestBuilder = new Request.Builder().post(AbstractApiAccessor.convertToRequestBody(parameters)).url(this.baseUri.buildUpon().appendEncodedPath(URLEncoder.encodeUrl(uri)).build().toString()).headers(requestHeaders);
        for (String headerName : headers.names()) {
            requestBuilder.addHeader(headerName, headers.get(headerName));
        }
        return requestBuilder.build();
    }

    private Request buildPostRequest(String uri, Headers headers, JSONObject payload) {
        Headers.Builder headersBuilder = this.standardHeaders.newBuilder();
        for (String headerName : headers.names()) {
            headersBuilder.add(headerName, headers.get(headerName));
        }
        Headers requestHeaders = headersBuilder.build();
        RequestBody body = RequestBody.create((MediaType)MEDIA_TYPE_JSON, (String)payload.toString());
        Request.Builder requestBuilder = new Request.Builder().post(body).url(this.baseUri.buildUpon().appendEncodedPath(URLEncoder.encodeUrl(uri)).build().toString()).headers(requestHeaders);
        return requestBuilder.build();
    }

    private Request buildGetRequest(String uri, Headers headers, List<Map.Entry<String, String>> parameters) {
        Uri.Builder uriBuilder = this.baseUri.buildUpon().appendEncodedPath(URLEncoder.encodeUrl(uri));
        for (Map.Entry<String, String> entry : parameters) {
            uriBuilder.appendQueryParameter(entry.getKey(), entry.getValue());
        }
        Headers.Builder headersBuilder = this.standardHeaders.newBuilder();
        for (String headerName : headers.names()) {
            headersBuilder.add(headerName, headers.get(headerName));
        }
        Headers headers2 = headersBuilder.build();
        return new Request.Builder().url(uriBuilder.build().toString()).headers(headers2).build();
    }

    private void closeSilently(Response httpResponse) {
        if (httpResponse != null) {
            try {
                httpResponse.body().close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    private static RequestBody convertToRequestBody(List<Map.Entry<String, String>> parameterList) {
        if (parameterList.isEmpty()) {
            return RequestBody.create((MediaType)MEDIA_TYPE_APPLICATION_FORM_URLENCODED, (String)"");
        }
        FormEncodingBuilder requestBodyBuilder = new FormEncodingBuilder();
        for (Map.Entry<String, String> entry : parameterList) {
            String value = entry.getValue();
            if (value == null) continue;
            requestBodyBuilder.add(entry.getKey(), value);
        }
        return requestBodyBuilder.build();
    }

    static RequestDescription returnDescriptionWithEtagOrDefault(SDKOptional<ETag> etag) {
        return etag.isPresent() ? RequestDescription.start().setETag((ETag)etag.get()).build() : DEFAULT_REQUEST_DESCRIPTION;
    }

    static Headers returnEmptyOrRequestETagHeader(SDKOptional<ETag> eTagOptional) {
        Headers.Builder builder = new Headers.Builder();
        if (eTagOptional.isPresent()) {
            ETag object = (ETag)eTagOptional.get();
            builder.add(object.getRequestName(), object.getValue());
        }
        return builder.build();
    }
}

