package com.kontakt.sdk.android.http.data;


import com.kontakt.sdk.android.common.Proximity;
import com.kontakt.sdk.android.common.model.IAction;
import com.kontakt.sdk.android.common.util.SDKPreconditions;

/**
 * Action data provides dataset that may be included to
 * perform CRUD operations with Action resource.
 */
public final class ActionData extends AbstractEntityData {

    private static final String PROXIMITY_PARAMETER = "proximity";
    private static final String UNIQUE_ID_PARAMETER = "uniqueId";
    private static final String ACTION_TYPE_PARAMETER = "actionType";
    private static final String URL_PARAMETER = "url";

    /**
     * Creates Content Action data.
     *
     * @param proximity      the proximity
     * @param deviceUniqueId the device unique id
     * @return the action data
     */
    public static ActionData createContentAction(final Proximity proximity,
                                                 final String deviceUniqueId) {
        SDKPreconditions.checkNotNull(proximity, "Proximity is null");
        SDKPreconditions.checkNotNullOrEmpty(deviceUniqueId, "Device Unique Id is null or empty.");

        return new ActionData(new EntityData.Builder()
                .addParameter(PROXIMITY_PARAMETER, proximity.name())
                .addParameter(UNIQUE_ID_PARAMETER, deviceUniqueId)
                .addParameter(ACTION_TYPE_PARAMETER, IAction.ActionType.CONTENT.name())
                .build());
    }

    /**
     * Creates Browser Action data.
     *
     * @param proximity      the proximity
     * @param deviceUniqueId the device unique id
     * @param url            the url
     * @return the action data
     */
    public static ActionData createBrowserAction(final Proximity proximity,
                                                 final String deviceUniqueId,
                                                 final String url) {
        SDKPreconditions.checkNotNull(proximity);
        SDKPreconditions.checkNotNullOrEmpty(deviceUniqueId, "Device Unique Id is null");
        SDKPreconditions.checkNotNullOrEmpty(url, "Url is empty");

        return new ActionData(new EntityData.Builder()
                .addParameter(PROXIMITY_PARAMETER, proximity.name())
                .addParameter(UNIQUE_ID_PARAMETER, deviceUniqueId)
                .addParameter(URL_PARAMETER, url)
                .addParameter(ACTION_TYPE_PARAMETER, IAction.ActionType.BROWSER.name())
                .build());
    }

    private ActionData(EntityData entityData) {
        super(entityData);
    }
}
