package com.kontakt.sdk.android.http;

import com.kontakt.sdk.android.common.model.BrowserAction;
import com.kontakt.sdk.android.common.model.ContentAction;
import com.kontakt.sdk.android.common.model.IAction;
import com.kontakt.sdk.android.common.model.IBrowserAction;
import com.kontakt.sdk.android.common.model.IContentAction;
import com.kontakt.sdk.android.common.model.IPreset;
import com.kontakt.sdk.android.common.model.Preset;
import com.kontakt.sdk.android.common.util.JSONUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

final class ExtractUtils {

    private static final String PRESETS = "presets";

    private ExtractUtils() {

    }

    static List<IAction> extractActions(JSONObject jsonObject) {
        JSONArray jsonArray = JSONUtils.getJSONArray(jsonObject, ApiConstants.Actions.ACTIONS, null);

        if (jsonArray == null) {
            return new ArrayList<IAction>();
        }
        List<IAction> actions = new ArrayList<IAction>();

        int length = jsonArray.length();

        for (int i = 0; i < length; i++) {
            try {
                actions.add(extractAction(jsonArray.getJSONObject(i)));
            } catch (JSONException e) {
                e.printStackTrace();
            }
        }

        return actions;
    }

    static IAction extractAction(JSONObject jsonObject) {
        String actionType = JSONUtils.getStringOrNull(jsonObject, "actionType");

        IAction.ActionType type = IAction.ActionType.valueOf(actionType);

        if (IAction.ActionType.BROWSER == type) {
            return parseBrowserAction(jsonObject);
        } else if (IAction.ActionType.CONTENT == type) {
            return parseContentAction(jsonObject);
        }

        return null;
    }

    static IBrowserAction parseBrowserAction(JSONObject object) {
        return BrowserAction.from(object);
    }

    static IContentAction parseContentAction(JSONObject object) {
        return ContentAction.from(object);
    }

    static List<IPreset> toProfileList(final JSONObject object) throws JSONException {
        JSONArray array = object.getJSONArray(PRESETS);
        List<IPreset> profiles = new ArrayList<IPreset>();

        for (int i = 0, size = array.length(); i < size; i++) {
            profiles.add(Preset.from(array.getJSONObject(i)));
        }

        return Collections.unmodifiableList(profiles);
    }

}
