package com.kontakt.sdk.android.http;

import com.kontakt.sdk.android.common.interfaces.SDKFunction;
import com.kontakt.sdk.android.common.model.SecureCommandResponse;
import com.kontakt.sdk.android.common.model.SecureCommandType;
import com.kontakt.sdk.android.common.util.Constants;
import com.kontakt.sdk.android.common.util.HttpUtils;
import com.kontakt.sdk.android.http.exception.ClientException;
import com.kontakt.sdk.android.http.interfaces.CommandApiAccessor;
import com.kontakt.sdk.android.http.interfaces.ResultApiCallback;

import org.json.JSONObject;

import java.io.IOException;
import java.util.Collection;
import java.util.List;

public class CommandApiAccessorImpl extends AbstractApiAccessor implements CommandApiAccessor {


    /**
     * Instantiates a new Abstract api client delegate.
     *
     * @param apiKey the api key
     * @param apiUrl the api url
     */
    protected CommandApiAccessorImpl(String apiKey, String apiUrl) {
        super(apiKey, apiUrl);
    }

    @Override
    public HttpResult<List<SecureCommandResponse>> getSecureCommand(Collection<String> beaconUniqueIds, SecureCommandType secureCommandType) throws ClientException {

        RequestDescription description = RequestDescription.start()
                .addParameters(HttpUtils.toUrlParameterList(ApiConstants.Commands.UNIQUE_IDS_PARAMETER, beaconUniqueIds))
                .addParameter(ApiConstants.Commands.COMMAND_PARAMETER, secureCommandType.name())
                .build();

        return getAndTransform(ApiMethods.Commands.ENCRYPT, description, new SDKFunction<JSONObject, List<SecureCommandResponse>>() {
            @Override
            public List<SecureCommandResponse> apply(JSONObject object) {
                return SecureCommandResponse.fromList(object);
            }
        });
    }

    @Override
    public void getSecureCommand(Collection<String> beaconUniqueIds, SecureCommandType secureCommandType, ResultApiCallback<List<SecureCommandResponse>> apiCallback) {

        RequestDescription description = RequestDescription.start()
                .addParameters(HttpUtils.toUrlParameterList(ApiConstants.Commands.UNIQUE_IDS_PARAMETER, beaconUniqueIds))
                .addParameter(ApiConstants.Commands.COMMAND_PARAMETER, secureCommandType.name())
                .build();

        transformToListAsynchronously(ApiMethods.Commands.ENCRYPT,
                description,
                HttpUtils.SC_OK,
                Constants.Commands.COMMANDS,
                apiCallback,
                new SDKFunction<JSONObject, SecureCommandResponse>() {
                    @Override
                    public SecureCommandResponse apply(JSONObject object) {
                        return SecureCommandResponse.from(object);
                    }
                });
    }

    @Override
    public void close() throws IOException {

    }
}
