/*
 * Decompiled with CFR 0.152.
 */
package com.kontakt.sdk.android.common.util;

import java.util.Collection;

public final class SDKPreconditions {
    private SDKPreconditions() {
    }

    public static void checkArgument(boolean expression) {
        if (!expression) {
            throw new IllegalArgumentException();
        }
    }

    public static void checkArgument(boolean expression, Object errorMessage) {
        if (!expression) {
            throw new IllegalArgumentException(String.valueOf(errorMessage));
        }
    }

    public static <E extends Exception> void checkArgument(boolean expression, E exception) throws E {
        if (!expression) {
            throw exception;
        }
    }

    public static void checkArgument(boolean expression, String errorMessageTemplate, Object ... errorMessageArgs) {
        if (!expression) {
            throw new IllegalArgumentException(SDKPreconditions.format(errorMessageTemplate, errorMessageArgs));
        }
    }

    public static void checkState(boolean expression) {
        if (!expression) {
            throw new IllegalStateException();
        }
    }

    public static <E extends Exception> void checkState(boolean expression, E exception) throws E {
        if (!expression) {
            throw exception;
        }
    }

    public static void checkState(boolean expression, Object errorMessage) {
        if (!expression) {
            throw new IllegalStateException(String.valueOf(errorMessage));
        }
    }

    public static void checkState(boolean expression, String errorMessageTemplate, Object ... errorMessageArgs) {
        if (!expression) {
            throw new IllegalStateException(SDKPreconditions.format(errorMessageTemplate, errorMessageArgs));
        }
    }

    public static <T> T checkNotNull(T reference) {
        if (reference == null) {
            throw new NullPointerException();
        }
        return reference;
    }

    public static <T> T checkNotNull(T reference, Object errorMessage) {
        if (reference == null) {
            throw new NullPointerException(String.valueOf(errorMessage));
        }
        return reference;
    }

    public static <T> T checkNotNull(T reference, String errorMessageTemplate, Object ... errorMessageArgs) {
        if (reference == null) {
            throw new NullPointerException(SDKPreconditions.format(errorMessageTemplate, errorMessageArgs));
        }
        return reference;
    }

    public static <T, K extends RuntimeException> T[] checkNotAllNull(K exception, T ... references) {
        if (exception == null) {
            throw new NullPointerException("Exception cannot be null");
        }
        if (references == null) {
            throw new NullPointerException("References cannot be null");
        }
        int length = references.length;
        int foundNullReferences = 0;
        for (T reference : references) {
            if (reference != null) continue;
            ++foundNullReferences;
        }
        if (foundNullReferences == length) {
            throw exception;
        }
        return references;
    }

    public static <T> void checkNotNullOrEmpty(Collection<T> collection, String message) {
        if (collection == null || collection.isEmpty()) {
            throw new IllegalArgumentException(message);
        }
    }

    public static void checkNotNullOrEmpty(String target, String message) {
        if (target == null || target.isEmpty()) {
            throw new IllegalArgumentException(message);
        }
    }

    public static int checkElementIndex(int index, int size) {
        return SDKPreconditions.checkElementIndex(index, size, "index");
    }

    public static int checkElementIndex(int index, int size, String desc) {
        if (index < 0 || index >= size) {
            throw new IndexOutOfBoundsException(SDKPreconditions.badElementIndex(index, size, desc));
        }
        return index;
    }

    private static String badElementIndex(int index, int size, String desc) {
        if (index < 0) {
            return SDKPreconditions.format("%s (%s) must not be negative", desc, index);
        }
        if (size < 0) {
            throw new IllegalArgumentException("negative size: " + size);
        }
        return SDKPreconditions.format("%s (%s) must be less than size (%s)", desc, index, size);
    }

    public static int checkPositionIndex(int index, int size) {
        return SDKPreconditions.checkPositionIndex(index, size, "index");
    }

    public static int checkPositionIndex(int index, int size, String desc) {
        if (index < 0 || index > size) {
            throw new IndexOutOfBoundsException(SDKPreconditions.badPositionIndex(index, size, desc));
        }
        return index;
    }

    private static String badPositionIndex(int index, int size, String desc) {
        if (index < 0) {
            return SDKPreconditions.format("%s (%s) must not be negative", desc, index);
        }
        if (size < 0) {
            throw new IllegalArgumentException("negative size: " + size);
        }
        return SDKPreconditions.format("%s (%s) must not be greater than size (%s)", desc, index, size);
    }

    public static void checkPositionIndexes(int start, int end, int size) {
        if (start < 0 || end < start || end > size) {
            throw new IndexOutOfBoundsException(SDKPreconditions.badPositionIndexes(start, end, size));
        }
    }

    public static void checkAllowedSize(Collection<?> collection, int allowedSize, String message) {
        if (collection.size() > allowedSize) {
            throw new IllegalArgumentException(message);
        }
    }

    private static String badPositionIndexes(int start, int end, int size) {
        if (start < 0 || start > size) {
            return SDKPreconditions.badPositionIndex(start, size, "start index");
        }
        if (end < 0 || end > size) {
            return SDKPreconditions.badPositionIndex(end, size, "end index");
        }
        return SDKPreconditions.format("end index (%s) must not be less than start index (%s)", end, start);
    }

    private static String format(String template, Object ... args) {
        int placeholderStart;
        template = String.valueOf(template);
        StringBuilder builder = new StringBuilder(template.length() + 16 * args.length);
        int templateStart = 0;
        int i = 0;
        while (i < args.length && (placeholderStart = template.indexOf("%s", templateStart)) != -1) {
            builder.append(template.substring(templateStart, placeholderStart));
            builder.append(args[i++]);
            templateStart = placeholderStart + 2;
        }
        builder.append(template.substring(templateStart));
        if (i < args.length) {
            builder.append(" [");
            builder.append(args[i++]);
            while (i < args.length) {
                builder.append(", ");
                builder.append(args[i++]);
            }
            builder.append(']');
        }
        return builder.toString();
    }
}

