/*
 * Decompiled with CFR 0.152.
 */
package com.kontakt.sdk.android.common.util;

import com.kontakt.sdk.android.common.log.Logger;
import com.kontakt.sdk.android.common.util.Closeables;
import com.kontakt.sdk.android.common.util.SDKPreconditions;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.UUID;

public final class ConversionUtils {
    private ConversionUtils() {
    }

    public static int asInt(byte value) {
        return value & 0xFF;
    }

    public static byte[] extractSubdata(byte[] packet, int start, int length) {
        SDKPreconditions.checkNotNull(packet, "Source array is null");
        if (packet.length < start + length) {
            Logger.e("Cannot extractBytes payload. Source array is too short: " + Arrays.toString(packet));
            return null;
        }
        byte[] array = new byte[length];
        System.arraycopy(packet, start, array, 0, length);
        return array;
    }

    public static boolean doesArrayBeginWith(byte[] array, byte[] prefix) {
        if (array.length < prefix.length) {
            return false;
        }
        int size = prefix.length;
        for (int i = 0; i < size; ++i) {
            if (array[i] == prefix[i]) continue;
            return false;
        }
        return true;
    }

    public static byte[] invert(byte[] array) {
        int size = array.length;
        int limit = size / 2;
        for (int i = 0; i < limit; ++i) {
            byte temp = array[i];
            array[i] = array[size - 1 - i];
            array[size - 1 - i] = temp;
        }
        return array;
    }

    public static int asIntFromLittleEndianBytes(byte[] input) {
        SDKPreconditions.checkArgument(input != null && input.length > 0, "Input byte array is null or empty.");
        return ConversionUtils.asInt(ConversionUtils.invert(input));
    }

    public static float asFloatFromLittleEndianBytes(byte[] input) {
        SDKPreconditions.checkArgument(input != null && input.length > 0, "Input byte array is null or empty.");
        return ByteBuffer.wrap(ConversionUtils.invert(input)).getFloat();
    }

    public static int asInt(byte[] input) {
        SDKPreconditions.checkArgument(input != null && input.length > 0, "Input byte array is null or empty.");
        byte[] result = new byte[]{0, 0, 0, 0};
        switch (input.length) {
            case 1: {
                return ConversionUtils.asInt(input[0]);
            }
            case 2: {
                result[2] = input[0];
                result[3] = input[1];
                break;
            }
            case 3: {
                result[1] = input[0];
                result[2] = input[1];
                result[3] = input[2];
                break;
            }
            case 4: {
                result[0] = input[0];
                result[1] = input[1];
                result[2] = input[2];
                result[3] = input[3];
                break;
            }
            default: {
                throw new IllegalArgumentException("Input byte array exceeds max integer size (4 bytes)");
            }
        }
        return ByteBuffer.wrap(result).getInt();
    }

    public static byte[] to2ByteArray(int value) {
        return new byte[]{(byte)value, (byte)(value >> 8)};
    }

    public static byte[] convert(UUID uuid) {
        long msb = uuid.getMostSignificantBits();
        long lsb = uuid.getLeastSignificantBits();
        return ByteBuffer.allocate(16).putLong(msb).putLong(lsb).array();
    }

    public static byte[] convert(File file) throws IOException {
        SDKPreconditions.checkArgument(file.length() < Integer.MAX_VALUE, "File size is too big.");
        byte[] buffer = new byte[(int)file.length()];
        FileInputStream stream = null;
        try {
            stream = new FileInputStream(file);
            if (((InputStream)stream).read(buffer) == -1) {
                throw new IOException("EOF reached while trying to read the whole file");
            }
        }
        catch (Throwable throwable) {
            Closeables.closeQuietly(stream);
            throw throwable;
        }
        Closeables.closeQuietly(stream);
        return buffer;
    }

    public static int toPowerLevel(byte[] byteValue) {
        SDKPreconditions.checkArgument(byteValue.length == 1, "Specified value should be 1 byte long.");
        return ConversionUtils.toPowerLevel(byteValue[0]);
    }

    public static int toPowerLevel(int value) {
        switch (value) {
            case -30: {
                return 0;
            }
            case -20: {
                return 1;
            }
            case -16: {
                return 2;
            }
            case -12: {
                return 3;
            }
            case -8: {
                return 4;
            }
            case -4: {
                return 5;
            }
            case 0: {
                return 6;
            }
            case 4: {
                return 7;
            }
        }
        throw new IllegalArgumentException("Unsupported power level value.");
    }

    public static byte[] convertPowerLevel(int powerLevel) {
        switch (powerLevel) {
            case 0: {
                return new byte[]{-30};
            }
            case 1: {
                return new byte[]{-20};
            }
            case 2: {
                return new byte[]{-16};
            }
            case 3: {
                return new byte[]{-12};
            }
            case 4: {
                return new byte[]{-8};
            }
            case 5: {
                return new byte[]{-4};
            }
            case 6: {
                return new byte[]{0};
            }
            case 7: {
                return new byte[]{4};
            }
        }
        throw new IllegalArgumentException(String.format("Unsupported power level: %d", powerLevel));
    }

    public static int fromPowerLevelToDbm(int txPower) {
        SDKPreconditions.checkArgument(txPower >= 0 && txPower <= 7, "Tx Power should be between 0 and 7");
        switch (txPower) {
            case 0: {
                return -30;
            }
            case 1: {
                return -20;
            }
            case 2: {
                return -16;
            }
            case 3: {
                return -12;
            }
            case 4: {
                return -8;
            }
            case 5: {
                return -4;
            }
            case 6: {
                return 0;
            }
            case 7: {
                return 4;
            }
        }
        return -1;
    }

    public static UUID toUUID(byte[] uuid) {
        ByteBuffer byteBuffer = ByteBuffer.wrap(uuid);
        return new UUID(byteBuffer.getLong(), byteBuffer.getLong());
    }

    public static boolean doesArrayContainSubset(byte[] src, byte[] subset, int startIndex) {
        if (src == null || subset == null) {
            return false;
        }
        if (subset.length + startIndex > src.length) {
            return false;
        }
        if (startIndex < 0) {
            return false;
        }
        int size = startIndex + subset.length;
        for (int i = startIndex; i < size; ++i) {
            if (src[i] == subset[i - startIndex]) continue;
            return false;
        }
        return true;
    }

    public static boolean containsScanResponse(byte[] scanRecord) {
        return scanRecord != null && ConversionUtils.contains(scanRecord, 22) && ConversionUtils.contains(scanRecord, -48) && ConversionUtils.contains(scanRecord, 13);
    }

    public static boolean contains(byte[] source, int valueToFind) {
        for (byte b : source) {
            if (b != valueToFind) continue;
            return true;
        }
        return false;
    }

    public static byte[] hexStringToByteArray(String hexString) {
        int len = hexString.length();
        byte[] data = new byte[len / 2];
        for (int i = 0; i < len - 1; i += 2) {
            data[i / 2] = (byte)((Character.digit(hexString.charAt(i), 16) << 4) + Character.digit(hexString.charAt(i + 1), 16));
        }
        return data;
    }
}

