/*
 * Decompiled with CFR 0.152.
 */
package com.kontakt.sdk.android.common.util;

import com.kontakt.sdk.android.common.log.Logger;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;

public class ArrayUtils {
    private static final int[] EMPTY_INT_ARRAY = new int[0];
    private static final byte[] EMPTY_BYTE_ARRAY = new byte[0];

    public static int byteArrayToInt(byte[] array) {
        ByteBuffer buffer = ByteBuffer.wrap(array);
        buffer.order(ByteOrder.LITTLE_ENDIAN);
        return buffer.getInt();
    }

    public static byte[] concat(byte[] first, byte[] second) {
        int aLength = first.length;
        int bLength = second.length;
        byte[] c = new byte[aLength + bLength];
        System.arraycopy(first, 0, c, 0, aLength);
        System.arraycopy(second, 0, c, aLength, bLength);
        return c;
    }

    public static String[] concat(String[] first, String[] second) {
        int aLength = first.length;
        int bLength = second.length;
        String[] c = new String[aLength + bLength];
        System.arraycopy(first, 0, c, 0, aLength);
        System.arraycopy(second, 0, c, aLength, bLength);
        return c;
    }

    public static byte[] toPrimitive(Byte[] array) {
        if (array == null) {
            return null;
        }
        if (array.length == 0) {
            return EMPTY_BYTE_ARRAY;
        }
        byte[] result = new byte[array.length];
        for (int i = 0; i < array.length; ++i) {
            result[i] = array[i];
        }
        return result;
    }

    public static int[] toPrimitive(Integer[] array) {
        if (array == null) {
            return null;
        }
        if (array.length == 0) {
            return EMPTY_INT_ARRAY;
        }
        int[] result = new int[array.length];
        for (int i = 0; i < array.length; ++i) {
            result[i] = array[i];
        }
        return result;
    }

    public static void printByteArray(byte[] data, String s) {
        StringBuilder buffer = new StringBuilder();
        buffer.append(s).append("\n");
        for (byte datum : data) {
            buffer.append(String.format("%02X ", datum));
        }
        buffer.append("\n");
        Logger.d(buffer.toString());
    }

    public static String binaryStringOfByte(byte b) {
        return Integer.toBinaryString((b & 0xFF) + 256).substring(1);
    }
}

