/*
 * Decompiled with CFR 0.152.
 */
package com.kontakt.sdk.android.common.util;

import android.os.Build;
import android.util.Log;
import com.kontakt.sdk.android.cloud.util.StringUtils;
import java.io.IOException;
import java.util.Locale;
import okhttp3.Interceptor;
import okhttp3.MediaType;
import okhttp3.Request;
import okhttp3.Response;
import okhttp3.ResponseBody;

public class ApiUtils {
    public static Interceptor commonHeadersInterceptor(final String apiKey, final int apiVersion) {
        return new Interceptor(){

            public Response intercept(Interceptor.Chain chain) throws IOException {
                Request original = chain.request();
                Request.Builder requestBuilder = original.newBuilder().header("Accept", "application/vnd.com.kontakt+json;version=" + apiVersion).header("Api-Key", apiKey).method(original.method(), original.body());
                String kontaktAgentHeader = ApiUtils.kontaktAgentHeader();
                if (kontaktAgentHeader != null) {
                    requestBuilder.header("x-kontakt-agent", kontaktAgentHeader);
                }
                Request request = requestBuilder.build();
                return chain.proceed(request);
            }
        };
    }

    public static Interceptor loggingInterceptor() {
        return new Interceptor(){

            public Response intercept(Interceptor.Chain chain) throws IOException {
                Request request = chain.request();
                Response response = chain.proceed(request);
                String rawReponseJson = response.body().string();
                String rawRequestJson = request.toString();
                Log.d((String)"com.kontakt.sdk.android", (String)String.format("raw JSON request is: %s %s", rawRequestJson, request.url()));
                Log.d((String)"com.kontakt.sdk.android", (String)String.format("raw JSON response is: %s", rawReponseJson));
                return response.newBuilder().body(ResponseBody.create((MediaType)response.body().contentType(), (String)rawReponseJson)).build();
            }
        };
    }

    private static String kontaktAgentHeader() {
        String sdkVersion = "5.0.2";
        int systemVersion = Build.VERSION.SDK_INT;
        String agentHeader = String.format(Locale.getDefault(), "sdk-%s-Android-%d", "5.0.2", systemVersion);
        if (!StringUtils.isAsciiPrintable(agentHeader)) {
            return null;
        }
        return agentHeader;
    }
}

