/*
 * Decompiled with CFR 0.152.
 */
package com.kontakt.sdk.android.common.model;

import android.os.Parcel;
import android.os.Parcelable;
import android.text.TextUtils;
import com.kontakt.sdk.android.cloud.util.StringUtils;
import com.kontakt.sdk.android.common.Proximity;
import com.kontakt.sdk.android.common.util.HashCodeBuilder;
import com.kontakt.sdk.android.common.util.SDKEqualsBuilder;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.UUID;

public class TriggerContext
implements Parcelable {
    public static final Parcelable.Creator<TriggerContext> CREATOR = new Parcelable.Creator<TriggerContext>(){

        public TriggerContext createFromParcel(Parcel source) {
            return new TriggerContext(source);
        }

        public TriggerContext[] newArray(int size) {
            return new TriggerContext[size];
        }
    };
    private final String cooldown;
    private final String sourceId;
    private final Proximity proximity;
    private final String trackingId;
    private final UUID proximityUuid;
    private final int major;
    private final int minor;
    private final String namespace;
    private final String instanceId;

    public static Builder builder() {
        return new Builder();
    }

    TriggerContext(Builder builder) {
        this.cooldown = builder.cooldown;
        this.sourceId = builder.sourceId;
        this.proximity = builder.proximity;
        this.trackingId = builder.trackingId;
        this.proximityUuid = builder.proximityUUID;
        this.major = builder.major;
        this.minor = builder.minor;
        this.namespace = builder.namespace;
        this.instanceId = builder.instanceId;
    }

    protected TriggerContext(Parcel in) {
        this.cooldown = in.readString();
        this.sourceId = in.readString();
        int tmpProximity = in.readInt();
        this.proximity = tmpProximity == -1 ? null : Proximity.values()[tmpProximity];
        this.trackingId = in.readString();
        this.proximityUuid = (UUID)in.readSerializable();
        this.major = in.readInt();
        this.minor = in.readInt();
        this.namespace = in.readString();
        this.instanceId = in.readString();
    }

    private TriggerContext() {
        this(new Builder());
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null || !(object instanceof TriggerContext)) {
            return false;
        }
        TriggerContext triggerContext = (TriggerContext)object;
        return SDKEqualsBuilder.start().equals(this.cooldown, triggerContext.cooldown).equals(this.sourceId, triggerContext.sourceId).equals((Object)this.proximity, (Object)triggerContext.proximity).equals(this.trackingId, triggerContext.trackingId).equals(this.proximityUuid, triggerContext.proximityUuid).equals(this.major, triggerContext.major).equals(this.minor, triggerContext.minor).equals(this.namespace, triggerContext.namespace).equals(this.instanceId, triggerContext.instanceId).result();
    }

    public int hashCode() {
        return HashCodeBuilder.init().append(this.cooldown).append(this.sourceId).append((Object)this.proximity).append(this.trackingId).append(this.proximityUuid).append(this.major).append(this.minor).append(this.namespace).append(this.instanceId).build();
    }

    public String toString() {
        ArrayList<String> components = new ArrayList<String>();
        if (!TextUtils.isEmpty((CharSequence)this.trackingId)) {
            components.add("trackingId: " + this.trackingId);
        }
        if (this.proximityUuid != null) {
            components.add("proximity UUID: " + this.proximityUuid.toString());
        }
        if (this.major != -1) {
            components.add("major: " + this.major);
        }
        if (this.minor != -1) {
            components.add("minor: " + this.minor);
        }
        if (!TextUtils.isEmpty((CharSequence)this.namespace)) {
            components.add("namespace: " + this.namespace);
        }
        if (!TextUtils.isEmpty((CharSequence)this.instanceId) && !"Any instance ID".equals(this.instanceId)) {
            components.add("instanceId: " + this.instanceId);
        }
        return "TriggerContext[" + StringUtils.join(components, ",") + "]";
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        dest.writeString(this.cooldown);
        dest.writeString(this.sourceId);
        dest.writeInt(this.proximity == null ? -1 : this.proximity.ordinal());
        dest.writeString(this.trackingId);
        dest.writeSerializable((Serializable)this.proximityUuid);
        dest.writeInt(this.major);
        dest.writeInt(this.minor);
        dest.writeString(this.namespace);
        dest.writeString(this.instanceId);
    }

    public String getCooldown() {
        return this.cooldown;
    }

    public String getSourceId() {
        return this.sourceId;
    }

    public Proximity getProximity() {
        return this.proximity;
    }

    public String getTrackingId() {
        return this.trackingId;
    }

    public UUID getProximityUUID() {
        return this.proximityUuid;
    }

    public int getMajor() {
        return this.major;
    }

    public int getMinor() {
        return this.minor;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public String getInstanceId() {
        return this.instanceId;
    }

    public static class Builder {
        String cooldown;
        String sourceId;
        Proximity proximity;
        String trackingId;
        UUID proximityUUID;
        int major = -1;
        int minor = -1;
        String namespace;
        String instanceId = "Any instance ID";

        public Builder cooldown(String cooldown) {
            this.cooldown = cooldown;
            return this;
        }

        public Builder sourceId(String sourceId) {
            this.sourceId = sourceId;
            return this;
        }

        public Builder proximity(Proximity proximity) {
            this.proximity = proximity;
            return this;
        }

        public Builder trackingId(String trackingId) {
            this.trackingId = trackingId;
            return this;
        }

        public Builder proximityUUID(UUID proximityUUID) {
            this.proximityUUID = proximityUUID;
            return this;
        }

        public Builder major(int major) {
            this.major = major;
            return this;
        }

        public Builder minor(int minor) {
            this.minor = minor;
            return this;
        }

        public Builder namespace(String namespace) {
            this.namespace = namespace;
            return this;
        }

        public Builder instanceId(String instanceId) {
            this.instanceId = instanceId;
            return this;
        }

        public TriggerContext build() {
            return new TriggerContext(this);
        }
    }
}

