/*
 * Decompiled with CFR 0.152.
 */
package com.kontakt.sdk.android.common.model;

import android.os.Parcel;
import android.os.Parcelable;
import com.kontakt.sdk.android.ble.spec.Acceleration;
import com.kontakt.sdk.android.ble.spec.KontaktTelemetry;
import com.kontakt.sdk.android.common.profile.ISecureProfile;

public class FullTelemetryCollectEvent
implements Parcelable {
    public final String sourceId;
    public final String trackingId;
    public final long timestamp;
    public final int batteryLevel;
    public final Acceleration acceleration;
    public final int accelerometerSensitivity;
    public final int timeSinceDoubleTap;
    public final int timeSinceTap;
    public final int timeSinceDoubleClick;
    public final int timeSinceClick;
    public final int movementCounter;
    public final int clickCounter;
    public final int secondButtonClickCounter;
    public final int humidity;
    public final int lightIntensity;
    public final int channel;
    public final int numberOfPeopleDetected;
    public final int secondsSincePeopleDetection;
    public static final Parcelable.Creator<FullTelemetryCollectEvent> CREATOR = new Parcelable.Creator<FullTelemetryCollectEvent>(){

        public FullTelemetryCollectEvent createFromParcel(Parcel in) {
            return new FullTelemetryCollectEvent(in);
        }

        public FullTelemetryCollectEvent[] newArray(int size) {
            return new FullTelemetryCollectEvent[size];
        }
    };

    private FullTelemetryCollectEvent(String sourceId, String trackingId, KontaktTelemetry telemetry) {
        this.sourceId = sourceId;
        this.trackingId = trackingId;
        this.timestamp = telemetry.getTimestamp();
        this.batteryLevel = telemetry.getBatteryLevel();
        this.acceleration = telemetry.getAcceleration();
        this.accelerometerSensitivity = telemetry.getSensitivity();
        this.timeSinceDoubleTap = telemetry.getLastDoubleTap();
        this.timeSinceTap = telemetry.getLastTap();
        this.timeSinceDoubleClick = telemetry.getLastDoubleClick();
        this.timeSinceClick = telemetry.getLastSingleClick();
        this.movementCounter = telemetry.getCurrentMovementId();
        this.clickCounter = telemetry.getSingleClickCount();
        this.secondButtonClickCounter = telemetry.getSingleClickCount2();
        this.humidity = telemetry.getHumidity();
        this.lightIntensity = telemetry.getLightSensor();
        this.channel = telemetry.getBleChannel();
        this.numberOfPeopleDetected = telemetry.getOccupancy();
        this.secondsSincePeopleDetection = telemetry.getOccupancyDetectionTime();
    }

    private FullTelemetryCollectEvent(Parcel in) {
        this.sourceId = in.readString();
        this.trackingId = in.readString();
        this.timestamp = in.readLong();
        this.batteryLevel = in.readInt();
        this.acceleration = (Acceleration)in.readParcelable(Acceleration.class.getClassLoader());
        this.accelerometerSensitivity = in.readInt();
        this.timeSinceDoubleTap = in.readInt();
        this.timeSinceTap = in.readInt();
        this.timeSinceDoubleClick = in.readInt();
        this.timeSinceClick = in.readInt();
        this.movementCounter = in.readInt();
        this.clickCounter = in.readInt();
        this.secondButtonClickCounter = in.readInt();
        this.humidity = in.readInt();
        this.lightIntensity = in.readInt();
        this.channel = in.readInt();
        this.numberOfPeopleDetected = in.readInt();
        this.secondsSincePeopleDetection = in.readInt();
    }

    public String eventId() {
        return this.trackingId + ":" + this.batteryLevel + ":" + this.movementCounter + ":" + this.clickCounter + ":" + this.secondButtonClickCounter + ":" + this.lightIntensity + ":" + this.channel + ":" + this.numberOfPeopleDetected + ":" + this.humidity;
    }

    public static FullTelemetryCollectEvent of(ISecureProfile profile, String androidId) {
        return new FullTelemetryCollectEvent(androidId, profile.getMacAddress(), profile.getTelemetry());
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        dest.writeString(this.sourceId);
        dest.writeString(this.trackingId);
        dest.writeLong(this.timestamp);
        dest.writeInt(this.batteryLevel);
        dest.writeParcelable((Parcelable)this.acceleration, flags);
        dest.writeInt(this.accelerometerSensitivity);
        dest.writeInt(this.timeSinceDoubleTap);
        dest.writeInt(this.timeSinceTap);
        dest.writeInt(this.timeSinceDoubleClick);
        dest.writeInt(this.timeSinceClick);
        dest.writeInt(this.movementCounter);
        dest.writeInt(this.clickCounter);
        dest.writeInt(this.secondButtonClickCounter);
        dest.writeInt(this.humidity);
        dest.writeInt(this.lightIntensity);
        dest.writeInt(this.channel);
        dest.writeInt(this.numberOfPeopleDetected);
        dest.writeInt(this.secondsSincePeopleDetection);
    }
}

