/*
 * Decompiled with CFR 0.152.
 */
package com.kontakt.sdk.android.common.model;

import android.os.Parcel;
import android.os.Parcelable;
import com.kontakt.sdk.android.common.profile.RemoteBluetoothDevice;

public class BasicTelemetryCollectEvent
implements Parcelable {
    private long timestamp;
    private String sourceId;
    private String trackingId;
    private int batteryLevel;
    public static final Parcelable.Creator<BasicTelemetryCollectEvent> CREATOR = new Parcelable.Creator<BasicTelemetryCollectEvent>(){

        public BasicTelemetryCollectEvent createFromParcel(Parcel in) {
            return new BasicTelemetryCollectEvent(in);
        }

        public BasicTelemetryCollectEvent[] newArray(int size) {
            return new BasicTelemetryCollectEvent[size];
        }
    };

    private BasicTelemetryCollectEvent(long timestamp, String sourceId, String trackingId, int batteryLevel) {
        this.timestamp = timestamp;
        this.sourceId = sourceId;
        this.trackingId = trackingId;
        this.batteryLevel = batteryLevel;
    }

    private BasicTelemetryCollectEvent(Parcel in) {
        this.timestamp = in.readLong();
        this.sourceId = in.readString();
        this.trackingId = in.readString();
        this.batteryLevel = in.readInt();
    }

    public static BasicTelemetryCollectEvent of(RemoteBluetoothDevice device, String androidId) {
        return new BasicTelemetryCollectEvent(device.getTimestamp(), androidId, device.getAddress(), device.getBatteryPower());
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        dest.writeLong(this.timestamp);
        dest.writeString(this.sourceId);
        dest.writeString(this.trackingId);
        dest.writeInt(this.batteryLevel);
    }

    public int getBatteryLevel() {
        return this.batteryLevel;
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public String getSourceId() {
        return this.sourceId;
    }

    public String getTrackingId() {
        return this.trackingId;
    }
}

