/*
 * Decompiled with CFR 0.152.
 */
package com.kontakt.sdk.android.common.model;

import android.os.Parcel;
import android.os.Parcelable;
import com.kontakt.sdk.android.common.model.HttpMethod;
import com.kontakt.sdk.android.common.util.HashCodeBuilder;
import com.kontakt.sdk.android.common.util.SDKEqualsBuilder;
import java.util.HashMap;
import java.util.Map;

public class ActivityContext
implements Parcelable {
    public static final Parcelable.Creator<ActivityContext> CREATOR = new Parcelable.Creator<ActivityContext>(){

        public ActivityContext createFromParcel(Parcel source) {
            return new ActivityContext(source);
        }

        public ActivityContext[] newArray(int size) {
            return new ActivityContext[size];
        }
    };
    private final String url;
    private final HttpMethod httpMethod;
    private final Map<String, String> headers;
    private final Map<String, String> params;

    public static Builder builder() {
        return new Builder();
    }

    ActivityContext(Builder builder) {
        this.url = builder.url;
        this.httpMethod = builder.httpMethod;
        this.headers = builder.headers;
        this.params = builder.params;
    }

    protected ActivityContext(Parcel in) {
        this.url = in.readString();
        int tmpHttpMethod = in.readInt();
        this.httpMethod = tmpHttpMethod == -1 ? null : HttpMethod.values()[tmpHttpMethod];
        int headersSize = in.readInt();
        this.headers = new HashMap<String, String>(headersSize);
        for (int i = 0; i < headersSize; ++i) {
            String key = in.readString();
            String value = in.readString();
            this.headers.put(key, value);
        }
        int paramsSize = in.readInt();
        this.params = new HashMap<String, String>(paramsSize);
        for (int i = 0; i < paramsSize; ++i) {
            String key = in.readString();
            String value = in.readString();
            this.params.put(key, value);
        }
    }

    private ActivityContext() {
        this(new Builder());
    }

    public String getUrl() {
        return this.url;
    }

    public HttpMethod getHttpMethod() {
        return this.httpMethod;
    }

    public Map<String, String> getHeaders() {
        return this.headers;
    }

    public Map<String, String> getParameters() {
        return this.params;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null || !(object instanceof ActivityContext)) {
            return false;
        }
        ActivityContext activity = (ActivityContext)object;
        return SDKEqualsBuilder.start().equals(this.url, activity.url).equals((Object)this.httpMethod, (Object)activity.httpMethod).result();
    }

    public int hashCode() {
        return HashCodeBuilder.init().append(this.url).append((Object)this.httpMethod).build();
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        dest.writeString(this.url);
        dest.writeInt(this.httpMethod == null ? -1 : this.httpMethod.ordinal());
        dest.writeInt(this.headers.size());
        for (Map.Entry<String, String> entry : this.headers.entrySet()) {
            dest.writeString(entry.getKey());
            dest.writeString(entry.getValue());
        }
        dest.writeInt(this.params.size());
        for (Map.Entry<String, String> entry : this.params.entrySet()) {
            dest.writeString(entry.getKey());
            dest.writeString(entry.getValue());
        }
    }

    public static class Builder {
        String url;
        HttpMethod httpMethod;
        Map<String, String> headers;
        Map<String, String> params;

        public Builder url(String url) {
            this.url = url;
            return this;
        }

        public Builder httpMethod(HttpMethod method) {
            this.httpMethod = method;
            return this;
        }

        public Builder headers(Map<String, String> headers) {
            this.headers = headers;
            return this;
        }

        public Builder parameters(Map<String, String> params) {
            this.params = params;
            return this;
        }

        public ActivityContext build() {
            return new ActivityContext(this);
        }
    }
}

