/*
 * Decompiled with CFR 0.152.
 */
package com.kontakt.sdk.android.common.model;

import android.os.Parcel;
import android.os.Parcelable;
import com.kontakt.sdk.android.common.util.HashCodeBuilder;
import com.kontakt.sdk.android.common.util.SDKEqualsBuilder;

public class ActionContent
implements Parcelable {
    public static final Parcelable.Creator<ActionContent> CREATOR = new Parcelable.Creator<ActionContent>(){

        public ActionContent createFromParcel(Parcel source) {
            return new ActionContent(source);
        }

        public ActionContent[] newArray(int size) {
            return new ActionContent[size];
        }
    };
    private int contentLength;
    private String contentType;
    private Category contentCategory;
    private String content;
    private boolean conversionInProgress;

    public static Builder builder() {
        return new Builder();
    }

    private ActionContent() {
        this(new Builder());
    }

    ActionContent(Builder builder) {
        this.contentLength = builder.contentLength;
        this.contentType = builder.contentType;
        this.contentCategory = builder.contentCategory;
        this.content = builder.content;
        this.conversionInProgress = builder.conversionInProgress;
    }

    protected ActionContent(Parcel in) {
        this.contentLength = in.readInt();
        this.contentType = in.readString();
        int tmpContentCategory = in.readInt();
        this.contentCategory = tmpContentCategory == -1 ? null : Category.values()[tmpContentCategory];
        this.content = in.readString();
        this.conversionInProgress = in.readByte() != 0;
    }

    public boolean equals(Object o) {
        if (o == null || !(o instanceof ActionContent)) {
            return false;
        }
        if (o == this) {
            return true;
        }
        ActionContent other = (ActionContent)o;
        return SDKEqualsBuilder.start().equals(this.contentLength, other.contentLength).equals(this.contentType, other.contentType).equals((Object)this.contentCategory, (Object)other.contentCategory).equals(this.content, other.content).equals(this.conversionInProgress, other.conversionInProgress).result();
    }

    public int hashCode() {
        return HashCodeBuilder.init().append(this.contentLength).append(this.contentType).append((Object)this.contentCategory).append(this.content).append(this.conversionInProgress).build();
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        dest.writeInt(this.contentLength);
        dest.writeString(this.contentType);
        dest.writeInt(this.contentCategory == null ? -1 : this.contentCategory.ordinal());
        dest.writeString(this.content);
        dest.writeByte(this.conversionInProgress ? (byte)1 : 0);
    }

    public int getLength() {
        return this.contentLength;
    }

    public String getType() {
        return this.contentType;
    }

    public Category getCategory() {
        return this.contentCategory;
    }

    public String getContentUrl() {
        return this.content;
    }

    public boolean isConversionInProgress() {
        return this.conversionInProgress;
    }

    public static class Builder {
        int contentLength;
        String contentType;
        Category contentCategory;
        String content;
        boolean conversionInProgress;

        public Builder length(int contentLength) {
            this.contentLength = contentLength;
            return this;
        }

        public Builder type(String contentType) {
            this.contentType = contentType;
            return this;
        }

        public Builder category(Category contentCategory) {
            this.contentCategory = contentCategory;
            return this;
        }

        public Builder content(String content) {
            this.content = content;
            return this;
        }

        public Builder conversionInProgress(Boolean conversionInProgress) {
            this.conversionInProgress = conversionInProgress == null ? false : conversionInProgress;
            return this;
        }

        public ActionContent build() {
            return new ActionContent(this);
        }
    }

    public static enum Category {
        IMAGE,
        AUDIO,
        VIDEO,
        TEXT,
        UNKNOWN;

    }
}

