/*
 * Decompiled with CFR 0.152.
 */
package com.kontakt.sdk.android.common;

import com.kontakt.sdk.android.common.util.ArrayUtils;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;

public final class FirmwareRevisions {
    private static final String[] BEACON_PRO_VERSIONS = new String[]{"1.1", "1.2", "1.3", "1.4", "1.5", "1.6", "1.7", "1.8", "1.9", "1.10"};
    private static final String[] GATEWAY_VERSIONS = new String[]{"1.0", "1.0.5", "1.0.6", "1.0.7", "1.10", "1.1.2", "1.1.3", "1.1.4", "1.1.5", "1.2", "1.2.1", "1.2.2", "1.2.3", "1.2.4", "1.2.5", "1.3", "1.3.1", "1.3.2", "1.3.3", "1.3.4", "1.4", "1.5", "1.5.1", "1.5.2", "1.5.3", "1.5.4", "1.5.5"};
    public static final Set<String> BEACON_PRO_RTC_LIGHTSENSOR_FIRMWARE_VERSIONS = Collections.unmodifiableSet(new HashSet<String>(Arrays.asList("1.7", "1.8", "1.9", "1.10")));
    public static final Set<String> BEACON_PRO_KONTAKT_TLM_FIRMWARE_VERSIONS = Collections.unmodifiableSet(new HashSet<String>(Arrays.asList("1.10")));
    public static final Set<String> SECURE_MODE_FIRMWARE_VERSIONS = Collections.unmodifiableSet(new HashSet<String>(Arrays.asList(ArrayUtils.concat(ArrayUtils.concat(new String[]{"4.0", "4.1", "4.2"}, BEACON_PRO_VERSIONS), GATEWAY_VERSIONS))));
    public static final Set<String> BEACON_PRO_FIRMWARE_VERSIONS = Collections.unmodifiableSet(new HashSet<String>(Arrays.asList(BEACON_PRO_VERSIONS)));
    public static final Set<String> INTERLEAVING_PACKETS_VERSIONS = Collections.unmodifiableSet(new HashSet<String>(Arrays.asList(ArrayUtils.concat(new String[]{"4.1", "4.2"}, BEACON_PRO_VERSIONS))));

    public static boolean isInterleavingAvailable(String firmwareVersion) {
        return INTERLEAVING_PACKETS_VERSIONS.contains(firmwareVersion);
    }

    public static boolean isSecure(String firmwareVersion) {
        return SECURE_MODE_FIRMWARE_VERSIONS.contains(firmwareVersion);
    }

    public static boolean isPro(String firmwareVersion) {
        return BEACON_PRO_FIRMWARE_VERSIONS.contains(firmwareVersion);
    }
}

