/*
 * Decompiled with CFR 0.152.
 */
package com.kontakt.sdk.android.cloud.api.executor.triggers;

import com.kontakt.sdk.android.cloud.api.executor.PaginatedRequestExecutor;
import com.kontakt.sdk.android.cloud.api.service.TriggersService;
import com.kontakt.sdk.android.cloud.response.paginated.Triggers;
import com.kontakt.sdk.android.cloud.util.StringUtils;
import com.kontakt.sdk.android.common.Order;
import com.kontakt.sdk.android.common.model.OrderBy;
import com.kontakt.sdk.android.common.util.SDKPreconditions;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import retrofit2.Call;

public class TriggersRequestExecutor
extends PaginatedRequestExecutor<Triggers> {
    private final TriggersService triggersService;
    private final List<UUID> triggersIds = new ArrayList<UUID>();

    public TriggersRequestExecutor(TriggersService triggersService) {
        this.triggersService = triggersService;
    }

    public TriggersRequestExecutor withIds(UUID ... ids) {
        return this.withIds(Arrays.asList(ids));
    }

    public TriggersRequestExecutor withIds(List<UUID> ids) {
        SDKPreconditions.checkNotNull(ids, "Ids are null");
        this.triggersIds.addAll(ids);
        return this;
    }

    @Override
    public TriggersRequestExecutor startIndex(int startIndex) {
        super.startIndex(startIndex);
        return this;
    }

    @Override
    public TriggersRequestExecutor maxResult(int maxResult) {
        super.maxResult(maxResult);
        return this;
    }

    @Override
    public TriggersRequestExecutor filter(String query) {
        super.filter(query);
        return this;
    }

    @Override
    public TriggersRequestExecutor orderBy(OrderBy orderBy, Order order) {
        super.orderBy(orderBy, order);
        return this;
    }

    @Override
    public TriggersRequestExecutor eTag(String eTag) {
        super.eTag(eTag);
        return this;
    }

    @Override
    protected Call<Triggers> prepareCall() {
        Call<Triggers> call = this.eTag != null ? this.triggersService.getTriggers(this.params(), this.eTag) : this.triggersService.getTriggers(this.params());
        return call;
    }

    @Override
    protected Map<String, String> params() {
        if (this.triggersIds.isEmpty()) {
            return super.params();
        }
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("triggerId", StringUtils.join(this.triggersIds, ","));
        params.putAll(super.params());
        return params;
    }
}

