/*
 * Decompiled with CFR 0.152.
 */
package com.kontakt.sdk.android.cloud.api.executor.receivers;

import com.kontakt.sdk.android.cloud.api.executor.RequestExecutor;
import com.kontakt.sdk.android.cloud.api.service.ReceiversService;
import com.kontakt.sdk.android.cloud.exception.KontaktCloudException;
import com.kontakt.sdk.android.cloud.response.CloudCallback;
import com.kontakt.sdk.android.common.model.Receiver;
import com.kontakt.sdk.android.common.util.SDKPreconditions;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import retrofit2.Call;

public class UpdateReceiverRequestExecutor
extends RequestExecutor<String> {
    private final ReceiversService receiversService;
    private final UUID id;
    private Receiver receiver;

    public UpdateReceiverRequestExecutor(ReceiversService receiversService, UUID id) {
        this.receiversService = receiversService;
        this.id = id;
    }

    public UpdateReceiverRequestExecutor with(Receiver receiver) {
        SDKPreconditions.checkNotNull(receiver, "receiver cannot be null");
        this.receiver = receiver;
        return this;
    }

    @Override
    public String execute() throws IOException, KontaktCloudException {
        this.checkPreconditions();
        return (String)super.execute();
    }

    @Override
    public void execute(CloudCallback<String> callback) {
        this.checkPreconditions();
        super.execute(callback);
    }

    @Override
    protected Call<String> prepareCall() {
        return this.receiversService.updateReceiver(this.params());
    }

    private void checkPreconditions() {
        SDKPreconditions.checkState(this.receiver != null, "cannot update receiver - specify receiver data to update");
    }

    @Override
    protected Map<String, String> params() {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("receiverId", this.id.toString());
        if (this.receiver.getDeviceUniqueId() != null) {
            params.put("uniqueId", this.receiver.getDeviceUniqueId());
        }
        if (this.receiver.getPlaceId() != null) {
            params.put("placeId", this.receiver.getPlaceId().toString());
        }
        if (this.receiver.getCoordinates() != null) {
            params.put("coordinates", this.receiver.getCoordinates().toString());
        }
        return params;
    }
}

