/*
 * Decompiled with CFR 0.152.
 */
package com.kontakt.sdk.android.cloud.api.executor.receivers;

import com.kontakt.sdk.android.cloud.api.executor.PaginatedRequestExecutor;
import com.kontakt.sdk.android.cloud.api.service.ReceiversService;
import com.kontakt.sdk.android.cloud.exception.KontaktCloudException;
import com.kontakt.sdk.android.cloud.response.CloudCallback;
import com.kontakt.sdk.android.cloud.response.paginated.Receivers;
import com.kontakt.sdk.android.cloud.util.StringUtils;
import com.kontakt.sdk.android.common.Order;
import com.kontakt.sdk.android.common.model.OrderBy;
import com.kontakt.sdk.android.common.util.SDKPreconditions;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import retrofit2.Call;

public class ReceiversRequestExecutor
extends PaginatedRequestExecutor<Receivers> {
    private final ReceiversService receiversService;
    private UUID[] ids;
    private UUID[] placeIds;

    public ReceiversRequestExecutor(ReceiversService receiversService) {
        this.receiversService = receiversService;
    }

    public ReceiversRequestExecutor withIds(UUID ... ids) {
        this.ids = SDKPreconditions.checkNotNull(ids, "Receiver IDs cannot be null");
        return this;
    }

    public ReceiversRequestExecutor withIds(List<UUID> ids) {
        SDKPreconditions.checkNotNull(ids, "Receiver IDs cannot be null");
        int size = ids.size();
        this.ids = ids.toArray(new UUID[size]);
        return this;
    }

    public ReceiversRequestExecutor fromPlaces(UUID ... placeIds) {
        this.placeIds = SDKPreconditions.checkNotNull(placeIds, "Place IDs cannot be null");
        return this;
    }

    public ReceiversRequestExecutor fromPlaces(List<UUID> placeIds) {
        SDKPreconditions.checkNotNull(placeIds, "Place IDs cannot be null");
        int size = placeIds.size();
        this.placeIds = placeIds.toArray(new UUID[size]);
        return this;
    }

    @Override
    public ReceiversRequestExecutor startIndex(int startIndex) {
        super.startIndex(startIndex);
        return this;
    }

    @Override
    public ReceiversRequestExecutor maxResult(int maxResult) {
        super.maxResult(maxResult);
        return this;
    }

    @Override
    public ReceiversRequestExecutor filter(String query) {
        super.filter(query);
        return this;
    }

    @Override
    public ReceiversRequestExecutor orderBy(OrderBy orderBy, Order order) {
        super.orderBy(orderBy, order);
        return this;
    }

    @Override
    public ReceiversRequestExecutor eTag(String eTag) {
        super.eTag(eTag);
        return this;
    }

    @Override
    public Receivers execute() throws IOException, KontaktCloudException {
        this.checkPreconditions();
        return (Receivers)super.execute();
    }

    @Override
    public void execute(CloudCallback<Receivers> callback) {
        this.checkPreconditions();
        super.execute(callback);
    }

    @Override
    protected Call<Receivers> prepareCall() {
        Call<Receivers> call = this.eTag != null ? this.receiversService.getReceivers(this.params(), this.eTag) : this.receiversService.getReceivers(this.params());
        return call;
    }

    private void checkPreconditions() {
        SDKPreconditions.checkState(this.ids != null || this.placeIds != null, "cannot fetch receivers - specify either receiver IDs or place IDs");
    }

    @Override
    protected Map<String, String> params() {
        HashMap<String, String> params = new HashMap<String, String>();
        if (this.ids != null) {
            params.put("receiverId", StringUtils.join(this.ids, ","));
        }
        if (this.placeIds != null) {
            params.put("placeId", StringUtils.join(this.placeIds, ","));
        }
        return params;
    }
}

