/*
 * Decompiled with CFR 0.152.
 */
package com.kontakt.sdk.android.cloud.api.executor.devices;

import android.util.Base64;
import com.kontakt.sdk.android.ble.spec.Telemetry;
import com.kontakt.sdk.android.cloud.api.executor.RequestExecutor;
import com.kontakt.sdk.android.cloud.api.service.DevicesService;
import com.kontakt.sdk.android.common.log.Logger;
import com.kontakt.sdk.android.common.util.ConversionUtils;
import java.util.HashMap;
import java.util.Map;
import retrofit2.Call;

public class TelemetryRequestExecutor
extends RequestExecutor<Telemetry> {
    private final DevicesService service;
    private final String eid;
    private final String etlmFrame;

    public TelemetryRequestExecutor(DevicesService service, String eid, String etlmFrame) {
        this.service = service;
        this.eid = eid;
        this.etlmFrame = etlmFrame;
    }

    @Override
    protected Call<Telemetry> prepareCall() {
        return this.service.decryptTelemetry(this.params());
    }

    @Override
    protected Map<String, String> params() {
        HashMap<String, String> params = new HashMap<String, String>();
        if (this.etlmFrame != null) {
            String encoded = Base64.encodeToString((byte[])ConversionUtils.hexStringToByteArray(this.etlmFrame.trim()), (int)2);
            Logger.d("Encoded params: " + encoded);
            params.put("frame", encoded);
        }
        if (this.eid != null) {
            params.put("eid", this.eid.trim());
        }
        return params;
    }
}

