/*
 * Decompiled with CFR 0.152.
 */
package com.kontakt.sdk.android.cloud.api.executor;

import com.kontakt.sdk.android.cloud.api.executor.CloudCallbackWrapper;
import com.kontakt.sdk.android.cloud.exception.KontaktCloudException;
import com.kontakt.sdk.android.cloud.response.CloudCallback;
import java.io.IOException;
import java.util.Map;
import retrofit2.Call;
import retrofit2.Response;

public abstract class RequestExecutor<T> {
    public T execute() throws IOException, KontaktCloudException {
        Call<T> call = this.prepareCall();
        Response response = call.execute();
        if (response.isSuccessful() || response.code() == 304) {
            return (T)response.body();
        }
        String rawMessage = response.raw().message();
        if (response.errorBody() != null) {
            rawMessage = rawMessage + "; " + response.errorBody().string();
        }
        int code = response.code();
        String message = "code - " + code + ", message - " + rawMessage;
        throw new KontaktCloudException(message, code);
    }

    public void execute(CloudCallback<T> callback) {
        Call<T> call = this.prepareCall();
        call.enqueue(new CloudCallbackWrapper<T>(callback));
    }

    protected abstract Call<T> prepareCall();

    protected abstract Map<String, String> params();
}

