/*
 * Decompiled with CFR 0.152.
 */
package com.kontakt.sdk.android.cloud.api;

import com.kontakt.sdk.android.cloud.api.executor.receivers.CreateReceiverRequestExecutor;
import com.kontakt.sdk.android.cloud.api.executor.receivers.DeleteReceiverRequestExecutor;
import com.kontakt.sdk.android.cloud.api.executor.receivers.ReceiversRequestExecutor;
import com.kontakt.sdk.android.cloud.api.executor.receivers.UpdateReceiverRequestExecutor;
import com.kontakt.sdk.android.cloud.api.service.ReceiversService;
import com.kontakt.sdk.android.common.model.Receiver;
import com.kontakt.sdk.android.common.util.SDKPreconditions;
import java.util.UUID;

public class ReceiversApi {
    private final ReceiversService receiversService;

    public ReceiversApi(ReceiversService receiversService) {
        this.receiversService = receiversService;
    }

    public ReceiversRequestExecutor fetch() {
        return new ReceiversRequestExecutor(this.receiversService);
    }

    public CreateReceiverRequestExecutor create(Receiver receiver) {
        SDKPreconditions.checkNotNull(receiver, "receiver cannot be null");
        return new CreateReceiverRequestExecutor(this.receiversService, receiver);
    }

    public UpdateReceiverRequestExecutor update(UUID id) {
        SDKPreconditions.checkNotNull(id, "ID cannot be null");
        return new UpdateReceiverRequestExecutor(this.receiversService, id);
    }

    public DeleteReceiverRequestExecutor delete(UUID id) {
        return new DeleteReceiverRequestExecutor(this.receiversService, id);
    }
}

