/*
 * Decompiled with CFR 0.152.
 */
package com.kontakt.sdk.android.cloud.adapter;

import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import com.kontakt.sdk.android.ble.spec.Acceleration;
import com.kontakt.sdk.android.ble.spec.KontaktTelemetry;
import com.kontakt.sdk.android.cloud.adapter.BaseTypeAdapter;
import com.kontakt.sdk.android.cloud.util.DateUtil;
import com.kontakt.sdk.android.common.model.FullTelemetryCollectEvent;
import java.io.IOException;

public class FullTelemetryCollectEventTypeAdapter
extends BaseTypeAdapter<FullTelemetryCollectEvent> {
    public void write(JsonWriter out, FullTelemetryCollectEvent value) throws IOException {
        KontaktTelemetry defaultTelemetry = new KontaktTelemetry.Builder().build();
        out.beginObject();
        this.writeString(out, "trackingId", value.trackingId);
        this.writeString(out, "sourceId", value.sourceId);
        this.writeString(out, "timeStamp", DateUtil.timestampInSecondsToString(value.timestamp));
        this.maybeWriteInteger(out, "batteryLevel", value.batteryLevel, defaultTelemetry.getBatteryLevel());
        this.maybeWriteAccelerometer(out, value.acceleration);
        this.maybeWriteInteger(out, "accelerometerSensitivity", value.accelerometerSensitivity, defaultTelemetry.getSensitivity());
        this.maybeWriteInteger(out, "timeSinceDoubleTap", value.timeSinceDoubleTap, defaultTelemetry.getLastDoubleTap());
        this.maybeWriteInteger(out, "timeSinceTap", value.timeSinceTap, defaultTelemetry.getLastTap());
        this.maybeWriteInteger(out, "timeSinceDoubleClick", value.timeSinceDoubleClick, defaultTelemetry.getLastDoubleClick());
        this.maybeWriteInteger(out, "timeSinceClick", value.timeSinceClick, defaultTelemetry.getLastSingleClick());
        this.maybeWriteInteger(out, "movementCounter", value.movementCounter, defaultTelemetry.getCurrentMovementId());
        this.maybeWriteInteger(out, "clickCounter", value.clickCounter, defaultTelemetry.getSingleClickCount());
        this.maybeWriteInteger(out, "secondButtonClickCounter", value.secondButtonClickCounter, defaultTelemetry.getSingleClickCount2());
        this.maybeWriteInteger(out, "lightIntensity", value.lightIntensity, defaultTelemetry.getLightSensor());
        this.maybeWriteInteger(out, "humidity", value.humidity, defaultTelemetry.getHumidity());
        this.maybeWriteInteger(out, "channel", value.channel, defaultTelemetry.getBleChannel());
        this.maybeWriteInteger(out, "numberOfPeopleDetected", value.numberOfPeopleDetected, defaultTelemetry.getOccupancy());
        this.maybeWriteInteger(out, "secondsSincePeopleDetection", value.secondsSincePeopleDetection, defaultTelemetry.getOccupancyDetectionTime());
        out.endObject();
    }

    private void maybeWriteAccelerometer(JsonWriter out, Acceleration acceleration) throws IOException {
        if (acceleration == null) {
            return;
        }
        this.writeInteger(out, "accelerometerX", acceleration.getX());
        this.writeInteger(out, "accelerometerY", acceleration.getY());
        this.writeInteger(out, "accelerometerZ", acceleration.getZ());
    }

    private void maybeWriteInteger(JsonWriter out, String name, int value, int defaultValue) throws IOException {
        if (value != defaultValue) {
            this.writeInteger(out, name, value);
        }
    }

    public FullTelemetryCollectEvent read(JsonReader in) {
        return null;
    }
}

