/*
 * Decompiled with CFR 0.152.
 */
package com.kontakt.sdk.android.ble.util;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class FileUtils {
    private static final int DEFAULT_BUFFER_SIZE = 4096;

    public static byte[] toByteArray(InputStream input) throws IOException {
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        FileUtils.copy(input, output);
        byte[] bytes = output.toByteArray();
        output.close();
        return bytes;
    }

    private static int copy(InputStream input, OutputStream output) throws IOException {
        long count = FileUtils.copyLarge(input, output);
        if (count > Integer.MAX_VALUE) {
            return -1;
        }
        return (int)count;
    }

    private static long copyLarge(InputStream input, OutputStream output) throws IOException {
        byte[] buffer = new byte[4096];
        long count = 0L;
        int n = 0;
        while (-1 != (n = input.read(buffer))) {
            output.write(buffer, 0, n);
            count += (long)n;
        }
        return count;
    }
}

