/*
 * Decompiled with CFR 0.152.
 */
package com.kontakt.sdk.android.ble.spec;

import android.os.Parcel;
import android.os.Parcelable;
import com.kontakt.sdk.android.ble.spec.Acceleration;
import com.kontakt.sdk.android.ble.spec.DeviceDataLoggerStatus;
import com.kontakt.sdk.android.ble.spec.TelemetryError;
import com.kontakt.sdk.android.common.util.ArrayUtils;

public class KontaktTelemetry
implements Parcelable {
    public static final Parcelable.Creator<KontaktTelemetry> CREATOR = new Parcelable.Creator<KontaktTelemetry>(){

        public KontaktTelemetry createFromParcel(Parcel source) {
            return new KontaktTelemetry(source);
        }

        public KontaktTelemetry[] newArray(int size) {
            return new KontaktTelemetry[size];
        }
    };
    public static final int BATTERY_LEVEL_EXTERNAL_POWER_SUPPLIED_VALUE = 255;
    public static final int DOUBLE_TAP_DISABLED_VALUE = 65535;
    public static final int THRESHOLD_DISABLED_VALUE = 65535;
    public static final int LOAD_AVERAGE_NOT_SUPPORTED_VALUE = 255;
    public static final int BLE_SCANS_NOT_SUPPORTED_VALUE = 255;
    public static final int WIFI_SCANS_NOT_SUPPORTED_VALUE = 255;
    public static final int BLE_DEVICES_NOT_SUPPORTED_VALUE = 65535;
    private final int timestamp;
    private final int batteryLevel;
    private final int uptime;
    private final int systemLoad;
    private final TelemetryError error;
    private final int sensitivity;
    private final Acceleration acceleration;
    private final int currentMovementId;
    private final int lastDoubleTap;
    private final int lastThreshold;
    private final int lightSensor;
    private final float temperature;
    private final int bleScans;
    private final int wifiScans;
    private final int bleDevices;
    private final int lastSingleClick;
    private final int singleClickCount;
    private final int lastDoubleClick;
    private final DeviceDataLoggerStatus dataLoggerStatus;
    private final int humidity;
    private final int bleChannel;
    private final int lastTap;
    private final byte definedGpioMask;
    private final byte stateGpioMask;
    private final float airPressure;
    private final int pirDetectionSeconds;
    private final int singleClickCount2;
    private final int manufacturerId;
    private final int airQuality;
    private final int roomNumber;
    private final int occupancy;
    private final int occupancyDetectionTime;

    private KontaktTelemetry(Builder builder) {
        this.timestamp = builder.timestamp;
        this.batteryLevel = builder.batteryLevel;
        this.uptime = builder.uptime;
        this.systemLoad = builder.systemLoad;
        this.error = builder.error;
        this.sensitivity = builder.sensitivity;
        this.acceleration = builder.acceleration;
        this.lastDoubleTap = builder.lastDoubleTap;
        this.lastThreshold = builder.lastThreshold;
        this.lightSensor = builder.lightSensor;
        this.temperature = builder.temperature;
        this.bleScans = builder.bleScans;
        this.wifiScans = builder.wifiScans;
        this.bleDevices = builder.bleDevices;
        this.lastSingleClick = builder.lastSingleClick;
        this.singleClickCount = builder.singleClickCount;
        this.singleClickCount2 = builder.singleClickCount2;
        this.dataLoggerStatus = builder.dataLoggerStatus;
        this.humidity = builder.humidity;
        this.bleChannel = builder.bleChannel;
        this.lastTap = builder.lastTap;
        this.lastDoubleClick = builder.lastDoubleClick;
        this.currentMovementId = builder.currentMovementId;
        this.airPressure = builder.airPressure;
        this.definedGpioMask = builder.definedGpioMask;
        this.stateGpioMask = builder.stateGpioMask;
        this.pirDetectionSeconds = builder.pirDetectionSeconds;
        this.manufacturerId = builder.manufacturerId;
        this.airQuality = builder.airQuality;
        this.roomNumber = builder.roomNumber;
        this.occupancy = builder.occupancy;
        this.occupancyDetectionTime = builder.occupancyDetectionTime;
    }

    private KontaktTelemetry(Parcel in) {
        this.timestamp = in.readInt();
        this.batteryLevel = in.readInt();
        this.uptime = in.readInt();
        this.systemLoad = in.readInt();
        int tmpError = in.readInt();
        this.error = tmpError == -1 ? null : TelemetryError.values()[tmpError];
        this.sensitivity = in.readInt();
        this.acceleration = (Acceleration)in.readParcelable(Acceleration.class.getClassLoader());
        this.lastDoubleTap = in.readInt();
        this.lastThreshold = in.readInt();
        this.lightSensor = in.readInt();
        this.temperature = in.readInt();
        this.bleScans = in.readInt();
        this.wifiScans = in.readInt();
        this.bleDevices = in.readInt();
        this.lastSingleClick = in.readInt();
        this.singleClickCount = in.readInt();
        this.dataLoggerStatus = DeviceDataLoggerStatus.valueOf(in.readString());
        this.humidity = in.readInt();
        this.bleChannel = in.readInt();
        this.lastTap = in.readInt();
        this.lastDoubleClick = in.readInt();
        this.currentMovementId = in.readInt();
        this.definedGpioMask = in.readByte();
        this.stateGpioMask = in.readByte();
        this.airPressure = in.readFloat();
        this.pirDetectionSeconds = in.readInt();
        this.singleClickCount2 = in.readInt();
        this.manufacturerId = in.readInt();
        this.airQuality = in.readInt();
        this.roomNumber = in.readInt();
        this.occupancy = in.readInt();
        this.occupancyDetectionTime = in.readInt();
    }

    public void writeToParcel(Parcel dest, int flags) {
        dest.writeInt(this.timestamp);
        dest.writeInt(this.batteryLevel);
        dest.writeInt(this.uptime);
        dest.writeInt(this.systemLoad);
        dest.writeInt(this.error == null ? -1 : this.error.ordinal());
        dest.writeInt(this.sensitivity);
        dest.writeParcelable((Parcelable)this.acceleration, flags);
        dest.writeInt(this.lastDoubleTap);
        dest.writeInt(this.lastThreshold);
        dest.writeInt(this.lightSensor);
        dest.writeFloat(this.temperature);
        dest.writeInt(this.bleScans);
        dest.writeInt(this.wifiScans);
        dest.writeInt(this.bleDevices);
        dest.writeInt(this.lastSingleClick);
        dest.writeInt(this.singleClickCount);
        dest.writeString(this.dataLoggerStatus.name());
        dest.writeInt(this.humidity);
        dest.writeInt(this.bleChannel);
        dest.writeInt(this.lastTap);
        dest.writeInt(this.lastDoubleClick);
        dest.writeInt(this.currentMovementId);
        dest.writeByte(this.definedGpioMask);
        dest.writeByte(this.stateGpioMask);
        dest.writeFloat(this.airPressure);
        dest.writeInt(this.pirDetectionSeconds);
        dest.writeInt(this.singleClickCount2);
        dest.writeInt(this.manufacturerId);
        dest.writeInt(this.airQuality);
        dest.writeInt(this.roomNumber);
        dest.writeInt(this.occupancy);
        dest.writeInt(this.occupancyDetectionTime);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        KontaktTelemetry that = (KontaktTelemetry)o;
        if (this.timestamp != that.timestamp) {
            return false;
        }
        if (this.batteryLevel != that.batteryLevel) {
            return false;
        }
        if (this.uptime != that.uptime) {
            return false;
        }
        if (this.systemLoad != that.systemLoad) {
            return false;
        }
        if (this.sensitivity != that.sensitivity) {
            return false;
        }
        if (this.lastDoubleTap != that.lastDoubleTap) {
            return false;
        }
        if (this.lastThreshold != that.lastThreshold) {
            return false;
        }
        if (this.lightSensor != that.lightSensor) {
            return false;
        }
        if (this.temperature != that.temperature) {
            return false;
        }
        if (this.bleScans != that.bleScans) {
            return false;
        }
        if (this.wifiScans != that.wifiScans) {
            return false;
        }
        if (this.bleDevices != that.bleDevices) {
            return false;
        }
        if (this.error != that.error) {
            return false;
        }
        if (this.lastSingleClick != that.lastSingleClick) {
            return false;
        }
        if (this.singleClickCount != that.singleClickCount) {
            return false;
        }
        if (this.dataLoggerStatus != that.dataLoggerStatus) {
            return false;
        }
        if (this.humidity != that.humidity) {
            return false;
        }
        if (this.bleChannel != that.bleChannel) {
            return false;
        }
        if (this.lastTap != that.lastTap) {
            return false;
        }
        if (this.lastDoubleClick != that.lastDoubleClick) {
            return false;
        }
        if (this.currentMovementId != that.currentMovementId) {
            return false;
        }
        if (this.airPressure != that.airPressure) {
            return false;
        }
        if (this.definedGpioMask != that.definedGpioMask) {
            return false;
        }
        if (this.stateGpioMask != that.stateGpioMask) {
            return false;
        }
        if (this.pirDetectionSeconds != that.pirDetectionSeconds) {
            return false;
        }
        if (this.singleClickCount2 != that.singleClickCount2) {
            return false;
        }
        if (this.manufacturerId != that.manufacturerId) {
            return false;
        }
        if (this.airQuality != that.airQuality) {
            return false;
        }
        if (this.roomNumber != that.roomNumber) {
            return false;
        }
        if (this.occupancy != that.roomNumber) {
            return false;
        }
        if (this.occupancyDetectionTime != that.occupancyDetectionTime) {
            return false;
        }
        return this.acceleration != null ? this.acceleration.equals(that.acceleration) : that.acceleration == null;
    }

    public int hashCode() {
        int result = this.timestamp;
        result = 31 * result + this.batteryLevel;
        result = 31 * result + this.uptime;
        result = 31 * result + this.systemLoad;
        result = 31 * result + (this.error != null ? this.error.hashCode() : 0);
        result = 31 * result + this.sensitivity;
        result = 31 * result + (this.acceleration != null ? this.acceleration.hashCode() : 0);
        result = 31 * result + this.lastDoubleTap;
        result = 31 * result + this.lastThreshold;
        result = 31 * result + this.lightSensor;
        result = 31 * result + Float.valueOf(this.temperature).hashCode();
        result = 31 * result + this.bleScans;
        result = 31 * result + this.wifiScans;
        result = 31 * result + this.bleDevices;
        result = 31 * result + this.lastSingleClick;
        result = 31 * result + this.singleClickCount;
        result = 31 * result + this.dataLoggerStatus.ordinal();
        result = 31 * result + this.humidity;
        result = 31 * result + this.bleChannel;
        result = 31 * result + this.lastTap;
        result = 31 * result + this.lastDoubleClick;
        result = 31 * result + this.singleClickCount;
        result = 31 * result + this.definedGpioMask;
        result = 31 * result + this.stateGpioMask;
        result = 31 * result + Float.valueOf(this.airPressure).hashCode();
        result = 31 * result + this.pirDetectionSeconds;
        result = 31 * result + this.singleClickCount2;
        result = 31 * result + this.manufacturerId;
        result = 31 * result + this.airQuality;
        result = 31 * result + this.roomNumber;
        result = 31 * result + this.occupancy;
        result = 31 * result + this.occupancyDetectionTime;
        return result;
    }

    public String toString() {
        return "KontaktTelemetry{timestamp=" + this.timestamp + ", batteryLevel=" + this.batteryLevel + ", uptime=" + this.uptime + ", systemLoad=" + this.systemLoad + ", error=" + (Object)((Object)this.error) + ", sensitivity=" + this.sensitivity + ", acceleration=" + this.acceleration + ", lastDoubleTap=" + this.lastDoubleTap + ", lastThreshold=" + this.lastThreshold + ", lightSensor=" + this.lightSensor + ", temperature=" + this.temperature + ", bleScans=" + this.bleScans + ", wifiScans=" + this.wifiScans + ", bleDevices=" + this.bleDevices + ", lastSingleClick=" + this.lastSingleClick + ", lastDoubleClick=" + this.lastDoubleClick + ", lastTap=" + this.lastTap + ", singleClickCount=" + this.singleClickCount + ", singleClickCount2=" + this.singleClickCount2 + ", dataLoggerStatus=" + this.dataLoggerStatus.name() + ", humidity=" + this.humidity + ", bleChannel=" + this.bleChannel + ",  airPressure=" + this.airPressure + ", stateGpioMask: " + ArrayUtils.binaryStringOfByte(this.stateGpioMask) + ", definedGpioMask: " + ArrayUtils.binaryStringOfByte(this.definedGpioMask) + ", pirDetectionSeconds: " + this.pirDetectionSeconds + ", vendorSpecifics: manufacturerId: " + this.manufacturerId + ", airQuality: " + this.airQuality + ", roomNumber: " + this.roomNumber + ", occupancy: " + this.occupancy + ", occupancy detection time: " + this.occupancyDetectionTime + '}';
    }

    public int describeContents() {
        return 0;
    }

    public int getTimestamp() {
        return this.timestamp;
    }

    public int getBatteryLevel() {
        return this.batteryLevel;
    }

    public int getUptime() {
        return this.uptime;
    }

    public int getSystemLoad() {
        return this.systemLoad;
    }

    public TelemetryError getError() {
        return this.error;
    }

    public int getSensitivity() {
        return this.sensitivity;
    }

    public Acceleration getAcceleration() {
        return this.acceleration;
    }

    public int getLastDoubleTap() {
        return this.lastDoubleTap;
    }

    public int getLastThreshold() {
        return this.lastThreshold;
    }

    public int getLightSensor() {
        return this.lightSensor;
    }

    public float getTemperature() {
        return this.temperature;
    }

    public int getBleScans() {
        return this.bleScans;
    }

    public int getWifiScans() {
        return this.wifiScans;
    }

    public int getBleDevices() {
        return this.bleDevices;
    }

    public int getLastSingleClick() {
        return this.lastSingleClick;
    }

    public int getSingleClickCount() {
        return this.singleClickCount;
    }

    public DeviceDataLoggerStatus getDataLoggerStatus() {
        return this.dataLoggerStatus;
    }

    public int getHumidity() {
        return this.humidity;
    }

    public int getBleChannel() {
        return this.bleChannel;
    }

    public int getLastTap() {
        return this.lastTap;
    }

    public int getLastDoubleClick() {
        return this.lastDoubleClick;
    }

    public int getCurrentMovementId() {
        return this.currentMovementId;
    }

    public float getAirPressure() {
        return this.airPressure;
    }

    public byte getDefinedGpioMask() {
        return this.definedGpioMask;
    }

    public byte getStateGpioMask() {
        return this.stateGpioMask;
    }

    public int getPirDetectionSeconds() {
        return this.pirDetectionSeconds;
    }

    public int getSingleClickCount2() {
        return this.singleClickCount2;
    }

    public int getAirQuality() {
        return this.airQuality;
    }

    public int getManufacturerId() {
        return this.manufacturerId;
    }

    public int getOccupancy() {
        return this.occupancy;
    }

    public int getOccupancyDetectionTime() {
        return this.occupancyDetectionTime;
    }

    public int getRoomNumber() {
        return this.roomNumber;
    }

    public static class Builder {
        private int timestamp = -1;
        private int batteryLevel = -1;
        private int uptime = -1;
        private int systemLoad = -1;
        private TelemetryError error = null;
        private int sensitivity = -1;
        private Acceleration acceleration = null;
        private int lastDoubleTap = -1;
        private int currentMovementId = -1;
        private int lastThreshold = -1;
        private int lightSensor = -1;
        private float temperature = -1.0f;
        private int bleScans = -1;
        private int wifiScans = -1;
        private int bleDevices = -1;
        private int lastSingleClick = -1;
        private int singleClickCount = -1;
        private int lastDoubleClick = -1;
        private DeviceDataLoggerStatus dataLoggerStatus = DeviceDataLoggerStatus.UNAVAILABLE;
        private int humidity = -1;
        private int bleChannel = -1;
        private int lastTap = -1;
        private float airPressure = -1.0f;
        private byte definedGpioMask = (byte)-1;
        private byte stateGpioMask = (byte)-1;
        private int pirDetectionSeconds = -1;
        private int singleClickCount2 = -1;
        private int manufacturerId = -1;
        private int airQuality = -1;
        private int roomNumber = -1;
        private int occupancy = -1;
        private int occupancyDetectionTime = -1;

        public Builder lastTap(int lastTap) {
            this.lastTap = lastTap;
            return this;
        }

        public Builder timestamp(int timestamp) {
            this.timestamp = timestamp;
            return this;
        }

        public Builder batteryLevel(int batteryLevel) {
            this.batteryLevel = batteryLevel;
            return this;
        }

        public Builder uptime(int uptime) {
            this.uptime = uptime;
            return this;
        }

        public Builder systemLoad(int systemLoad) {
            this.systemLoad = systemLoad;
            return this;
        }

        public Builder error(TelemetryError error) {
            this.error = error;
            return this;
        }

        public Builder sensitivity(int sensitivity) {
            this.sensitivity = sensitivity;
            return this;
        }

        public Builder acceleration(Acceleration acceleration) {
            this.acceleration = acceleration;
            return this;
        }

        public Builder lastDoubleTap(int lastDoubleTap) {
            this.lastDoubleTap = lastDoubleTap;
            return this;
        }

        public Builder lastThreshold(int lastThreshold) {
            this.lastThreshold = lastThreshold;
            return this;
        }

        public Builder lightSensor(int lightSensor) {
            this.lightSensor = lightSensor;
            return this;
        }

        public Builder temperature(float temperature) {
            this.temperature = temperature;
            return this;
        }

        public Builder bleScans(int bleScans) {
            this.bleScans = bleScans;
            return this;
        }

        public Builder wifiScans(int wifiScans) {
            this.wifiScans = wifiScans;
            return this;
        }

        public Builder bleDevices(int bleDevices) {
            this.bleDevices = bleDevices;
            return this;
        }

        public Builder lastSingleClick(int lastSingleClick) {
            this.lastSingleClick = lastSingleClick;
            return this;
        }

        public Builder singleClickCount(int singleClickCount) {
            this.singleClickCount = singleClickCount;
            return this;
        }

        public Builder lastDoubleClick(int lastDoubleClick) {
            this.lastDoubleClick = lastDoubleClick;
            return this;
        }

        public Builder dataLoggerStatus(DeviceDataLoggerStatus dataLoggerStatus) {
            if (dataLoggerStatus != null) {
                this.dataLoggerStatus = dataLoggerStatus;
            }
            return this;
        }

        public Builder humidity(int humidity) {
            this.humidity = humidity;
            return this;
        }

        public Builder bleChannel(int bleChannel) {
            this.bleChannel = bleChannel;
            return this;
        }

        public Builder currentMovementId(int currentMovementId) {
            this.currentMovementId = currentMovementId;
            return this;
        }

        public Builder definedGpioMask(byte definedGpioMask) {
            this.definedGpioMask = definedGpioMask;
            return this;
        }

        public Builder stateGpioMask(byte stateGpioMask) {
            this.stateGpioMask = stateGpioMask;
            return this;
        }

        public Builder airPressure(float pressure) {
            this.airPressure = pressure;
            return this;
        }

        public Builder pirDetectionSeconds(int pirDetectionSeconds) {
            this.pirDetectionSeconds = pirDetectionSeconds;
            return this;
        }

        public Builder singleClickCount2(int singleClickCount2) {
            this.singleClickCount2 = singleClickCount2;
            return this;
        }

        public Builder manufacturerId(int manufacturerId) {
            this.manufacturerId = manufacturerId;
            return this;
        }

        public Builder airQuality(int airQuality) {
            this.airQuality = airQuality;
            return this;
        }

        public Builder roomNumber(int roomNumber) {
            this.roomNumber = roomNumber;
            return this;
        }

        public Builder occupancy(int occupancy) {
            this.occupancy = occupancy;
            return this;
        }

        public Builder occupancyDetectionTime(int occupancyDetectionTime) {
            this.occupancyDetectionTime = occupancyDetectionTime;
            return this;
        }

        public KontaktTelemetry build() {
            return new KontaktTelemetry(this);
        }
    }
}

