/*
 * Decompiled with CFR 0.152.
 */
package com.kontakt.sdk.android.ble.service;

import android.annotation.SuppressLint;
import android.annotation.TargetApi;
import android.app.PendingIntent;
import android.bluetooth.BluetoothAdapter;
import android.bluetooth.le.BluetoothLeScanner;
import android.content.Context;
import android.content.Intent;
import com.kontakt.sdk.android.ble.service.BackgroundScanBroadcastReceiver;
import com.kontakt.sdk.android.ble.service.MonitorCallbackL;
import com.kontakt.sdk.android.common.log.Logger;

class ScannerUtil {
    private static final String TAG = ScannerUtil.class.getSimpleName();
    static final String REQUEST_CODE = "requestCode";

    ScannerUtil() {
    }

    @SuppressLint(value={"MissingPermission"})
    @TargetApi(value=21)
    static BluetoothLeScanner getScanner(MonitorCallbackL monitorCallback) {
        BluetoothAdapter adapter = BluetoothAdapter.getDefaultAdapter();
        if (adapter != null) {
            BluetoothLeScanner bluetoothLeScanner = adapter.getBluetoothLeScanner();
            if (bluetoothLeScanner == null) {
                if (adapter.isEnabled()) {
                    Logger.e(TAG + " SCAN FAILED: INTERNAL ERROR");
                    ScannerUtil.logToCallback(3, monitorCallback);
                } else {
                    Logger.e(TAG + " SCAN FAILED: BLE ADAPTER DISABLED");
                    ScannerUtil.logToCallback(10, monitorCallback);
                }
            }
            return bluetoothLeScanner;
        }
        Logger.e(TAG + " SCAN UNSUPPORTED: scanner null");
        ScannerUtil.logToCallback(4, monitorCallback);
        return null;
    }

    private static void logToCallback(int errorCode, MonitorCallbackL monitorCallback) {
        try {
            monitorCallback.onScanFailed(errorCode);
        }
        catch (NullPointerException e) {
            Logger.w(TAG + "Tried to log scanner error code " + errorCode + " to callback, but it was null");
        }
    }

    static PendingIntent getBroadcastPendingIntent(Context context, int requestCode) {
        Intent intent = new Intent(context, BackgroundScanBroadcastReceiver.class);
        intent.putExtra(REQUEST_CODE, requestCode);
        intent.setAction("com.kontakt.sdk.android.ble.service.ACTION_FOUND");
        return PendingIntent.getBroadcast((Context)context, (int)requestCode, (Intent)intent, (int)0x8000000);
    }

    static int getReceiverCodeRequest(MonitorCallbackL callbackL) {
        try {
            return callbackL.hashCode();
        }
        catch (NullPointerException e) {
            return -1;
        }
    }
}

