/*
 * Decompiled with CFR 0.152.
 */
package com.kontakt.sdk.android.ble.service;

import android.annotation.TargetApi;
import android.bluetooth.le.ScanFilter;
import android.bluetooth.le.ScanSettings;
import android.content.Context;
import com.kontakt.sdk.android.ble.cache.FutureShufflesCache;
import com.kontakt.sdk.android.ble.configuration.ForceScanConfiguration;
import com.kontakt.sdk.android.ble.configuration.KontaktScanFilter;
import com.kontakt.sdk.android.ble.configuration.ScanContext;
import com.kontakt.sdk.android.ble.monitoring.IEventCollector;
import com.kontakt.sdk.android.ble.service.ForceScanScheduler;
import com.kontakt.sdk.android.ble.service.MonitorCallback;
import com.kontakt.sdk.android.ble.service.MonitorCallbackL;
import com.kontakt.sdk.android.ble.service.Runners;
import com.kontakt.sdk.android.ble.service.RunnersL;
import com.kontakt.sdk.android.ble.service.ScanCompat;
import com.kontakt.sdk.android.ble.service.ScanConfiguration;
import com.kontakt.sdk.android.ble.service.ScanController;
import java.util.ArrayList;
import java.util.List;

@TargetApi(value=21)
final class ScanCompatL
extends ScanCompat {
    ScanCompatL() {
    }

    @Override
    public ScanConfiguration createScanConfiguration(final Context context, ScanContext scanContext, FutureShufflesCache cache, IEventCollector eventCollector) {
        MonitorCallback callback = MonitorCallback.create(scanContext, cache, eventCollector);
        MonitorCallbackL callbackL = MonitorCallbackL.wrap(callback);
        final ScanSettings scanSettings = new ScanSettings.Builder().setScanMode(scanContext.getScanMode().getCode()).build();
        final List<ScanFilter> scanFilters = this.getScanFilters(scanContext.getKontaktScanFilters());
        return new ScanCompat.AbstractScanConfigurationL(scanContext, callbackL){

            @Override
            public ScanSettings getScanSettings() {
                return scanSettings;
            }

            @Override
            public List<ScanFilter> getScanFilterList() {
                return scanFilters;
            }

            @Override
            public Context getContext() {
                return context;
            }
        };
    }

    private List<ScanFilter> getScanFilters(List<KontaktScanFilter> kontaktScanFilters) {
        ArrayList<ScanFilter> scanFilters = new ArrayList<ScanFilter>();
        for (KontaktScanFilter kontaktScanFilter : kontaktScanFilters) {
            ScanFilter.Builder builder = new ScanFilter.Builder();
            for (KontaktScanFilter.FilterType filterType : kontaktScanFilter.getFilterTypes()) {
                switch (filterType) {
                    case DEVICE_NAME: {
                        builder.setDeviceName(kontaktScanFilter.getDeviceName());
                        break;
                    }
                    case DEVICE_ADDRESS: {
                        builder.setDeviceAddress(kontaktScanFilter.getDeviceAddress());
                        break;
                    }
                    case SERVICE_DATA: {
                        builder.setServiceData(kontaktScanFilter.getServiceDataUuid(), kontaktScanFilter.getServiceData(), kontaktScanFilter.getServiceDataMask());
                        break;
                    }
                    case MANUFACTURER_DATA: {
                        builder.setManufacturerData(kontaktScanFilter.getManufacturerId(), kontaktScanFilter.getManufacturerData(), kontaktScanFilter.getManufacturerDataMask());
                        break;
                    }
                    case SERVICE_UUID: {
                        builder.setServiceUuid(kontaktScanFilter.getServiceUuid(), kontaktScanFilter.getServiceUuidMask());
                    }
                }
            }
            scanFilters.add(builder.build());
        }
        return scanFilters;
    }

    @Override
    public ScanController createScanController(ScanConfiguration configuration, ForceScanScheduler forceScanScheduler) {
        return new ScanController.Builder().setScanPeriod(configuration.getScanContext().getScanPeriod()).setScanActiveRunner(RunnersL.newRunner(Runners.RunnerType.MONITOR_ACTIVE_RUNNER, configuration)).setScanPassiveRunner(RunnersL.newRunner(Runners.RunnerType.MONITOR_PASSIVE_RUNNER, configuration)).setForceScanScheduler(forceScanScheduler).build();
    }

    @Override
    public ForceScanScheduler createForceScanScheduler(ScanConfiguration configuration) {
        ScanContext scanContext = configuration.getScanContext();
        if (scanContext.getForceScanConfiguration() == ForceScanConfiguration.DISABLED) {
            return ForceScanScheduler.DISABLED;
        }
        return new ForceScanScheduler(RunnersL.newRunner(Runners.RunnerType.FORCE_SCAN_RUNNER, configuration));
    }
}

