/*
 * Decompiled with CFR 0.152.
 */
package com.kontakt.sdk.android.ble.service;

import android.annotation.TargetApi;
import android.app.PendingIntent;
import android.bluetooth.le.BluetoothLeScanner;
import android.bluetooth.le.ScanCallback;
import android.bluetooth.le.ScanFilter;
import android.bluetooth.le.ScanSettings;
import android.content.Context;
import android.content.Intent;
import android.os.Build;
import com.kontakt.sdk.android.ble.configuration.ForceScanConfiguration;
import com.kontakt.sdk.android.ble.service.BackgroundScanBroadcastReceiver;
import com.kontakt.sdk.android.ble.service.MonitorCallbackL;
import com.kontakt.sdk.android.ble.service.Runners;
import com.kontakt.sdk.android.ble.service.ScanConfiguration;
import com.kontakt.sdk.android.ble.service.ScanConfigurationL;
import com.kontakt.sdk.android.ble.service.ScannerUtil;
import com.kontakt.sdk.android.common.log.Logger;
import com.kontakt.sdk.android.common.util.SDKPreconditions;
import java.util.List;
import java.util.concurrent.TimeUnit;

final class RunnersL {
    private RunnersL() {
    }

    static Runnable newRunner(Runners.RunnerType runnerType, ScanConfiguration configuration) {
        switch (runnerType) {
            case MONITOR_ACTIVE_RUNNER: {
                return RunnersL.shouldPerformAndroid8Scan((ScanConfigurationL)configuration) ? RunnersL.newMonitorActiveRunnerAndroid8((ScanConfigurationL)configuration) : RunnersL.newMonitorActiveRunnerL((ScanConfigurationL)configuration);
            }
            case MONITOR_PASSIVE_RUNNER: {
                return RunnersL.shouldPerformAndroid8Scan((ScanConfigurationL)configuration) ? RunnersL.newMonitorPassiveRunnerAndroid8((ScanConfigurationL)configuration) : RunnersL.newMonitorPassiveRunnerL((ScanConfigurationL)configuration);
            }
            case FORCE_SCAN_RUNNER: {
                return RunnersL.newForceScanRunnerL((ScanConfigurationL)configuration);
            }
        }
        throw new IllegalArgumentException("Invalid runner type passed");
    }

    private static boolean shouldPerformAndroid8Scan(ScanConfigurationL configuration) {
        return Build.VERSION.SDK_INT >= 26 && configuration.getContext() != null;
    }

    private static Runnable newMonitorPassiveRunnerL(ScanConfigurationL configuration) {
        final MonitorCallbackL monitorCallback = (MonitorCallbackL)configuration.getScanCallback();
        return new Runnable(){

            @Override
            @TargetApi(value=21)
            public void run() {
                BluetoothLeScanner scanner = ScannerUtil.getScanner(monitorCallback);
                if (scanner == null) {
                    return;
                }
                monitorCallback.onMonitorStopped();
                Logger.d("Stopping scan");
                scanner.stopScan((ScanCallback)monitorCallback);
                Logger.d("On monitor stopped");
            }
        };
    }

    private static Runnable newMonitorActiveRunnerL(ScanConfigurationL configuration) {
        final MonitorCallbackL monitorCallback = (MonitorCallbackL)configuration.getScanCallback();
        final ScanSettings scanSettings = configuration.getScanSettings();
        final List<ScanFilter> scanFilterList = configuration.getScanFilterList();
        return new Runnable(){

            @Override
            @TargetApi(value=21)
            public void run() {
                BluetoothLeScanner scanner = ScannerUtil.getScanner(monitorCallback);
                if (scanner == null) {
                    return;
                }
                Logger.d("Start Scan");
                scanner.startScan(scanFilterList, scanSettings, (ScanCallback)monitorCallback);
                Logger.d("On Monitor started");
                monitorCallback.onMonitorStarted();
            }
        };
    }

    private static Runnable newForceScanRunnerL(ScanConfigurationL configuration) {
        final MonitorCallbackL monitorCallback = (MonitorCallbackL)configuration.getScanCallback();
        final ScanSettings scanSettings = configuration.getScanSettings();
        ForceScanConfiguration forceScanConfiguration = configuration.getScanContext().getForceScanConfiguration();
        final long forceScanActivePeriod = forceScanConfiguration.getForceScanActivePeriod();
        final long forceScanPassivePeriod = forceScanConfiguration.getForceScanPassivePeriod();
        final List<ScanFilter> scanFilterList = configuration.getScanFilterList();
        return new Runnable(){

            @Override
            @TargetApi(value=21)
            public void run() {
                BluetoothLeScanner scanner = ScannerUtil.getScanner(monitorCallback);
                if (scanner == null) {
                    return;
                }
                try {
                    while (!Thread.currentThread().isInterrupted()) {
                        Logger.d("Stopping Scan (force)");
                        scanner.stopScan((ScanCallback)monitorCallback);
                        Logger.d(String.format("Sleep during passive period: %s", String.valueOf(forceScanPassivePeriod)));
                        TimeUnit.MILLISECONDS.sleep(forceScanPassivePeriod);
                        Logger.d("Starting scan (force)");
                        scanner.startScan(scanFilterList, scanSettings, (ScanCallback)monitorCallback);
                        Logger.d(String.format("Sleep during active period: %s", String.valueOf(forceScanActivePeriod)));
                        TimeUnit.MILLISECONDS.sleep(forceScanActivePeriod);
                    }
                    scanner.stopScan((ScanCallback)monitorCallback);
                    Logger.d("Force scan finished");
                }
                catch (InterruptedException e) {
                    scanner.stopScan((ScanCallback)monitorCallback);
                    Logger.d("Force scan interrupted");
                }
            }
        };
    }

    @TargetApi(value=26)
    private static Runnable newMonitorActiveRunnerAndroid8(final ScanConfigurationL configuration) {
        SDKPreconditions.checkNotNull(configuration.getContext(), "On Androids 8 and higher, app context cannot be null during scannings");
        final Context context = configuration.getContext();
        final MonitorCallbackL monitorCallback = (MonitorCallbackL)configuration.getScanCallback();
        return new Runnable(){

            @Override
            public void run() {
                monitorCallback.onMonitorStarted();
                ScanSettings settings = configuration.getScanSettings();
                List<ScanFilter> filters = configuration.getScanFilterList();
                BluetoothLeScanner scanner = ScannerUtil.getScanner(monitorCallback);
                if (scanner == null) {
                    return;
                }
                int requestCode = ScannerUtil.getReceiverCodeRequest(monitorCallback);
                BackgroundScanBroadcastReceiver.setMonitorCallbackL(monitorCallback, requestCode);
                Intent intent = new Intent(context, BackgroundScanBroadcastReceiver.class);
                intent.setAction("com.kontakt.sdk.android.ble.service.ACTION_FOUND");
                PendingIntent pendingIntent = ScannerUtil.getBroadcastPendingIntent(context, requestCode);
                try {
                    int result = scanner.startScan(filters, settings, pendingIntent);
                    Logger.d("Result of scanning: " + result);
                }
                catch (Exception e) {
                    Logger.e("Android 8 startScan() failed");
                    e.printStackTrace();
                    monitorCallback.onScanFailed(3);
                }
            }
        };
    }

    @TargetApi(value=26)
    private static Runnable newMonitorPassiveRunnerAndroid8(ScanConfigurationL configuration) {
        SDKPreconditions.checkNotNull(configuration.getContext(), "On Androids 8 and higher, app context cannot be null");
        final Context context = configuration.getContext();
        final MonitorCallbackL monitorCallback = (MonitorCallbackL)configuration.getScanCallback();
        return new Runnable(){

            @Override
            public void run() {
                Logger.d("Unregistering scan receiver");
                monitorCallback.onMonitorStopped();
                int requestCode = ScannerUtil.getReceiverCodeRequest(monitorCallback);
                BackgroundScanBroadcastReceiver.setMonitorCallbackL(null, requestCode);
                Logger.d("Stopping android 8 background scan");
                BluetoothLeScanner scanner = ScannerUtil.getScanner(monitorCallback);
                if (scanner == null) {
                    Logger.d("Background android scan stop: scanner is null, returning");
                    return;
                }
                PendingIntent pendingIntent = ScannerUtil.getBroadcastPendingIntent(context, requestCode);
                scanner.stopScan(pendingIntent);
            }
        };
    }
}

