/*
 * Decompiled with CFR 0.152.
 */
package com.kontakt.sdk.android.ble.service;

import android.annotation.SuppressLint;
import android.annotation.TargetApi;
import android.bluetooth.BluetoothDevice;
import android.bluetooth.le.BluetoothLeScanner;
import android.bluetooth.le.ScanCallback;
import android.bluetooth.le.ScanRecord;
import android.bluetooth.le.ScanResult;
import com.kontakt.sdk.android.ble.discovery.ScanErrors;
import com.kontakt.sdk.android.ble.exception.ScanError;
import com.kontakt.sdk.android.ble.manager.listeners.InternalProximityListener;
import com.kontakt.sdk.android.ble.service.BleScanCallback;
import com.kontakt.sdk.android.ble.service.MonitorCallback;
import com.kontakt.sdk.android.ble.service.ScannerUtil;
import com.kontakt.sdk.android.common.log.Logger;
import com.kontakt.sdk.android.common.util.SDKPreconditions;
import java.io.IOException;
import java.util.Collection;
import java.util.List;

@TargetApi(value=21)
abstract class MonitorCallbackL
extends ScanCallback
implements BleScanCallback {
    private static final String TAG = MonitorCallbackL.class.getSimpleName();
    private boolean scanStopped = false;
    private final MonitorCallback wrappedScanCallback;

    static MonitorCallbackL wrap(BleScanCallback scanCallback) {
        return new MonitorCallbackL((MonitorCallback)scanCallback){};
    }

    private MonitorCallbackL(MonitorCallback scanCallback) {
        SDKPreconditions.checkNotNull(scanCallback, "Wrapped scan callback is null");
        this.wrappedScanCallback = scanCallback;
    }

    public void onScanResult(int callbackType, ScanResult result) {
        if (callbackType != 1) {
            return;
        }
        ScanRecord scanRecord = result.getScanRecord();
        if (scanRecord == null) {
            return;
        }
        this.onLeScan(result.getDevice(), result.getRssi(), scanRecord.getBytes());
    }

    public void onLeScan(BluetoothDevice device, int rssi, byte[] scanRecord) {
        this.doLeScanIfNotStopped(device, rssi, scanRecord);
    }

    private void doLeScanIfNotStopped(BluetoothDevice device, int rssi, byte[] scanRecord) {
        if (this.scanStopped) {
            Logger.w(TAG + " Scan stop was called but scan result came, stopping BT scanner");
            this.stopScan();
            return;
        }
        Logger.d(TAG + " Scan not stopped yet, processing received bytes");
        this.wrappedScanCallback.onLeScan(device, rssi, scanRecord);
    }

    @SuppressLint(value={"MissingPermission"})
    private void stopScan() {
        try {
            BluetoothLeScanner scanner = ScannerUtil.getScanner(this);
            if (scanner != null) {
                scanner.stopScan((ScanCallback)this);
            }
        }
        catch (Exception e) {
            Logger.e(TAG + " Tried to stop scan from monitor callback, but sth went wrong");
            e.printStackTrace();
        }
    }

    public void onScanFailed(int errorCode) {
        String message = ScanErrors.getMessage(errorCode);
        Logger.e(message);
        this.wrappedScanCallback.onScanError(new ScanError(message));
    }

    public void onBatchScanResults(List<ScanResult> results) {
        Logger.d(TAG + " Batch results arrived: " + results);
        if (results == null) {
            Logger.d(TAG + " Batch results null, returning");
            return;
        }
        Logger.d(TAG + " Batch results size: " + results.size());
        for (ScanResult result : results) {
            ScanRecord scanRecord = result.getScanRecord();
            if (scanRecord != null) {
                this.doLeScanIfNotStopped(result.getDevice(), result.getRssi(), scanRecord.getBytes());
                continue;
            }
            Logger.w(TAG + " Null scan record");
        }
    }

    @Override
    public Collection<InternalProximityListener> getMonitoringListeners() {
        return this.wrappedScanCallback.getMonitoringListeners();
    }

    @Override
    public void addListener(InternalProximityListener proximityListener) {
        this.wrappedScanCallback.addListener(proximityListener);
    }

    @Override
    public void removeListener(InternalProximityListener proximityListener) {
        this.wrappedScanCallback.removeListener(proximityListener);
    }

    @Override
    public void close() throws IOException {
        this.wrappedScanCallback.close();
    }

    void onMonitorStarted() {
        this.scanStopped = false;
        this.wrappedScanCallback.onMonitorCycleStart();
    }

    void onMonitorStopped() {
        this.scanStopped = true;
        this.wrappedScanCallback.onMonitorCycleStop();
    }
}

