/*
 * Decompiled with CFR 0.152.
 */
package com.kontakt.sdk.android.ble.service;

import android.annotation.SuppressLint;
import android.annotation.TargetApi;
import android.bluetooth.le.BluetoothLeScanner;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import com.kontakt.sdk.android.ble.service.MonitorCallbackL;
import com.kontakt.sdk.android.ble.service.ScannerUtil;
import com.kontakt.sdk.android.common.log.Logger;
import java.util.ArrayList;
import java.util.concurrent.CopyOnWriteArraySet;

public class BackgroundScanBroadcastReceiver
extends BroadcastReceiver {
    private static final String TAG = BackgroundScanBroadcastReceiver.class.getSimpleName();
    private static MonitorCallbackL monitorCallback;
    private static CopyOnWriteArraySet<Integer> cancelledCallbacks;

    @SuppressLint(value={"MissingPermission"})
    @TargetApi(value=26)
    public void onReceive(Context context, Intent intent) {
        Logger.d("RECEIVED BROADCAST: " + intent.getAction() + " MonitorCallback: " + monitorCallback);
        int bleCallbackType = intent.getIntExtra("android.bluetooth.le.extra.CALLBACK_TYPE", -1);
        if (bleCallbackType != -1) {
            Logger.d("Passive background scan callback type: " + bleCallbackType);
            ArrayList scanResults = intent.getParcelableArrayListExtra("android.bluetooth.le.extra.LIST_SCAN_RESULT");
            try {
                this.stopScanIfCancelled(context, intent);
                monitorCallback.onBatchScanResults(scanResults);
            }
            catch (NullPointerException e) {
                Logger.w("Null monitor callback");
            }
        }
    }

    @SuppressLint(value={"MissingPermission"})
    @TargetApi(value=26)
    private void stopScanIfCancelled(Context context, Intent intent) {
        try {
            Bundle extras = intent.getExtras();
            if (extras == null) {
                return;
            }
            int requestCode = extras.getInt("requestCode");
            if (!cancelledCallbacks.contains(requestCode) || ScannerUtil.getReceiverCodeRequest(monitorCallback) == requestCode) {
                return;
            }
            Logger.w(TAG + " Intent's request code was cancelled and scanner works, stopping scanner for request code: " + requestCode);
            BluetoothLeScanner scanner = ScannerUtil.getScanner(null);
            if (scanner != null) {
                scanner.stopScan(ScannerUtil.getBroadcastPendingIntent(context, requestCode));
            }
        }
        catch (Exception e) {
            Logger.e(TAG + " Tried to stop BT scanner from Background Scan Broadcast Receiver");
            e.printStackTrace();
        }
    }

    public static void setMonitorCallbackL(MonitorCallbackL monitorCallback, int requestCode) {
        Logger.d(TAG + " Setting monitor callback to " + monitorCallback);
        BackgroundScanBroadcastReceiver.monitorCallback = monitorCallback;
        if (monitorCallback == null) {
            cancelledCallbacks.add(requestCode);
        }
    }

    static {
        cancelledCallbacks = new CopyOnWriteArraySet();
    }
}

