/*
 * Decompiled with CFR 0.152.
 */
package com.kontakt.sdk.android.ble.security.property;

import com.kontakt.sdk.android.ble.security.property.PropertyDataType;
import com.kontakt.sdk.android.ble.security.property.PropertyName;
import java.util.HashSet;
import java.util.Set;

public class PropertyID {
    public static final PropertyID PROPERTY_PROXIMITY_UUID = new PropertyID(PropertyName.PROXIMITY_UUID, 33041, PropertyDataType.BYTE_ARRAY);
    public static final PropertyID PROPERTY_MAJOR = new PropertyID(PropertyName.MAJOR, 33042, PropertyDataType.UINT16);
    public static final PropertyID PROPERTY_MINOR = new PropertyID(PropertyName.MINOR, 33043, PropertyDataType.UINT16);
    public static final PropertyID PROPERTY_NAME = new PropertyID(PropertyName.NAME, 33044, PropertyDataType.STRING);
    public static final PropertyID PROPERTY_BEACON_ID = new PropertyID(PropertyName.BEACON_ID, 33045, PropertyDataType.STRING);
    public static final PropertyID PROPERTY_REF_TX_1M = new PropertyID(PropertyName.REF_TX_1M, 33046, PropertyDataType.BYTE_ARRAY);
    public static final PropertyID PROPERTY_NAMESPACE_ID = new PropertyID(PropertyName.NAMESPACE_ID, 33047, PropertyDataType.BYTE_ARRAY);
    public static final PropertyID PROPERTY_INSTANCE_ID = new PropertyID(PropertyName.INSTANCE_ID, 33048, PropertyDataType.BYTE_ARRAY);
    public static final PropertyID PROPERTY_URL = new PropertyID(PropertyName.URL, 33049, PropertyDataType.BYTE_ARRAY);
    public static final PropertyID PROPERTY_REF_TX_0M = new PropertyID(PropertyName.REF_TX_0M, 33050, PropertyDataType.BYTE_ARRAY);
    public static final PropertyID PROPERTY_INTERVAL = new PropertyID(PropertyName.INTERVAL, 33057, PropertyDataType.UINT16);
    public static final PropertyID PROPERTY_SET_PASSWORD = new PropertyID(PropertyName.SET_PASSWORD, 33074, PropertyDataType.STRING);
    public static final PropertyID PROPERTY_SHUFFLE_INTERVAL = new PropertyID(PropertyName.SHUFFLE_INTERVAL, 33080, PropertyDataType.UINT16);
    public static final PropertyID PROPERTY_ACTIVE_PROFILE = new PropertyID(PropertyName.ACTIVE_PROFILE, 33082, PropertyDataType.UINT8);
    public static final PropertyID PROPERTY_TX_POWER = new PropertyID(PropertyName.TX_POWER, 10759, PropertyDataType.INT8);
    public static final PropertyID PROPERTY_EDDY_EID_SCALER = new PropertyID(PropertyName.EDDY_EID_SCALER, 33052, PropertyDataType.UINT8);
    public static final PropertyID PROPERTY_BEACON_PACKETS_MASK = new PropertyID(PropertyName.BEACON_PACKETS_MASK, 33054, PropertyDataType.UINT32);
    public static final PropertyID PROPERTY_POWER_SAVER_FEATURES_MASK = new PropertyID(PropertyName.POWER_SAVER_FEATURES_MASK, 33536, PropertyDataType.UINT32);
    public static final PropertyID PROPERTY_MOVE_SUSPEND_TIMEOUT = new PropertyID(PropertyName.MOVE_SUSPEND_TIMEOUT, 33537, PropertyDataType.UINT32);
    public static final PropertyID PROPERTY_LIGHT_SENSOR_THRESHOLD = new PropertyID(PropertyName.LIGHT_SENSOR_THRESHOLD, 33538, PropertyDataType.INT8);
    public static final PropertyID PROPERTY_LIGHT_SENSOR_HIST = new PropertyID(PropertyName.LIGHT_SENSOR_HIST, 33539, PropertyDataType.INT8);
    public static final PropertyID PROPERTY_LIGHT_SENSOR_SAMPLING_INTERVAL = new PropertyID(PropertyName.LIGHT_SENSOR_SAMPLING_INTERVAL, 33540, PropertyDataType.UINT32);
    public static final PropertyID PROPERTY_TEMPERATURE_OFFSET = new PropertyID(PropertyName.TEMPERATURE_OFFSET, 37200, PropertyDataType.INT8);
    public static final PropertyID PROPERTY_WIFI_SSID = new PropertyID(PropertyName.WIFI_SSID, 33281, PropertyDataType.STRING);
    public static final PropertyID PROPERTY_WIFI_USER = new PropertyID(PropertyName.WIFI_USER, 33282, PropertyDataType.STRING);
    public static final PropertyID PROPERTY_WIFI_PASS = new PropertyID(PropertyName.WIFI_PASS, 33283, PropertyDataType.STRING);
    public static final PropertyID PROPERTY_WIFI_PROTOCOL = new PropertyID(PropertyName.WIFI_PROTOCOL, 33284, PropertyDataType.INT8);
    public static final PropertyID PROPERTY_API_KEY = new PropertyID(PropertyName.API_KEY, 33285, PropertyDataType.STRING);
    public static final PropertyID PROPERTY_TERMINATING = new PropertyID(PropertyName.TERMINATING, 65535, PropertyDataType.NONE);
    public static final PropertyID[] PREDEFINED_PROPERTIES = new PropertyID[]{PROPERTY_PROXIMITY_UUID, PROPERTY_MAJOR, PROPERTY_MINOR, PROPERTY_NAME, PROPERTY_BEACON_ID, PROPERTY_REF_TX_1M, PROPERTY_NAMESPACE_ID, PROPERTY_INSTANCE_ID, PROPERTY_URL, PROPERTY_REF_TX_0M, PROPERTY_INTERVAL, PROPERTY_SET_PASSWORD, PROPERTY_SHUFFLE_INTERVAL, PROPERTY_ACTIVE_PROFILE, PROPERTY_TX_POWER, PROPERTY_EDDY_EID_SCALER, PROPERTY_BEACON_PACKETS_MASK, PROPERTY_POWER_SAVER_FEATURES_MASK, PROPERTY_MOVE_SUSPEND_TIMEOUT, PROPERTY_LIGHT_SENSOR_THRESHOLD, PROPERTY_LIGHT_SENSOR_HIST, PROPERTY_LIGHT_SENSOR_SAMPLING_INTERVAL, PROPERTY_TEMPERATURE_OFFSET, PROPERTY_WIFI_SSID, PROPERTY_WIFI_USER, PROPERTY_WIFI_PASS, PROPERTY_WIFI_PROTOCOL, PROPERTY_API_KEY, PROPERTY_TERMINATING};
    private static final Set<PropertyID> customProperties = new HashSet<PropertyID>();
    private final PropertyName name;
    private final short value;
    private final PropertyDataType type;

    public static PropertyID createCustom(int value) {
        return new PropertyID(PropertyName.CUSTOM, value, PropertyDataType.BYTE_ARRAY);
    }

    private PropertyID(PropertyName name, int value, PropertyDataType type) {
        this.name = name;
        this.type = type;
        this.value = (short)value;
    }

    public PropertyName getName() {
        return this.name;
    }

    public short getValue() {
        return this.value;
    }

    public PropertyDataType getDataType() {
        return this.type;
    }

    public static PropertyID get(short value) {
        for (PropertyID property : PREDEFINED_PROPERTIES) {
            if (property.getValue() != value) continue;
            return property;
        }
        for (PropertyID property : customProperties) {
            if (property.getValue() != value) continue;
            return property;
        }
        return null;
    }

    public static void defineCustomProperties(Set<PropertyID> properties) {
        if (properties == null || properties.isEmpty()) {
            return;
        }
        customProperties.clear();
        customProperties.addAll(properties);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PropertyID that = (PropertyID)o;
        if (this.value != that.value) {
            return false;
        }
        if (this.name != that.name) {
            return false;
        }
        return this.type == that.type;
    }

    public int hashCode() {
        int result = this.name != null ? this.name.hashCode() : 0;
        result = 31 * result + this.value;
        result = 31 * result + (this.type != null ? this.type.hashCode() : 0);
        return result;
    }

    public String toString() {
        return "PropertyID{name=" + (Object)((Object)this.name) + ", value=" + this.value + ", type=" + (Object)((Object)this.type) + '}';
    }
}

