/*
 * Decompiled with CFR 0.152.
 */
package com.kontakt.sdk.android.ble.security;

import android.util.Base64;
import com.kontakt.sdk.android.ble.security.Flag;
import com.kontakt.sdk.android.ble.security.Operation;
import java.nio.ByteBuffer;

public abstract class Packet {
    public static final byte PROTOCOL_VERSION = 0;
    private static final int TOKEN_SIZE = 4;
    private final Flag flag;
    private final Operation operation;
    protected final int token;

    protected Packet(Flag flag, Operation operation, int token) {
        this.flag = flag;
        this.operation = operation;
        this.token = Integer.reverseBytes(token);
    }

    public byte[] getData() {
        ByteBuffer buf = ByteBuffer.allocate(256);
        buf.put((byte)0);
        buf.put(this.flag.getValue());
        buf.put(this.operation.getValue());
        byte[] payload = this.getPayload();
        buf.putShort(Short.reverseBytes((short)(payload.length + 4)));
        buf.putInt(this.token);
        buf.put(payload);
        int position = buf.position();
        buf.position(0);
        byte[] result = new byte[position];
        buf.get(result);
        return result;
    }

    public String getBase64Data() {
        byte[] data = this.getData();
        return Base64.encodeToString((byte[])data, (int)0);
    }

    protected abstract byte[] getPayload();
}

