/*
 * Decompiled with CFR 0.152.
 */
package com.kontakt.sdk.android.ble.monitoring;

import com.kontakt.sdk.android.ble.configuration.ScanContext;
import com.kontakt.sdk.android.ble.monitoring.EventCollectorClient;
import com.kontakt.sdk.android.ble.monitoring.EventCollectorClientFactory;
import com.kontakt.sdk.android.ble.monitoring.IEventCollector;
import com.kontakt.sdk.android.ble.spec.KontaktTelemetry;
import com.kontakt.sdk.android.common.log.Logger;
import com.kontakt.sdk.android.common.model.BasicTelemetryCollectEvent;
import com.kontakt.sdk.android.common.model.FullTelemetryCollectEvent;
import com.kontakt.sdk.android.common.profile.ISecureProfile;
import com.kontakt.sdk.android.common.profile.RemoteBluetoothDevice;
import com.kontakt.sdk.android.common.util.SDKPreconditions;
import com.kontakt.sdk.android.common.util.SecureProfileUtils;
import java.io.IOException;
import java.net.SocketTimeoutException;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ConcurrentSkipListSet;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;

public class EventCollector
implements IEventCollector {
    private static final String TAG = "EventCollector";
    private final EventSender eventSender;
    private ScanContext scanContext;
    private ScheduledExecutorService executorService;

    public EventCollector(EventSender eventSender, ScanContext scanContext) {
        this.eventSender = SDKPreconditions.checkNotNull(eventSender);
        this.scanContext = SDKPreconditions.checkNotNull(scanContext);
    }

    @Override
    public void collect(RemoteBluetoothDevice device) {
        this.eventSender.collect(device);
    }

    @Override
    public void collectSecureProfile(ISecureProfile secureProfile) {
        this.eventSender.collectSecureProfile(secureProfile);
    }

    @Override
    public void stop() {
        if (this.executorService == null) {
            return;
        }
        this.executorService.shutdown();
        this.executorService = null;
    }

    @Override
    public void clear() {
        this.eventSender.clear();
    }

    @Override
    public void start() {
        if (this.executorService != null || !this.scanContext.isMonitoringEnabled()) {
            return;
        }
        this.executorService = Executors.newSingleThreadScheduledExecutor();
        this.executorService.scheduleWithFixedDelay(this.eventSender, this.scanContext.getMonitoringSyncInterval(), this.scanContext.getMonitoringSyncInterval(), TimeUnit.SECONDS);
    }

    ScheduledExecutorService getExecutorService() {
        return this.executorService;
    }

    public static class EventSender
    implements Runnable {
        private static final int DEFAULT_BUFFER_SIZE = 200;
        private final ConcurrentSkipListSet<String> ignored = new ConcurrentSkipListSet();
        private final BlockingQueue<BasicTelemetryCollectEvent> basicEventsBuffer = new ArrayBlockingQueue<BasicTelemetryCollectEvent>(200, true);
        private final BlockingQueue<FullTelemetryCollectEvent> fullTelemetryEventsBuffer = new ArrayBlockingQueue<FullTelemetryCollectEvent>(200, true);
        private final EventCollectorClient eventCollectorClient = EventCollectorClientFactory.create();
        private final String androidId;

        public EventSender(String androidId) {
            this.androidId = androidId;
        }

        @Override
        public void run() {
            this.sendBasicEvents();
            this.sendFullTelemetryEvents();
        }

        private void sendBasicEvents() {
            ArrayList<BasicTelemetryCollectEvent> events = new ArrayList<BasicTelemetryCollectEvent>();
            this.basicEventsBuffer.drainTo(events);
            if (events.isEmpty()) {
                Logger.d("EventCollector Nothing to send from basic events");
                return;
            }
            try {
                this.eventCollectorClient.collectBaseEvents(events);
            }
            catch (IOException e) {
                Throwable cause = e.getCause();
                if (cause instanceof UnknownHostException || cause instanceof SocketTimeoutException) {
                    this.basicEventsBuffer.addAll(events);
                }
                Logger.e("EventCollector Error occurred when try to send basic monitoring events", e);
            }
        }

        private void sendFullTelemetryEvents() {
            ArrayList<FullTelemetryCollectEvent> events = new ArrayList<FullTelemetryCollectEvent>();
            this.fullTelemetryEventsBuffer.drainTo(events);
            if (events.isEmpty()) {
                Logger.d("EventCollector Nothing to send from full telemetry events");
                return;
            }
            try {
                this.eventCollectorClient.collectFullTelemetryEvents(events);
            }
            catch (IOException e) {
                Throwable cause = e.getCause();
                if (cause instanceof UnknownHostException || cause instanceof SocketTimeoutException) {
                    this.fullTelemetryEventsBuffer.addAll(events);
                }
                Logger.e("EventCollector Error occurred when try to send full monitoring events", e);
            }
        }

        void collectSecureProfile(ISecureProfile secureProfile) {
            KontaktTelemetry telemetry = secureProfile.getTelemetry();
            if (telemetry != null) {
                this.collectTelemetry(secureProfile);
            } else {
                this.collect(SecureProfileUtils.asRemoteBluetoothDevice(secureProfile));
            }
        }

        private void collectTelemetry(ISecureProfile secureProfile) {
            FullTelemetryCollectEvent event = FullTelemetryCollectEvent.of(secureProfile, this.androidId);
            String eventId = event.eventId();
            if (this.ignored.contains(eventId)) {
                return;
            }
            try {
                this.fullTelemetryEventsBuffer.add(event);
                this.ignored.add(eventId);
            }
            catch (IllegalStateException e) {
                Logger.e("Event collector queue is full", e);
            }
        }

        void collect(RemoteBluetoothDevice device) {
            String notificationId = device.getUniqueId() + ":" + device.getBatteryPower();
            if (this.ignored.contains(notificationId)) {
                return;
            }
            BasicTelemetryCollectEvent event = BasicTelemetryCollectEvent.of(device, this.androidId);
            try {
                this.basicEventsBuffer.add(event);
                this.ignored.add(notificationId);
            }
            catch (IllegalStateException e) {
                Logger.e("Event collector queue is full", e);
            }
        }

        public void clear() {
            this.basicEventsBuffer.clear();
            this.fullTelemetryEventsBuffer.clear();
            this.ignored.clear();
        }
    }
}

