/*
 * Decompiled with CFR 0.152.
 */
package com.kontakt.sdk.android.ble.manager.internal;

import android.annotation.SuppressLint;
import android.annotation.TargetApi;
import android.app.Notification;
import android.content.ComponentName;
import android.content.ContentResolver;
import android.content.Context;
import android.content.Intent;
import android.content.ServiceConnection;
import android.os.Handler;
import android.os.IBinder;
import android.os.Message;
import android.os.Messenger;
import android.os.RemoteException;
import android.provider.Settings;
import com.kontakt.sdk.android.ble.cache.FutureShufflesCache;
import com.kontakt.sdk.android.ble.configuration.ScanContext;
import com.kontakt.sdk.android.ble.connection.OnServiceReadyListener;
import com.kontakt.sdk.android.ble.exception.ScanError;
import com.kontakt.sdk.android.ble.manager.internal.ShuffledSpacesManager;
import com.kontakt.sdk.android.ble.manager.listeners.InternalProximityListener;
import com.kontakt.sdk.android.ble.manager.service.AbstractServiceConnector;
import com.kontakt.sdk.android.ble.monitoring.EventCollector;
import com.kontakt.sdk.android.ble.monitoring.IEventCollector;
import com.kontakt.sdk.android.ble.service.ProximityService;
import com.kontakt.sdk.android.cloud.KontaktCloud;
import com.kontakt.sdk.android.common.interfaces.SDKBiProvider;
import com.kontakt.sdk.android.common.interfaces.SDKSupplier;
import com.kontakt.sdk.android.common.log.Logger;
import com.kontakt.sdk.android.common.util.SDKPreconditions;

public class InternalProximityManager
extends AbstractServiceConnector {
    static final String TAG = InternalProximityManager.class.getSimpleName();
    private final ShuffledSpacesManager shuffledSpacesManager;
    private final KontaktCloud kontaktCloud;
    private Notification foregroundNotification;
    private int notificationId = -1;
    private InternalProximityListener proximityListener;
    private Context context;
    private ServiceConnection serviceConnection;
    private FutureShufflesCache shufflesCache;
    private IEventCollector eventCollector;
    private Messenger managerMessenger;
    Messenger serviceMessenger;
    boolean isScanning;

    public InternalProximityManager(Context context, KontaktCloud kontaktCloud) {
        super(context);
        SDKPreconditions.checkNotNull(kontaktCloud);
        this.context = context.getApplicationContext();
        this.managerMessenger = new Messenger((Handler)new ManagerHandler(this));
        this.shuffledSpacesManager = new ShuffledSpacesManager(kontaktCloud);
        this.kontaktCloud = kontaktCloud;
    }

    public void setForegroundNotification(Notification notification, int notificationId) {
        this.notificationId = notificationId;
        this.foregroundNotification = notification;
    }

    @Override
    @TargetApi(value=15)
    public synchronized void connect(final OnServiceReadyListener onServiceReadyListener) {
        SDKPreconditions.checkNotNull(onServiceReadyListener, "OnServiceBoundListener is null.");
        this.checkPermissions();
        if (this.isConnected()) {
            onServiceReadyListener.onServiceReady();
            Logger.d("ProximityManager already connected to BeaconService.");
            return;
        }
        this.serviceConnection = new ServiceConnection(){

            public void onServiceConnected(ComponentName name, IBinder serviceBinder) {
                SDKSupplier messengerSupplier = (SDKSupplier)serviceBinder;
                SDKBiProvider notificationProvider = (SDKBiProvider)serviceBinder;
                InternalProximityManager.this.serviceMessenger = (Messenger)messengerSupplier.get();
                notificationProvider.set(InternalProximityManager.this.foregroundNotification, InternalProximityManager.this.notificationId);
                onServiceReadyListener.onServiceReady();
                Logger.d("Proximity Service connected.");
            }

            public void onServiceDisconnected(ComponentName name) {
                Logger.d("Proximity Service disconnected.");
            }
        };
        this.bindService();
    }

    @Override
    public synchronized void disconnect() {
        if (!this.isConnected()) {
            Logger.d(TAG + ": ProximityManager already disconnected.");
            return;
        }
        if (this.isScanning()) {
            this.finishScan();
        }
        try {
            if (this.serviceConnection != null) {
                Message message = this.createMessage(6, null);
                this.serviceMessenger.send(message);
                this.context.unbindService(this.serviceConnection);
                this.serviceConnection = null;
                this.serviceMessenger = null;
            }
            super.disconnect();
        }
        catch (RemoteException e) {
            Logger.e(TAG + ": unexpected exception thrown while disconnecting from ProximityService ", e);
            throw new IllegalStateException(e);
        }
        this.shuffledSpacesManager.onDestroy();
    }

    @Override
    public synchronized boolean isConnected() {
        return this.serviceConnection != null && this.serviceMessenger != null;
    }

    public synchronized void initializeScan(ScanContext scanContext, InternalProximityListener proximityListener) {
        SDKPreconditions.checkNotNull(scanContext, "ScanContext cannot be null");
        SDKPreconditions.checkNotNull(proximityListener, "InternalProximityListener cannot be null");
        Logger.d("Initializing scan...");
        this.resolveShuffledSpaces(scanContext, proximityListener, false);
    }

    public synchronized void restartScan(ScanContext scanContext, InternalProximityListener proximityListener) {
        SDKPreconditions.checkNotNull(scanContext, "ScanContext cannot be null");
        SDKPreconditions.checkNotNull(proximityListener, "InternalProximityListener cannot be null");
        this.resolveShuffledSpaces(scanContext, proximityListener, true);
    }

    public synchronized void finishScan() {
        Logger.d("Finishing scan...");
        if (!this.isConnected()) {
            Logger.d("ProximityManager not connected");
            return;
        }
        if (!this.isScanning()) {
            Logger.d("ProximityManager is not scanning");
            return;
        }
        this.detachListener();
        Message message = this.createMessage(3, null);
        this.sendMessage(message);
        if (this.proximityListener != null) {
            this.proximityListener.onScanStop();
        }
    }

    public synchronized boolean isScanning() {
        return this.isScanning;
    }

    private synchronized void attachListener(InternalProximityListener proximityListener) {
        SDKPreconditions.checkNotNull(proximityListener, "Proximity listener is null");
        this.proximityListener = proximityListener;
        Message message = this.createMessage(4, proximityListener);
        this.sendMessage(message);
    }

    private synchronized void detachListener() {
        if (this.proximityListener != null) {
            Message message = this.createMessage(5, this.proximityListener);
            this.sendMessage(message);
        }
    }

    private void bindService() {
        Logger.d("Binding to ProximityService...");
        Intent serviceIntent = new Intent(this.context, ProximityService.class);
        boolean isBindRequestSent = this.context.bindService(serviceIntent, this.serviceConnection, 1);
        if (!isBindRequestSent) {
            String serviceName = ProximityService.class.getSimpleName();
            throw new RuntimeException(String.format("Could not connect to %s. Please check if the %s is registered in AndroidManifest.xml", serviceName, serviceName));
        }
    }

    private void resolveShuffledSpaces(ScanContext scanContext, final InternalProximityListener proximityListener, final boolean restartScan) {
        Logger.d("Resolving shuffled spaces...");
        this.shuffledSpacesManager.resolve(scanContext, new ShuffledSpacesManager.OnSpacesResolvedListener(){

            @Override
            public void onSpacesResolved(ScanContext scanContext) {
                Logger.d("Shuffled spaces resolved.");
                InternalProximityManager.this.startScanIfConnected(scanContext, restartScan, proximityListener);
            }

            @Override
            public void onError(ScanError exception) {
                Logger.e("Shuffled spaces resolving error: " + exception.getMessage());
                proximityListener.onScanError(exception);
            }
        });
    }

    void startScanIfConnected(ScanContext scanContext, boolean restartScan, InternalProximityListener proximityListener) {
        if (this.isScanning() && !restartScan) {
            Logger.d("ProximityManager is already scanning.");
            return;
        }
        this.shufflesCache = new FutureShufflesCache(this.context, this.kontaktCloud, scanContext);
        this.startEventCollector(scanContext);
        ProximityService.Bundle bundle = new ProximityService.Bundle(scanContext, this.shufflesCache, this.eventCollector);
        int messageCode = restartScan ? 2 : 1;
        Message message = this.createMessage(messageCode, bundle);
        this.sendMessage(message);
        this.attachListener(proximityListener);
        proximityListener.onScanStart();
    }

    private boolean sendMessage(Message message) {
        if (this.isConnected()) {
            try {
                this.serviceMessenger.send(message);
                return true;
            }
            catch (RemoteException e) {
                return false;
            }
        }
        Logger.d("ProximityManager already disconnected");
        return false;
    }

    private Message createMessage(int messageCode, Object obj) {
        Message message = Message.obtain(null, (int)messageCode, (int)-1, (int)-1, (Object)obj);
        message.replyTo = this.managerMessenger;
        return message;
    }

    private void startEventCollector(ScanContext scanContext) {
        if (this.eventCollector != null) {
            this.eventCollector.stop();
        }
        this.eventCollector = new EventCollector(new EventCollector.EventSender(this.getAndroidId()), scanContext);
        this.eventCollector.start();
    }

    @SuppressLint(value={"HardwareIds"})
    private String getAndroidId() {
        return Settings.Secure.getString((ContentResolver)this.context.getContentResolver(), (String)"android_id");
    }

    public synchronized void clearCache() {
        Logger.d("Clearing cache...");
        if (this.shufflesCache != null) {
            this.shufflesCache.clear();
        }
        this.clearEventCollector();
    }

    public synchronized void clearBuffers() {
        Logger.d("Clearing buffers...");
        if (this.shufflesCache != null) {
            this.shufflesCache.clearBuffers();
        }
        this.clearEventCollector();
    }

    private void clearEventCollector() {
        Logger.d("Clearing event collector...");
        if (this.eventCollector != null) {
            this.eventCollector.clear();
        }
    }

    private static final class ManagerHandler
    extends Handler {
        private final InternalProximityManager manager;

        ManagerHandler(InternalProximityManager manager) {
            this.manager = manager;
        }

        public void handleMessage(Message msg) {
            switch (msg.what) {
                case 1: 
                case 2: {
                    this.manager.isScanning = msg.arg1 == 200;
                    break;
                }
                case 3: 
                case 6: {
                    this.manager.isScanning = false;
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unsupported response code: " + msg.what);
                }
            }
        }
    }
}

