/*
 * Decompiled with CFR 0.152.
 */
package com.kontakt.sdk.android.ble.manager;

import android.app.Notification;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import com.kontakt.sdk.android.ble.configuration.ScanContext;
import com.kontakt.sdk.android.ble.connection.OnServiceReadyListener;
import com.kontakt.sdk.android.ble.manager.EventObserver;
import com.kontakt.sdk.android.ble.manager.ProximityManager;
import com.kontakt.sdk.android.ble.manager.configuration.FiltersConfigurator;
import com.kontakt.sdk.android.ble.manager.configuration.GeneralConfigurator;
import com.kontakt.sdk.android.ble.manager.configuration.SpacesConfigurator;
import com.kontakt.sdk.android.ble.manager.internal.InternalProximityManager;
import com.kontakt.sdk.android.ble.manager.listeners.EddystoneListener;
import com.kontakt.sdk.android.ble.manager.listeners.IBeaconListener;
import com.kontakt.sdk.android.ble.manager.listeners.ScanStatusListener;
import com.kontakt.sdk.android.ble.manager.listeners.SecureProfileListener;
import com.kontakt.sdk.android.ble.manager.listeners.SpaceListener;
import com.kontakt.sdk.android.cloud.KontaktCloud;
import com.kontakt.sdk.android.cloud.KontaktCloudFactory;
import com.kontakt.sdk.android.common.log.Logger;
import com.kontakt.sdk.android.common.profile.DeviceProfile;
import com.kontakt.sdk.android.common.util.SDKPreconditions;

public class ProximityManagerImpl
implements ProximityManager {
    static final String BLE_SCAN_ERROR_OCCURRED_ACTION = "com.kontakt.sdk.action.BLE_SCAN_ERROR_OCCURRED";
    private final Context context;
    private IBeaconListener iBeaconListener;
    private EddystoneListener eddystoneListener;
    private SecureProfileListener secureProfileListener;
    private ScanStatusListener scanStatusListener;
    private SpaceListener spaceListener;
    private InternalProximityManager internalProximityManager;
    private ScanContext.Builder scanContext = new ScanContext.Builder();
    private final BroadcastReceiver bleScanErrorOccurredReceiver = new BroadcastReceiver(){

        public void onReceive(Context context, Intent intent) {
            ProximityManagerImpl.this.disconnect();
        }
    };

    ProximityManagerImpl(Context context) {
        this(context, KontaktCloudFactory.create());
    }

    ProximityManagerImpl(Context context, KontaktCloud kontaktCloud) {
        SDKPreconditions.checkNotNull(context, "Context can't be null").getApplicationContext();
        SDKPreconditions.checkNotNull(kontaktCloud, "Kontakt Cloud can't be null");
        this.context = context;
        this.internalProximityManager = new InternalProximityManager(context.getApplicationContext(), kontaktCloud);
    }

    @Override
    public void connect(OnServiceReadyListener onServiceReadyListener) {
        SDKPreconditions.checkNotNull(onServiceReadyListener, "OnServiceReadyListener can't be null.");
        if (!this.internalProximityManager.isConnected()) {
            this.internalProximityManager.connect(onServiceReadyListener);
            this.registerBleScanErrorOccurredReceiver();
        } else {
            onServiceReadyListener.onServiceReady();
            Logger.d("ProximityManager is already connected.");
        }
    }

    @Override
    public void disconnect() {
        this.internalProximityManager.disconnect();
        this.unregisterBleScanErrorOccurredReceiver();
    }

    @Override
    public void startScanning() {
        SDKPreconditions.checkArgument(this.internalProximityManager.isConnected(), "ProximityManager is not connected to ProximityService. Use ProximityManager.connect() before starting a scan.");
        if (!this.internalProximityManager.isScanning()) {
            this.checkObservedProfiles();
            this.internalProximityManager.initializeScan(this.scanContext.build(), this.createEventObserver());
        }
    }

    @Override
    public void restartScanning() {
        SDKPreconditions.checkArgument(this.internalProximityManager.isConnected(), "ProximityManager is not connected to ProximityService. Use ProximityManager.connect() before starting a scan.");
        if (this.internalProximityManager.isScanning()) {
            this.checkObservedProfiles();
            this.internalProximityManager.restartScan(this.scanContext.build(), this.createEventObserver());
        }
    }

    @Override
    public void stopScanning() {
        if (this.internalProximityManager.isScanning()) {
            this.internalProximityManager.finishScan();
        }
    }

    @Override
    public boolean isConnected() {
        return this.internalProximityManager.isConnected();
    }

    @Override
    public boolean isScanning() {
        return this.internalProximityManager.isScanning();
    }

    @Override
    public void setScanStatusListener(ScanStatusListener listener) {
        this.scanStatusListener = listener;
    }

    @Override
    public void setSpaceListener(SpaceListener listener) {
        this.spaceListener = listener;
    }

    @Override
    public void setIBeaconListener(IBeaconListener listener) {
        this.iBeaconListener = listener;
    }

    @Override
    public void setSecureProfileListener(SecureProfileListener listener) {
        this.secureProfileListener = listener;
    }

    @Override
    public void setEddystoneListener(EddystoneListener listener) {
        this.eddystoneListener = listener;
    }

    @Override
    public GeneralConfigurator configuration() {
        return this.scanContext;
    }

    @Override
    public SpacesConfigurator spaces() {
        return this.scanContext;
    }

    @Override
    public FiltersConfigurator filters() {
        return this.scanContext;
    }

    @Override
    public void setForegroundNotification(Notification notification, int notificationId) {
        this.internalProximityManager.setForegroundNotification(notification, notificationId);
    }

    @Override
    public void clearForegroundNotification() {
        this.internalProximityManager.setForegroundNotification(null, -1);
    }

    private void checkObservedProfiles() {
        if (this.iBeaconListener == null) {
            this.scanContext.removeObservedProfile(DeviceProfile.IBEACON);
        } else {
            this.scanContext.addObservedProfile(DeviceProfile.IBEACON);
        }
        if (this.eddystoneListener == null) {
            this.scanContext.removeObservedProfile(DeviceProfile.EDDYSTONE);
        } else {
            this.scanContext.addObservedProfile(DeviceProfile.EDDYSTONE);
        }
        if (this.secureProfileListener == null) {
            this.scanContext.removeObservedProfile(DeviceProfile.KONTAKT_SECURE);
        } else {
            this.scanContext.addObservedProfile(DeviceProfile.KONTAKT_SECURE);
        }
    }

    private EventObserver createEventObserver() {
        return new EventObserver(this.context, this.eddystoneListener, this.iBeaconListener, this.scanStatusListener, this.spaceListener, this.secureProfileListener);
    }

    private void registerBleScanErrorOccurredReceiver() {
        IntentFilter intentFilter = new IntentFilter();
        intentFilter.addAction(BLE_SCAN_ERROR_OCCURRED_ACTION);
        this.context.registerReceiver(this.bleScanErrorOccurredReceiver, intentFilter);
    }

    private void unregisterBleScanErrorOccurredReceiver() {
        try {
            this.context.unregisterReceiver(this.bleScanErrorOccurredReceiver);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }
}

