/*
 * Decompiled with CFR 0.152.
 */
package com.kontakt.sdk.android.ble.discovery.secure_profile;

import com.kontakt.sdk.android.ble.discovery.PropertyResolver;
import com.kontakt.sdk.android.ble.spec.Acceleration;
import com.kontakt.sdk.android.ble.spec.DeviceDataLoggerStatus;
import com.kontakt.sdk.android.ble.spec.KontaktTelemetry;
import com.kontakt.sdk.android.ble.spec.TelemetryError;
import com.kontakt.sdk.android.common.util.ConversionUtils;

final class KontaktTLMResolver
implements PropertyResolver<KontaktTelemetry> {
    private static final byte BASIC_SYSTEM_HEALTH_IDENTIFIER = 1;
    private static final byte ACCELEROMETER_IDENTIFIER = 2;
    private static final byte SCANNING_IDENTIFIER = 3;
    private static final byte MORE_SYSTEM_HEALTH_IDENTIFIER = 4;
    private static final byte SENSORS_IDENTIFIER = 5;
    private static final byte RAW_ACCELEROMETER_IDENTIFIER = 6;
    private static final byte MOVEMENT_THRESHOLD_EVENT_IDENTIFIER = 7;
    private static final byte DOUBLE_TAP_IDENTIFIER = 8;
    private static final byte TAP_EVENT_IDENTIFIER = 9;
    private static final byte LIGHT_LEVEL_IDENTIFIER = 10;
    private static final byte TEMPERATURE_IDENTIFIER = 11;
    private static final byte BATTERY_IDENTIFIER = 12;
    private static final byte BUTTON_CLICK_IDENTIFIER = 13;
    private static final byte BUTTON_DOUBLE_CLICK_IDENTIFIER = 14;
    private static final byte UTC_TIME_IDENTIFIER = 15;
    private static final byte LOGGING_ENABLED_IDENTIFIER = 16;
    private static final byte IDENTIFIED_BUTTON_CLICK_IDENTIFIER = 17;
    private static final byte HUMIDITY_IDENTIFIER = 18;
    private static final byte TEMPERATURE_16_BIT_IDENTIFIER = 19;
    private static final byte BLE_CHANNEL_IDENTIFIER = 20;
    private static final byte GPIO_PIN_STATE = 21;
    private static final byte MOVEMENT_EVENT_IDENTIFIER = 22;
    private static final byte AIR_PRESSURE_IDENTIFIER = 23;
    private static final byte PIR_IDENTIFIER = 24;
    private static final byte TWO_BUTTON_INFO_IDENTIFIER = 25;
    private static final byte VENDOR_SPECIFIC_PAYLOAD_IDENTIFIER = -1;
    private static final byte AIR_QUALITY_IDENTIFIER = 26;
    private static final byte ROOM_NUMBER_IDENTIFIER = 27;
    private static final byte OCCUPANCY_IDENTIFIER = 28;
    private static final int BASIC_SYSTEM_HEALTH_FIELD_LENGTH = 6;
    private static final int ACCELEROMETER_FIELD_LENGTH = 9;
    private static final int SCANNING_FIELD_LENGTH = 5;
    private static final int MORE_SYSTEM_HEALTH_FIELD_LENGTH = 10;
    private static final int SENSORS_FIELD_LENGTH = 3;
    private static final int RAW_ACCELEROMETER_LENGTH = 5;
    private static final int MOVEMENT_THRESHOLD_EVENT_LENGTH = 3;
    private static final int DOUBLE_TAP_EVENT_LENGTH = 3;
    private static final int TAP_EVENT_LENGTH = 3;
    private static final int LIGHT_LEVEL_FIELD_LENGTH = 2;
    private static final int TEMPERATURE_FIELD_LENGTH = 2;
    private static final int BATTERY_FIELD_LENGTH = 2;
    private static final int BUTTON_CLICK_FIELD_LENGTH = 3;
    private static final int BUTTON_DOUBLE_CLICK_FIELD_LENGTH = 3;
    private static final int UTC_TIME_FIELD_LENGTH = 5;
    private static final int LOGGING_ENABLED_FIELD_LENGTH = 2;
    private static final int IDENTIFIED_BUTTON_CLICK_FIELD_LENGTH = 4;
    private static final int HUMIDITY_FIELD_LENGTH = 2;
    private static final int TEMPERATURE_16_BIT_FIELD_LENGTH = 3;
    private static final int BLE_CHANNEL_FIELD_LENGTH = 2;
    private static final int GPIO_PIN_STATE_FIELD_LENGTH = 3;
    private static final int MOVEMENT_EVENT_FIELD_LENGTH = 4;
    private static final int AIR_PRESSURE_FIELD_LENGTH = 5;
    private static final int PIR_DETECTION_FIELD_LENGTH = 3;
    private static final int TWO_BUTTON_INFO_FIELD_LENGTH = 5;
    private static final int AIR_QUALITY_FIELD_LENGTH = 2;
    private static final int ROOM_NUMBER_FIELD_LENGTH = 3;
    private static final int OCCUPANCY_FIELD_LENGTH = 4;
    private static final int FIELDS_PAYLOAD_OFFSET = 3;
    private static final int VENDOR_SPECIFIC_PAYLOAD_OFFSET = 3;

    KontaktTLMResolver() {
    }

    @Override
    public KontaktTelemetry parse(byte[] packet) {
        if (packet == null || packet.length == 0) {
            return null;
        }
        KontaktTelemetry.Builder builder = new KontaktTelemetry.Builder();
        byte[] fieldsData = ConversionUtils.extractSubdata(packet, 3, packet.length - 3);
        this.iterateOverFields(builder, fieldsData);
        return builder.build();
    }

    private void iterateOverFields(KontaktTelemetry.Builder builder, byte[] fieldsData) {
        int fieldLength;
        byte[] field;
        while (fieldsData != null && fieldsData.length > 0 && (field = ConversionUtils.extractSubdata(fieldsData, 1, fieldLength = ConversionUtils.asInt(fieldsData[0]))) != null) {
            byte identifier = field[0];
            this.resolve(identifier, builder, field);
            fieldsData = ConversionUtils.extractSubdata(fieldsData, field.length + 1, fieldsData.length - (field.length + 1));
        }
    }

    private void resolve(byte identifier, KontaktTelemetry.Builder builder, byte[] field) {
        this.resolveBasicSystemHealth(identifier, builder, field);
        this.resolveAccelerometerData(identifier, builder, field);
        this.resolveScanningData(identifier, builder, field);
        this.resolveMoreSystemHealth(identifier, builder, field);
        this.resolveSensors(identifier, builder, field);
        this.resolveRawAccelerometer(identifier, builder, field);
        this.resolveMovementThresholdEvent(identifier, builder, field);
        this.resolveDoubleTapEvent(identifier, builder, field);
        this.resolveTapEvent(identifier, builder, field);
        this.resolveLightLevel(identifier, builder, field);
        this.resolveTemperature(identifier, builder, field);
        this.resolveBattery(identifier, builder, field);
        this.resolveButtonClick(identifier, builder, field);
        this.resolveDoubleClickEvent(identifier, builder, field);
        this.resolverUtcTime(identifier, builder, field);
        this.resolveDataLoggerStatus(identifier, builder, field);
        this.resolveIdentifiedButtonClick(identifier, builder, field);
        this.resolveHumidity(identifier, builder, field);
        this.resolveTemperature16Bit(identifier, builder, field);
        this.resolveBleChannel(identifier, builder, field);
        this.resolveGpioPinState(identifier, builder, field);
        this.resolveMovementEvent(identifier, builder, field);
        this.resolveAirPressure(identifier, builder, field);
        this.resolvePIRDetection(identifier, builder, field);
        this.resolveTwoClick(identifier, builder, field);
        this.resolveAirQuality(identifier, builder, field);
        this.resolveRoomNumber(identifier, builder, field);
        this.resolveOccupancy(identifier, builder, field);
        this.resolveVendorSpecificPayload(identifier, builder, field);
    }

    private void resolveTapEvent(int identifier, KontaktTelemetry.Builder builder, byte[] field) {
        if (identifier == 9 && field.length >= 3) {
            int tapSeconds = ConversionUtils.asIntFromLittleEndianBytes(ConversionUtils.extractSubdata(field, 1, 2));
            builder.lastTap(tapSeconds);
        }
    }

    private void resolveDoubleTapEvent(int identifier, KontaktTelemetry.Builder builder, byte[] field) {
        if (identifier == 8 && field.length >= 3) {
            int doubleTapSeconds = ConversionUtils.asIntFromLittleEndianBytes(ConversionUtils.extractSubdata(field, 1, 2));
            builder.lastDoubleTap(doubleTapSeconds);
        }
    }

    private void resolveMovementThresholdEvent(int identifier, KontaktTelemetry.Builder builder, byte[] field) {
        if (identifier == 7 && field.length >= 3) {
            int movementSecondsThreshold = ConversionUtils.asIntFromLittleEndianBytes(ConversionUtils.extractSubdata(field, 1, 2));
            builder.lastThreshold(movementSecondsThreshold);
        }
    }

    private void resolveRawAccelerometer(int identifier, KontaktTelemetry.Builder builder, byte[] field) {
        if (identifier == 6 && field.length >= 5) {
            int rawSensitivity = ConversionUtils.asInt(field[1]);
            builder.sensitivity(rawSensitivity);
            Acceleration rawAcceleration = new Acceleration(ConversionUtils.extractSubdata(field, 2, 3));
            builder.acceleration(rawAcceleration);
        }
    }

    private void resolveBasicSystemHealth(int identifier, KontaktTelemetry.Builder builder, byte[] field) {
        if (identifier == 1 && field.length >= 6) {
            int timestamp = ConversionUtils.asIntFromLittleEndianBytes(ConversionUtils.extractSubdata(field, 1, 4));
            builder.timestamp(timestamp);
            int batteryLevel = ConversionUtils.asInt(field[5]);
            builder.batteryLevel(batteryLevel);
        }
    }

    private void resolveAccelerometerData(int identifier, KontaktTelemetry.Builder builder, byte[] field) {
        if (identifier == 2 && field.length >= 9) {
            int sensitivity = ConversionUtils.asInt(field[1]);
            builder.sensitivity(sensitivity);
            Acceleration acceleration = new Acceleration(ConversionUtils.extractSubdata(field, 2, 3));
            builder.acceleration(acceleration);
            int lastDoubleTap = ConversionUtils.asIntFromLittleEndianBytes(ConversionUtils.extractSubdata(field, 5, 2));
            builder.lastDoubleTap(lastDoubleTap);
            int lastThreshold = ConversionUtils.asIntFromLittleEndianBytes(ConversionUtils.extractSubdata(field, 7, 2));
            builder.lastThreshold(lastThreshold);
        }
    }

    private void resolveScanningData(int identifier, KontaktTelemetry.Builder builder, byte[] field) {
        if (identifier == 3 && field.length >= 5) {
            int bleScans = ConversionUtils.asInt(field[1]);
            builder.bleScans(bleScans);
            int wifiScans = ConversionUtils.asInt(field[2]);
            builder.wifiScans(wifiScans);
            int bleDevices = ConversionUtils.asIntFromLittleEndianBytes(ConversionUtils.extractSubdata(field, 3, 2));
            builder.bleDevices(bleDevices);
        }
    }

    private void resolveMoreSystemHealth(int identifier, KontaktTelemetry.Builder builder, byte[] field) {
        if (identifier == 4 && field.length >= 10) {
            int timestamp = ConversionUtils.asIntFromLittleEndianBytes(ConversionUtils.extractSubdata(field, 1, 4));
            builder.timestamp(timestamp);
            int uptime = ConversionUtils.asIntFromLittleEndianBytes(ConversionUtils.extractSubdata(field, 5, 2));
            builder.uptime(uptime);
            int systemLoad = ConversionUtils.asInt(field[7]);
            builder.systemLoad(systemLoad);
            byte[] bytes = ConversionUtils.extractSubdata(field, 8, 2);
            TelemetryError error = TelemetryError.fromValueBytes(bytes);
            builder.error(error);
        }
    }

    private void resolveSensors(int identifier, KontaktTelemetry.Builder builder, byte[] field) {
        if (identifier == 5 && field.length >= 3) {
            int lightSensor = ConversionUtils.asInt(field[1]);
            builder.lightSensor(lightSensor);
            byte temperature = field[2];
            builder.temperature(temperature);
        }
    }

    private void resolveLightLevel(int identifier, KontaktTelemetry.Builder builder, byte[] field) {
        if (identifier == 10 && field.length >= 2) {
            int light = ConversionUtils.asInt(field[1]);
            builder.lightSensor(light);
        }
    }

    private void resolveTemperature(int identifier, KontaktTelemetry.Builder builder, byte[] field) {
        if (identifier == 11 && field.length >= 2) {
            int temperature = ConversionUtils.asInt(field[1]);
            builder.temperature(temperature);
        }
    }

    private void resolveBattery(int identifier, KontaktTelemetry.Builder builder, byte[] field) {
        if (identifier == 12 && field.length >= 2) {
            int battery = ConversionUtils.asInt(field[1]);
            builder.batteryLevel(battery);
        }
    }

    private void resolveButtonClick(int identifier, KontaktTelemetry.Builder builder, byte[] field) {
        if (identifier == 13 && field.length >= 3) {
            int lastSingleClickSeconds = ConversionUtils.asIntFromLittleEndianBytes(ConversionUtils.extractSubdata(field, 1, 2));
            builder.lastSingleClick(lastSingleClickSeconds < 65535 ? lastSingleClickSeconds : -1);
        }
    }

    private void resolveDoubleClickEvent(int identifier, KontaktTelemetry.Builder builder, byte[] field) {
        if (identifier == 14 && field.length >= 3) {
            int lastDoubleClickSeconds = ConversionUtils.asIntFromLittleEndianBytes(ConversionUtils.extractSubdata(field, 1, 2));
            builder.lastDoubleClick(lastDoubleClickSeconds);
        }
    }

    private void resolverUtcTime(int identifier, KontaktTelemetry.Builder builder, byte[] field) {
        if (identifier == 15 && field.length >= 5) {
            int utcTime = ConversionUtils.asIntFromLittleEndianBytes(ConversionUtils.extractSubdata(field, 1, 4));
            builder.timestamp(utcTime);
        }
    }

    private void resolveDataLoggerStatus(int identifier, KontaktTelemetry.Builder builder, byte[] field) {
        if (identifier == 16 && field.length >= 2) {
            int loggingStatus = ConversionUtils.asInt(field[1]);
            builder.dataLoggerStatus(loggingStatus == 1 ? DeviceDataLoggerStatus.ENABLED : DeviceDataLoggerStatus.DISABLED);
        }
    }

    private void resolveIdentifiedButtonClick(int identifier, KontaktTelemetry.Builder builder, byte[] field) {
        if (identifier == 17 && field.length >= 4) {
            int clickId = ConversionUtils.asInt(field[1]);
            builder.singleClickCount(clickId);
            int singleClick = ConversionUtils.asIntFromLittleEndianBytes(ConversionUtils.extractSubdata(field, 2, 2));
            builder.lastSingleClick(singleClick < 65535 ? singleClick : -1);
        }
    }

    private void resolveHumidity(int identifier, KontaktTelemetry.Builder builder, byte[] field) {
        if (identifier == 18 && field.length >= 2) {
            int humidity = ConversionUtils.asInt(field[1]);
            builder.humidity(humidity);
        }
    }

    private void resolveTemperature16Bit(int identifier, KontaktTelemetry.Builder builder, byte[] field) {
        if (identifier == 19 && field.length >= 3) {
            int temperature = ConversionUtils.asIntFromLittleEndianBytes(ConversionUtils.extractSubdata(field, 1, 2));
            builder.temperature((float)temperature / 256.0f);
        }
    }

    private void resolveBleChannel(int identifier, KontaktTelemetry.Builder builder, byte[] field) {
        if (identifier == 20 && field.length >= 2) {
            int bleChannel = ConversionUtils.asInt(field[1]);
            builder.bleChannel(bleChannel);
        }
    }

    private void resolveGpioPinState(int identifier, KontaktTelemetry.Builder builder, byte[] field) {
        if (identifier == 21 && field.length >= 3) {
            byte definedGpioMask = field[1];
            builder.definedGpioMask(definedGpioMask);
            byte stateGpioMask = field[2];
            builder.stateGpioMask(stateGpioMask);
        }
    }

    private void resolveMovementEvent(int identifier, KontaktTelemetry.Builder builder, byte[] field) {
        if (identifier == 22 && field.length >= 4) {
            int currentMovementId = ConversionUtils.asInt(field[1]);
            builder.currentMovementId(currentMovementId);
            int threshold = ConversionUtils.asIntFromLittleEndianBytes(ConversionUtils.extractSubdata(field, 2, 2));
            builder.lastThreshold(threshold);
        }
    }

    private void resolveAirPressure(int identifier, KontaktTelemetry.Builder builder, byte[] field) {
        if (identifier == 23 && field.length >= 5) {
            byte[] bytes = ConversionUtils.extractSubdata(field, 1, 4);
            assert (bytes != null);
            float pressure = ConversionUtils.asFloatFromLittleEndianBytes(bytes);
            builder.airPressure(pressure);
        }
    }

    private void resolvePIRDetection(int identifier, KontaktTelemetry.Builder builder, byte[] field) {
        if (identifier == 24 && field.length >= 3) {
            int pirDetectionSeconds = ConversionUtils.asIntFromLittleEndianBytes(ConversionUtils.extractSubdata(field, 1, 2));
            builder.pirDetectionSeconds(pirDetectionSeconds < 65535 ? pirDetectionSeconds : -1);
        }
    }

    private void resolveTwoClick(int identifier, KontaktTelemetry.Builder builder, byte[] field) {
        if (identifier == 25 && field.length >= 5) {
            int twoClickId1 = ConversionUtils.asInt(field[1]);
            int twoClickId2 = ConversionUtils.asInt(field[2]);
            int twoClickSeconds = ConversionUtils.asIntFromLittleEndianBytes(ConversionUtils.extractSubdata(field, 3, 2));
            builder.singleClickCount(twoClickId1);
            builder.singleClickCount2(twoClickId2);
            builder.lastSingleClick(twoClickSeconds);
        }
    }

    private void resolveAirQuality(int identifier, KontaktTelemetry.Builder builder, byte[] field) {
        if (identifier == 26 && field.length >= 2) {
            int airQuality = ConversionUtils.asInt(field[1]);
            builder.airQuality(airQuality);
        }
    }

    private void resolveRoomNumber(int identifier, KontaktTelemetry.Builder builder, byte[] field) {
        if (identifier == 27 && field.length >= 3) {
            int roomNumber = ConversionUtils.asIntFromLittleEndianBytes(ConversionUtils.extractSubdata(field, 1, 2));
            builder.roomNumber(roomNumber);
        }
    }

    private void resolveOccupancy(int identifier, KontaktTelemetry.Builder builder, byte[] field) {
        if (identifier == 28 && field.length >= 4) {
            int occupancy = ConversionUtils.asInt(field[1]);
            int occupancyDetectionTime = ConversionUtils.asIntFromLittleEndianBytes(ConversionUtils.extractSubdata(field, 2, 2));
            builder.occupancy(occupancy < 255 ? occupancy : -1);
            builder.occupancyDetectionTime(occupancyDetectionTime < 65535 ? occupancyDetectionTime : -1);
        }
    }

    private void resolveVendorSpecificPayload(int identifier, KontaktTelemetry.Builder builder, byte[] field) {
        if (identifier != -1) {
            return;
        }
        byte[] fieldsData = ConversionUtils.extractSubdata(field, 3, field.length - 3);
        builder.manufacturerId(ConversionUtils.asIntFromLittleEndianBytes(ConversionUtils.extractSubdata(field, 1, 2)));
        this.iterateOverFields(builder, fieldsData);
    }
}

