/*
 * Decompiled with CFR 0.152.
 */
package com.kontakt.sdk.android.ble.dfu;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

class Transaction {
    static final int DEFAULT_SIZE = 2048;
    static final int BYTES_CHUNK_LENGTH = 20;
    private final byte[] fileBytes;
    private final int size;
    private final int storedBytesCount;

    public Transaction(byte[] fileBytes, int storedBytesCount) {
        this.fileBytes = fileBytes;
        this.storedBytesCount = storedBytesCount;
        this.size = this.calculateTransactionLength(fileBytes, storedBytesCount);
    }

    public int getSize() {
        return this.size;
    }

    public List<byte[]> getChunksToSend() {
        ArrayList<byte[]> chunksToSend = new ArrayList<byte[]>();
        int index = this.storedBytesCount;
        int count = (int)Math.floor((double)this.size / 20.0);
        int rest = this.size % 20;
        for (int i = 0; i < count; ++i) {
            chunksToSend.add(Arrays.copyOfRange(this.fileBytes, index, index + 20));
            index += 20;
        }
        if (rest != 0) {
            index = this.storedBytesCount + count * 20;
            chunksToSend.add(Arrays.copyOfRange(this.fileBytes, index, index + rest));
        }
        return chunksToSend;
    }

    private int calculateTransactionLength(byte[] fileBytes, int storedSize) {
        if (storedSize == 0) {
            return 2048;
        }
        int length = fileBytes.length - storedSize;
        return length >= 2048 ? 2048 : length;
    }
}

