/*
 * Decompiled with CFR 0.152.
 */
package com.kontakt.sdk.android.ble.device;

import android.os.Bundle;
import android.os.Parcel;
import android.os.Parcelable;
import com.kontakt.sdk.android.common.profile.IEddystoneNamespace;
import com.kontakt.sdk.android.common.util.SDKPreconditions;

public class EddystoneNamespace
implements IEddystoneNamespace {
    public static final String ANY_INSTANCE_ID = "Any instance ID";
    public static EddystoneNamespace EVERYWHERE = new Builder().identifier("Everywhere").namespace("f7826da6bc5b71e0893e").secureNamespace(null).instanceId("Any instance ID").build();
    public static final Parcelable.Creator<EddystoneNamespace> CREATOR = new Parcelable.Creator<EddystoneNamespace>(){

        public EddystoneNamespace createFromParcel(Parcel source) {
            Bundle bundle = source.readBundle(this.getClass().getClassLoader());
            return new Builder().identifier(bundle.getString("identifier")).namespace(bundle.getString("namespace")).secureNamespace(bundle.getString("secure_namespace")).instanceId(bundle.getString("instanceId")).build();
        }

        public EddystoneNamespace[] newArray(int size) {
            return new EddystoneNamespace[size];
        }
    };
    private final String identifier;
    private final String namespace;
    private final String secureNamespace;
    private final String instanceId;

    public static Builder builder() {
        return new Builder();
    }

    EddystoneNamespace(Builder builder) {
        SDKPreconditions.checkNotNull(builder.identifier, "Identifier cannot be null");
        SDKPreconditions.checkArgument(builder.namespace != null || builder.secureNamespace != null, "You must set either Namespace or SecureNamespace.");
        this.identifier = builder.identifier;
        this.namespace = builder.namespace;
        this.secureNamespace = builder.secureNamespace;
        this.instanceId = builder.instanceId;
    }

    @Override
    public String getIdentifier() {
        return this.identifier;
    }

    @Override
    public String getNamespace() {
        return this.namespace;
    }

    @Override
    public String getSecureNamespace() {
        return this.secureNamespace;
    }

    @Override
    public String getInstanceId() {
        return this.instanceId;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        EddystoneNamespace that = (EddystoneNamespace)o;
        if (!this.identifier.equals(that.identifier)) {
            return false;
        }
        if (this.namespace != null ? !this.namespace.equals(that.namespace) : that.namespace != null) {
            return false;
        }
        if (this.secureNamespace != null ? !this.secureNamespace.equals(that.secureNamespace) : that.secureNamespace != null) {
            return false;
        }
        return this.instanceId != null ? this.instanceId.equals(that.instanceId) : that.instanceId == null;
    }

    public int hashCode() {
        int result = this.identifier.hashCode();
        result = 31 * result + (this.namespace != null ? this.namespace.hashCode() : 0);
        result = 31 * result + (this.secureNamespace != null ? this.secureNamespace.hashCode() : 0);
        result = 31 * result + (this.instanceId != null ? this.instanceId.hashCode() : 0);
        return result;
    }

    public String toString() {
        StringBuilder namespaceDesc = new StringBuilder();
        namespaceDesc.append("[");
        if (this.namespace != null) {
            namespaceDesc.append(this.namespace);
        } else if (this.secureNamespace != null) {
            namespaceDesc.append(this.secureNamespace);
        }
        namespaceDesc.append(", ");
        if (ANY_INSTANCE_ID.equals(this.instanceId)) {
            namespaceDesc.append("ANY_INSTANCE_ID");
        } else {
            namespaceDesc.append(this.instanceId);
        }
        namespaceDesc.append("]");
        return namespaceDesc.toString();
    }

    @Override
    public int compareTo(IEddystoneNamespace another) {
        if (this == another) {
            return 0;
        }
        return this.identifier.compareTo(another.getIdentifier());
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel parcel, int flags) {
        Bundle bundle = new Bundle(this.getClass().getClassLoader());
        bundle.putString("identifier", this.identifier);
        bundle.putString("namespace", this.namespace);
        bundle.putString("secure_namespace", this.secureNamespace);
        bundle.putString("instanceId", this.instanceId);
        parcel.writeBundle(bundle);
    }

    public static class Builder {
        String identifier;
        String namespace;
        String secureNamespace;
        String instanceId = "Any instance ID";

        public Builder identifier(String identifier) {
            this.identifier = identifier;
            return this;
        }

        public Builder namespace(String namespace) {
            this.namespace = namespace;
            return this;
        }

        public Builder secureNamespace(String secureNamespace) {
            this.secureNamespace = secureNamespace;
            return this;
        }

        public Builder instanceId(String instanceId) {
            this.instanceId = instanceId;
            return this;
        }

        public EddystoneNamespace build() {
            return new EddystoneNamespace(this);
        }
    }
}

