/*
 * Decompiled with CFR 0.152.
 */
package com.kontakt.sdk.android.ble.connection;

import android.annotation.TargetApi;
import android.bluetooth.BluetoothDevice;
import android.bluetooth.BluetoothGatt;
import android.bluetooth.BluetoothGattCallback;
import android.bluetooth.BluetoothGattCharacteristic;
import android.bluetooth.BluetoothGattDescriptor;
import android.content.Context;
import android.os.Handler;
import android.os.RemoteException;
import android.util.Base64;
import com.kontakt.sdk.android.ble.connection.DeviceConnectionError;
import com.kontakt.sdk.android.ble.connection.GattController;
import com.kontakt.sdk.android.ble.connection.KontaktDeviceConnectionImpl;
import com.kontakt.sdk.android.ble.connection.KontaktDeviceServiceStore;
import com.kontakt.sdk.android.ble.connection.WriteListener;
import com.kontakt.sdk.android.ble.exception.ServiceAbsentException;
import com.kontakt.sdk.android.ble.spec.BluetoothDeviceCharacteristic;
import com.kontakt.sdk.android.ble.spec.KontaktDeviceCharacteristic;
import com.kontakt.sdk.android.ble.spec.KontaktDeviceService;
import com.kontakt.sdk.android.ble.util.BluetoothUtils;
import com.kontakt.sdk.android.common.TimestampUtil;
import com.kontakt.sdk.android.common.log.Logger;
import com.kontakt.sdk.android.common.profile.RemoteBluetoothDevice;
import com.kontakt.sdk.android.common.util.ConversionUtils;
import java.io.Closeable;
import java.util.ArrayDeque;
import java.util.Collection;
import java.util.Queue;
import java.util.concurrent.TimeUnit;

@TargetApi(value=18)
final class SecureGattController
extends BluetoothGattCallback
implements Closeable,
GattController {
    KontaktDeviceConnectionImpl connection;
    private BluetoothGatt gattServer;
    private KontaktDeviceServiceStore secureKontaktDeviceStore;
    private Context context;
    private Handler controlPointHandler;
    private Handler readCharacteristicHandler;
    private Queue<BluetoothDeviceCharacteristic> preAuthCharacteristicsQueue;
    private BluetoothDevice bluetoothDevice;
    private boolean readResponse;
    private boolean shouldInitializeCharacteristics = true;
    private Runnable controlPointRunnable = new Runnable(){

        @Override
        public void run() {
            try {
                BluetoothDeviceCharacteristic controlPointCharacteristic = SecureGattController.this.secureKontaktDeviceStore.getSecureControlPointCharacteristic();
                SecureGattController.this.gattServer.readCharacteristic((BluetoothGattCharacteristic)controlPointCharacteristic);
            }
            catch (Exception e) {
                Logger.e("controlPointRunnable", e);
            }
        }
    };
    private Runnable characteristicReadRunnable = new Runnable(){

        @Override
        public void run() {
            if (SecureGattController.this.connection == null) {
                return;
            }
            if (SecureGattController.this.connection.getState() == KontaktDeviceConnectionImpl.State.AUTHENTICATING) {
                SecureGattController.this.connection.onConnectionStateChange(KontaktDeviceConnectionImpl.State.CHARACTERISTICS_REQUESTING);
                SecureGattController.this.requestCharacteristics();
            }
        }
    };

    SecureGattController(KontaktDeviceConnectionImpl connection, Context context, RemoteBluetoothDevice device) throws RemoteException {
        this.connection = connection;
        this.context = context;
        this.controlPointHandler = new Handler();
        this.readCharacteristicHandler = new Handler();
        BluetoothDevice bluetoothDevice = BluetoothUtils.getBluetoothDevice(device.getAddress());
        if (bluetoothDevice == null) {
            throw new RemoteException("Bluetooth device is null");
        }
        this.bluetoothDevice = bluetoothDevice;
    }

    SecureGattController(KontaktDeviceConnectionImpl connection, Context context, RemoteBluetoothDevice device, boolean shouldInitializeCharacteristics) throws RemoteException {
        this(connection, context, device);
        this.shouldInitializeCharacteristics = shouldInitializeCharacteristics;
    }

    @Override
    public boolean connect() {
        this.gattServer = this.bluetoothDevice.connectGatt(this.context, false, (BluetoothGattCallback)this);
        return this.gattServer != null;
    }

    @Override
    public void disconnect() {
        if (this.gattServer != null) {
            this.refresh();
            this.gattServer.disconnect();
        }
    }

    @Override
    public boolean writeCharacteristic(BluetoothGattCharacteristic characteristic) {
        return this.writeCharacteristic(characteristic, true);
    }

    @Override
    public boolean writeCharacteristic(BluetoothGattCharacteristic characteristic, boolean readResponse) {
        this.readResponse = readResponse;
        return this.gattServer.writeCharacteristic(characteristic);
    }

    @Override
    public boolean readCharacteristic(BluetoothGattCharacteristic characteristic) {
        return this.gattServer.readCharacteristic(characteristic);
    }

    @Override
    public boolean writeDescriptor(BluetoothGattDescriptor descriptor) {
        return this.gattServer.writeDescriptor(descriptor);
    }

    @Override
    public boolean setCharacteristicNotification(BluetoothGattCharacteristic characteristic, boolean enable) {
        return this.gattServer.setCharacteristicNotification(characteristic, enable);
    }

    @Override
    public void refresh() {
        BluetoothUtils.refreshGattServer(this.gattServer);
    }

    @Override
    public void close() {
        if (this.gattServer != null) {
            this.disconnect();
            this.gattServer.close();
        }
        if (this.secureKontaktDeviceStore != null) {
            this.secureKontaktDeviceStore.clear();
        }
        if (this.preAuthCharacteristicsQueue != null) {
            this.preAuthCharacteristicsQueue.clear();
        }
        this.connection = null;
        this.controlPointHandler.removeCallbacksAndMessages((Object)this.controlPointRunnable);
        this.readCharacteristicHandler.removeCallbacks(this.characteristicReadRunnable);
    }

    public void onConnectionStateChange(BluetoothGatt gatt, int status, int newState) {
        switch (newState) {
            case 2: {
                if (0 == status) {
                    this.connection.onConnectionStateChange(KontaktDeviceConnectionImpl.State.CONNECTED);
                    this.connection.onConnectionOpened();
                    if (this.gattServer.discoverServices()) break;
                    this.connection.onError(1);
                    break;
                }
                this.connection.onError(DeviceConnectionError.toGattError(status));
                break;
            }
            case 0: {
                if (this.connection == null) break;
                if (0 != status) {
                    this.connection.onError(DeviceConnectionError.toGattError(status));
                }
                if (this.connection != null) {
                    this.connection.onConnectionStateChange(KontaktDeviceConnectionImpl.State.DISCONNECTED);
                }
                if (this.connection == null) break;
                this.connection.onDisconnected();
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported connection state change code: " + newState);
            }
        }
    }

    public void onServicesDiscovered(BluetoothGatt gatt, int status) {
        Logger.d(String.format("On Services Discovered: %s ", gatt.toString()));
        if (status != 0) {
            Logger.d("Services discovered but with no success: " + status);
            return;
        }
        try {
            this.secureKontaktDeviceStore = new KontaktDeviceServiceStore(gatt.getServices());
            this.connection.onServicesDiscovered(this.secureKontaktDeviceStore);
            if (this.secureKontaktDeviceStore.contains(KontaktDeviceService.DFU_SERVICE)) {
                this.connection.onDfuModeEnabled();
            } else {
                this.onServicesDiscoveredNoDFU();
            }
        }
        catch (RemoteException e) {
            this.connection.onError(2);
        }
    }

    private void onServicesDiscoveredNoDFU() {
        if (this.shouldInitializeCharacteristics) {
            this.connection.onConnectionStateChange(KontaktDeviceConnectionImpl.State.AUTHENTICATING);
            this.readCharacteristicHandler.postDelayed(this.characteristicReadRunnable, TimeUnit.SECONDS.toMillis(1L));
        } else {
            this.onAfterCharacteristicAuthenticationPhase();
        }
    }

    private void onAfterCharacteristicAuthenticationPhase() {
        this.connection.onConnectionStateChange(KontaktDeviceConnectionImpl.State.AUTHENTICATED);
        this.connection.onAuthenticationSuccess();
    }

    public void onCharacteristicRead(BluetoothGatt gatt, BluetoothGattCharacteristic characteristic, int status) {
        if (0 == status) {
            if (this.connection.getState() == KontaktDeviceConnectionImpl.State.CHARACTERISTICS_REQUESTING) {
                this.requestOrSetAuthenticated();
                return;
            }
            if (this.connection.getState() == KontaktDeviceConnectionImpl.State.AUTHENTICATED) {
                BluetoothDeviceCharacteristic wrapper = new BluetoothDeviceCharacteristic(characteristic);
                KontaktDeviceCharacteristic kontaktCharacteristic = wrapper.getKontaktDeviceCharacteristic();
                if (KontaktDeviceCharacteristic.SECURE_CONTROL_POINT == kontaktCharacteristic) {
                    this.checkControlPointValue(wrapper);
                } else if (KontaktDeviceCharacteristic.SECURE_RESPONSE == kontaktCharacteristic) {
                    this.checkResponse(wrapper);
                } else {
                    this.connection.onCharacteristicRead(wrapper);
                }
            }
        } else if (2 == status && this.connection.getState() == KontaktDeviceConnectionImpl.State.CHARACTERISTICS_REQUESTING) {
            this.requestOrSetAuthenticated();
        }
    }

    public void onCharacteristicWrite(BluetoothGatt gatt, BluetoothGattCharacteristic characteristic, int status) {
        if (this.connection.isConnected() && !characteristic.getUuid().toString().equals(KontaktDeviceCharacteristic.KDFU_DATA.getId())) {
            try {
                this.secureKontaktDeviceStore.replace(new BluetoothDeviceCharacteristic(characteristic));
            }
            catch (ServiceAbsentException e) {
                Logger.e(e.getMessage());
            }
            if (0 == status) {
                BluetoothDeviceCharacteristic bluetoothDeviceCharacteristic = new BluetoothDeviceCharacteristic(characteristic);
                KontaktDeviceCharacteristic kontaktDeviceCharacteristic = bluetoothDeviceCharacteristic.getKontaktDeviceCharacteristic();
                if (KontaktDeviceCharacteristic.SECURE_WRITE == kontaktDeviceCharacteristic) {
                    this.onSecureWriteCharacteristicWritten();
                } else if (KontaktDeviceCharacteristic.CURRENT_TIME == kontaktDeviceCharacteristic || KontaktDeviceCharacteristic.GATEWAY_NETWORKS_INDEX == kontaktDeviceCharacteristic) {
                    this.onCharacteristicWritten();
                }
            }
        }
    }

    public void onCharacteristicChanged(BluetoothGatt gatt, BluetoothGattCharacteristic characteristic) {
        if (this.connection != null) {
            BluetoothDeviceCharacteristic wrapper = new BluetoothDeviceCharacteristic(characteristic);
            this.connection.onCharacteristicChanged(wrapper);
        }
    }

    public void onDescriptorWrite(BluetoothGatt gatt, BluetoothGattDescriptor descriptor, int status) {
        if (this.connection != null && this.connection.isConnected()) {
            boolean isSuccess = 0 == status;
            this.connection.onDescriptorWritten(isSuccess, descriptor);
        }
    }

    private void onSecureWriteCharacteristicWritten() {
        if (this.readResponse) {
            this.scheduleCheckControlPoint();
        } else {
            this.onCharacteristicWritten();
        }
    }

    private void onCharacteristicWritten() {
        if (this.connection != null) {
            this.connection.onCharacteristicWritten(true, new WriteListener.WriteResponse(TimestampUtil.currentTimeSeconds(), null));
        }
    }

    @TargetApi(value=18)
    private void checkControlPointValue(BluetoothDeviceCharacteristic bluetoothDeviceCharacteristic) {
        byte[] value = bluetoothDeviceCharacteristic.getValue();
        if (value == null) {
            this.scheduleCheckControlPoint();
            return;
        }
        if (ConversionUtils.asInt(value) == 1) {
            this.readCharacteristicHandler.postDelayed(new Runnable(){

                @Override
                public void run() {
                    SecureGattController.this.readResponse();
                }
            }, TimeUnit.SECONDS.toMillis(1L));
        } else {
            this.scheduleCheckControlPoint();
        }
    }

    @TargetApi(value=18)
    private void checkResponse(BluetoothDeviceCharacteristic bluetoothDeviceCharacteristic) {
        byte[] responseValue = bluetoothDeviceCharacteristic.getValue();
        String response = Base64.encodeToString((byte[])responseValue, (int)0);
        if (this.connection != null) {
            this.connection.onCharacteristicWritten(true, new WriteListener.WriteResponse(TimestampUtil.currentTimeSeconds(), response));
        }
    }

    private void scheduleCheckControlPoint() {
        this.controlPointHandler.postDelayed(this.controlPointRunnable, 100L);
    }

    @TargetApi(value=18)
    private void readResponse() {
        try {
            BluetoothDeviceCharacteristic responseCharacteristic = this.secureKontaktDeviceStore.getSecureResponseCharacteristic();
            if (!this.gattServer.readCharacteristic((BluetoothGattCharacteristic)responseCharacteristic)) {
                this.connection.onCharacteristicWritten(false, null);
            }
        }
        catch (Exception e) {
            Logger.e("readResponse SecureGattController", e);
        }
    }

    @TargetApi(value=18)
    private void request(BluetoothDeviceCharacteristic wrapper) {
        if (wrapper != null && !this.gattServer.readCharacteristic((BluetoothGattCharacteristic)wrapper) && this.connection != null && this.connection.getState() == KontaktDeviceConnectionImpl.State.CHARACTERISTICS_REQUESTING) {
            this.requestOrSetAuthenticated();
        }
    }

    private void requestOrSetAuthenticated() {
        if (this.preAuthCharacteristicsQueue.isEmpty()) {
            this.onAfterCharacteristicAuthenticationPhase();
        } else {
            this.request(this.preAuthCharacteristicsQueue.poll());
        }
    }

    private void requestCharacteristics() {
        Collection<BluetoothDeviceCharacteristic> readableCharacteristics = this.secureKontaktDeviceStore.getReadableCharacteristics();
        if (this.preAuthCharacteristicsQueue == null) {
            this.preAuthCharacteristicsQueue = new ArrayDeque<BluetoothDeviceCharacteristic>(readableCharacteristics.size());
        } else {
            this.preAuthCharacteristicsQueue.clear();
        }
        this.preAuthCharacteristicsQueue.addAll(readableCharacteristics);
        this.request(this.preAuthCharacteristicsQueue.poll());
    }
}

