/*
 * Decompiled with CFR 0.152.
 */
package com.kontakt.sdk.android.ble.connection;

import com.kontakt.sdk.android.ble.exception.IllegalOperationException;
import com.kontakt.sdk.android.ble.util.DeviceUtils;
import com.kontakt.sdk.android.common.model.Model;
import com.kontakt.sdk.android.common.profile.RemoteBluetoothDevice;

enum OperationType {
    AUTHORIZATION,
    READ_TIME,
    SYNC_TIME,
    READ_LIGHT_SENSOR,
    SECURE_CONFIG,
    SECURE_COMMAND,
    GATEWAY_READ_NETWORK_COUNT,
    GATEWAY_SELECT_NETWORK,
    GATEWAY_READ_NETWORK;


    public void validate(RemoteBluetoothDevice device) {
        boolean validOperation = this.isValidOperationForDevice(device);
        if (!validOperation) {
            String message = "Operation not available for device model " + (Object)((Object)device.getModel()) + " with firmware version " + device.getFirmwareVersion();
            throw new IllegalOperationException(message);
        }
    }

    private boolean isValidOperationForDevice(RemoteBluetoothDevice device) {
        Model model = device.getModel() == null ? Model.UNKNOWN : device.getModel();
        String firmware = device.getFirmwareVersion();
        switch (this) {
            case READ_TIME: 
            case SYNC_TIME: {
                return DeviceUtils.hasRtcFeature(model, firmware);
            }
            case READ_LIGHT_SENSOR: {
                return DeviceUtils.hasLightSensorFeature(model, firmware);
            }
            case GATEWAY_READ_NETWORK: 
            case GATEWAY_READ_NETWORK_COUNT: 
            case GATEWAY_SELECT_NETWORK: {
                return DeviceUtils.isGateway(model);
            }
        }
        return true;
    }
}

