/*
 * Decompiled with CFR 0.152.
 */
package com.kontakt.sdk.android.ble.configuration;

import android.os.Build;
import com.kontakt.sdk.android.ble.configuration.ActivityCheckConfiguration;
import com.kontakt.sdk.android.ble.configuration.ForceScanConfiguration;
import com.kontakt.sdk.android.ble.configuration.KontaktScanFilter;
import com.kontakt.sdk.android.ble.configuration.ScanContextValidator;
import com.kontakt.sdk.android.ble.configuration.ScanMode;
import com.kontakt.sdk.android.ble.configuration.ScanPeriod;
import com.kontakt.sdk.android.ble.device.BeaconRegion;
import com.kontakt.sdk.android.ble.device.EddystoneNamespace;
import com.kontakt.sdk.android.ble.discovery.secure_profile.PayloadResolver;
import com.kontakt.sdk.android.ble.filter.eddystone.EddystoneFilter;
import com.kontakt.sdk.android.ble.filter.ibeacon.IBeaconFilter;
import com.kontakt.sdk.android.ble.manager.configuration.FiltersConfigurator;
import com.kontakt.sdk.android.ble.manager.configuration.GeneralConfigurator;
import com.kontakt.sdk.android.ble.manager.configuration.SpacesConfigurator;
import com.kontakt.sdk.android.ble.rssi.RssiCalculator;
import com.kontakt.sdk.android.ble.rssi.RssiCalculators;
import com.kontakt.sdk.android.ble.spec.EddystoneFrameType;
import com.kontakt.sdk.android.common.profile.DeviceProfile;
import com.kontakt.sdk.android.common.profile.IBeaconRegion;
import com.kontakt.sdk.android.common.profile.IEddystoneNamespace;
import com.kontakt.sdk.android.common.util.SDKPreconditions;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class ScanContext {
    public static final ScanContext DEFAULT = new Builder().build();
    static final long DEFAULT_DEVICES_UPDATE_CALLBACK_INTERVAL = 3000L;
    static final String DEFAULT_CACHE_FILE_NAME = "resolved.che";
    static final int DEFAULT_RESOLVE_INTERVAL = 3;
    static final int DEFAULT_MONITORING_SYNC_INTERVAL = 10;
    static final boolean DEFAULT_MONITORING_ENABLED = true;
    private final ScanPeriod scanPeriod;
    private final ScanMode scanMode;
    private final ActivityCheckConfiguration activityCheckConfiguration;
    private final ForceScanConfiguration forceScanConfiguration;
    private final RssiCalculator rssiCalculator;
    private final Set<IBeaconRegion> iBeaconRegions;
    private final Set<IEddystoneNamespace> eddystoneNamespaces;
    private final Set<EddystoneFrameType> eddystoneTriggerFrameTypes;
    private final List<IBeaconFilter> iBeaconFilters;
    private final List<EddystoneFilter> eddystoneFilters;
    private final Set<DeviceProfile> observedProfiles;
    private final List<PayloadResolver> customSecureProfilePayloadResolvers;
    private final String cacheFileName;
    private final int resolveInterval;
    private final int monitoringSyncInterval;
    private final boolean monitoringEnabled;
    private final long deviceUpdateCallbackInterval;
    private final List<KontaktScanFilter> kontaktScanFilters;

    ScanContext(Builder builder) {
        this.forceScanConfiguration = builder.forceScanConfiguration;
        this.scanPeriod = builder.scanPeriod;
        this.scanMode = builder.scanMode;
        this.activityCheckConfiguration = builder.activityCheckConfiguration;
        this.deviceUpdateCallbackInterval = builder.deviceUpdateCallbackInterval;
        this.rssiCalculator = builder.rssiCalculator;
        this.observedProfiles = builder.observedProfiles;
        this.eddystoneTriggerFrameTypes = builder.eddystoneTriggerFrameTypes;
        this.customSecureProfilePayloadResolvers = builder.customSecureProfilePayloadResolvers;
        this.iBeaconRegions = builder.iBeaconRegions;
        this.eddystoneNamespaces = builder.eddystoneNamespaces;
        this.iBeaconFilters = builder.iBeaconFilters;
        this.eddystoneFilters = builder.eddystoneFilters;
        this.cacheFileName = builder.cacheFileName;
        this.resolveInterval = builder.resolveInterval;
        this.monitoringSyncInterval = builder.monitoringSyncInterval;
        this.monitoringEnabled = builder.monitoringEnabled;
        this.kontaktScanFilters = builder.kontaktScanFilters;
    }

    public ActivityCheckConfiguration getActivityCheckConfiguration() {
        return this.activityCheckConfiguration;
    }

    public List<KontaktScanFilter> getKontaktScanFilters() {
        return this.kontaktScanFilters;
    }

    public Set<DeviceProfile> getObservedProfiles() {
        return this.observedProfiles;
    }

    public ForceScanConfiguration getForceScanConfiguration() {
        return this.forceScanConfiguration;
    }

    public ScanPeriod getScanPeriod() {
        return this.scanPeriod;
    }

    public ScanMode getScanMode() {
        return this.scanMode;
    }

    public long getDeviceUpdateCallbackInterval() {
        return this.deviceUpdateCallbackInterval;
    }

    public RssiCalculator getRssiCalculator() {
        return this.rssiCalculator;
    }

    public Set<EddystoneFrameType> getEddystoneFrameTypes() {
        return Collections.unmodifiableSet(this.eddystoneTriggerFrameTypes);
    }

    public Set<IBeaconRegion> getIBeaconRegions() {
        return Collections.unmodifiableSet(this.iBeaconRegions);
    }

    public Set<IEddystoneNamespace> getEddystoneNamespaces() {
        return Collections.unmodifiableSet(this.eddystoneNamespaces);
    }

    public List<IBeaconFilter> getIBeaconFilters() {
        return Collections.unmodifiableList(this.iBeaconFilters);
    }

    public List<EddystoneFilter> getEddystoneFilters() {
        return Collections.unmodifiableList(this.eddystoneFilters);
    }

    public List<PayloadResolver> getCustomSecureProfilePayloadResolvers() {
        return Collections.unmodifiableList(this.customSecureProfilePayloadResolvers);
    }

    public String getCacheFileName() {
        return this.cacheFileName;
    }

    public int getResolveInterval() {
        return this.resolveInterval;
    }

    public int getMonitoringSyncInterval() {
        return this.monitoringSyncInterval;
    }

    public boolean isMonitoringEnabled() {
        return this.monitoringEnabled;
    }

    public static final class Builder
    implements GeneralConfigurator,
    SpacesConfigurator,
    FiltersConfigurator {
        public List<KontaktScanFilter> kontaktScanFilters = new ArrayList<KontaktScanFilter>();
        ScanMode scanMode = ScanMode.BALANCED;
        ScanPeriod scanPeriod = ScanPeriod.RANGING;
        ForceScanConfiguration forceScanConfiguration = ForceScanConfiguration.DISABLED;
        ActivityCheckConfiguration activityCheckConfiguration = ActivityCheckConfiguration.DEFAULT;
        RssiCalculator rssiCalculator = RssiCalculators.DEFAULT;
        Set<DeviceProfile> observedProfiles = EnumSet.allOf(DeviceProfile.class);
        Set<EddystoneFrameType> eddystoneTriggerFrameTypes = EnumSet.noneOf(EddystoneFrameType.class);
        Set<IBeaconRegion> iBeaconRegions = new HashSet<IBeaconRegion>();
        Set<IEddystoneNamespace> eddystoneNamespaces = new HashSet<IEddystoneNamespace>();
        List<IBeaconFilter> iBeaconFilters = new ArrayList<IBeaconFilter>();
        List<EddystoneFilter> eddystoneFilters = new ArrayList<EddystoneFilter>();
        List<PayloadResolver> customSecureProfilePayloadResolvers = new ArrayList<PayloadResolver>();
        int resolveInterval = 3;
        int monitoringSyncInterval = 10;
        long deviceUpdateCallbackInterval = 3000L;
        boolean monitoringEnabled = true;
        String cacheFileName = "resolved.che";

        public Builder() {
        }

        public Builder(ScanContext context) {
            this.scanMode = context.getScanMode();
            this.scanPeriod = context.getScanPeriod();
            this.forceScanConfiguration = context.getForceScanConfiguration();
            this.activityCheckConfiguration = context.getActivityCheckConfiguration();
            this.deviceUpdateCallbackInterval = context.getDeviceUpdateCallbackInterval();
            this.rssiCalculator = context.getRssiCalculator();
            this.observedProfiles = context.getObservedProfiles();
            this.eddystoneTriggerFrameTypes = context.getEddystoneFrameTypes();
            this.customSecureProfilePayloadResolvers.clear();
            this.customSecureProfilePayloadResolvers.addAll(context.getCustomSecureProfilePayloadResolvers());
            this.cacheFileName = context.getCacheFileName();
            this.resolveInterval = context.getResolveInterval();
            this.monitoringSyncInterval = context.getMonitoringSyncInterval();
            this.monitoringEnabled = context.isMonitoringEnabled();
            this.iBeaconRegions.clear();
            this.iBeaconRegions.addAll(context.getIBeaconRegions());
            this.iBeaconFilters.clear();
            this.iBeaconFilters.addAll(context.getIBeaconFilters());
            this.eddystoneNamespaces.clear();
            this.eddystoneNamespaces.addAll(context.getEddystoneNamespaces());
            this.eddystoneFilters.clear();
            this.eddystoneFilters.addAll(context.getEddystoneFilters());
            this.kontaktScanFilters = context.kontaktScanFilters;
        }

        @Override
        public GeneralConfigurator scanPeriod(ScanPeriod scanPeriod) {
            SDKPreconditions.checkNotNull(scanPeriod, "Monitor period cannot be null");
            this.scanPeriod = scanPeriod;
            return this;
        }

        @Override
        public GeneralConfigurator scanMode(ScanMode scanMode) {
            SDKPreconditions.checkNotNull(scanMode, "Scan mode is null");
            this.scanMode = scanMode;
            return this;
        }

        @Override
        public GeneralConfigurator forceScanConfiguration(ForceScanConfiguration forceScanConfiguration) {
            SDKPreconditions.checkNotNull(forceScanConfiguration, "By default ForceScanConfiguration is disabled");
            this.forceScanConfiguration = Build.VERSION.SDK_INT >= 24 ? ForceScanConfiguration.DISABLED : forceScanConfiguration;
            return this;
        }

        @Override
        public GeneralConfigurator activityCheckConfiguration(ActivityCheckConfiguration activityCheckConfiguration) {
            SDKPreconditions.checkNotNull(activityCheckConfiguration, "Beacon activity check is null.");
            this.activityCheckConfiguration = activityCheckConfiguration;
            return this;
        }

        @Override
        public GeneralConfigurator cacheFileName(String name) {
            SDKPreconditions.checkNotNull(name, "Cache file name cannot be null!");
            this.cacheFileName = name;
            return this;
        }

        @Override
        public GeneralConfigurator monitoringEnabled(boolean enabled) {
            this.monitoringEnabled = enabled;
            return this;
        }

        @Override
        public GeneralConfigurator monitoringSyncInterval(int intervalInSeconds) {
            this.monitoringSyncInterval = intervalInSeconds;
            return this;
        }

        @Override
        public GeneralConfigurator resolveShuffledInterval(int intervalInSeconds) {
            this.resolveInterval = intervalInSeconds;
            return this;
        }

        @Override
        public GeneralConfigurator deviceUpdateCallbackInterval(long intervalInMillis) {
            this.deviceUpdateCallbackInterval = intervalInMillis;
            return this;
        }

        @Override
        public GeneralConfigurator rssiCalculator(RssiCalculator rssiCalculator) {
            SDKPreconditions.checkNotNull(rssiCalculator, "RssiCalculator can't be null");
            this.rssiCalculator = rssiCalculator;
            return this;
        }

        @Override
        public GeneralConfigurator eddystoneFrameTypes(Collection<EddystoneFrameType> eddystoneFrameTypes) {
            SDKPreconditions.checkNotNull(eddystoneFrameTypes, "Eddystone trigger frames");
            this.eddystoneTriggerFrameTypes.clear();
            this.eddystoneTriggerFrameTypes.addAll(eddystoneFrameTypes);
            return this;
        }

        @Override
        public GeneralConfigurator secureProfilePayloadResolver(PayloadResolver payloadResolver) {
            SDKPreconditions.checkNotNull(payloadResolver);
            this.secureProfilePayloadResolvers(Collections.singletonList(payloadResolver));
            return this;
        }

        @Override
        public GeneralConfigurator secureProfilePayloadResolvers(Collection<PayloadResolver> payloadResolvers) {
            SDKPreconditions.checkNotNull(payloadResolvers, "Resolvers collection is null");
            this.customSecureProfilePayloadResolvers.clear();
            this.customSecureProfilePayloadResolvers.addAll(payloadResolvers);
            return this;
        }

        @Override
        public SpacesConfigurator iBeaconRegion(IBeaconRegion region) {
            SDKPreconditions.checkNotNull(region);
            this.iBeaconRegions(Collections.singletonList(region));
            return this;
        }

        @Override
        public SpacesConfigurator iBeaconRegions(Collection<IBeaconRegion> regions) {
            SDKPreconditions.checkNotNull(regions, "Regions collection is null");
            this.iBeaconRegions.clear();
            this.iBeaconRegions.addAll(regions);
            return this;
        }

        @Override
        public SpacesConfigurator eddystoneNamespace(IEddystoneNamespace namespace) {
            SDKPreconditions.checkNotNull(namespace);
            this.eddystoneNamespaces(Collections.singletonList(namespace));
            return this;
        }

        @Override
        public SpacesConfigurator eddystoneNamespaces(Collection<IEddystoneNamespace> namespaces) {
            SDKPreconditions.checkNotNull(namespaces, "Eddystone namespaces are null.");
            this.eddystoneNamespaces.clear();
            this.eddystoneNamespaces.addAll(namespaces);
            return this;
        }

        @Override
        public Set<IBeaconRegion> getIBeaconRegions() {
            return Collections.unmodifiableSet(this.iBeaconRegions);
        }

        @Override
        public Set<IEddystoneNamespace> getEddystoneNamespaces() {
            return Collections.unmodifiableSet(this.eddystoneNamespaces);
        }

        @Override
        public FiltersConfigurator iBeaconFilter(IBeaconFilter filter) {
            SDKPreconditions.checkNotNull(filter);
            this.iBeaconFilters(Collections.singletonList(filter));
            return this;
        }

        @Override
        public FiltersConfigurator iBeaconFilters(Collection<IBeaconFilter> filters) {
            SDKPreconditions.checkNotNull(filters, "Filters are null.");
            this.iBeaconFilters.clear();
            this.iBeaconFilters.addAll(filters);
            return this;
        }

        @Override
        public FiltersConfigurator eddystoneFilter(EddystoneFilter filter) {
            SDKPreconditions.checkNotNull(filter);
            this.eddystoneFilters(Collections.singletonList(filter));
            return this;
        }

        @Override
        public FiltersConfigurator eddystoneFilters(Collection<EddystoneFilter> filters) {
            SDKPreconditions.checkNotNull(filters, "Filters are null.");
            this.eddystoneFilters.clear();
            this.eddystoneFilters.addAll(filters);
            return this;
        }

        @Override
        public List<IBeaconFilter> getIBeaconFilters() {
            return Collections.unmodifiableList(this.iBeaconFilters);
        }

        @Override
        public List<EddystoneFilter> getEddystoneFilters() {
            return Collections.unmodifiableList(this.eddystoneFilters);
        }

        @Override
        public void clearAll() {
            this.iBeaconFilters(Collections.emptyList());
            this.eddystoneFilters(Collections.emptyList());
        }

        public Builder observedProfiles(Set<DeviceProfile> observedProfiles) {
            SDKPreconditions.checkNotNull(observedProfiles, "Observed profiles can't be null");
            this.observedProfiles = observedProfiles;
            return this;
        }

        public Builder addObservedProfile(DeviceProfile profile) {
            SDKPreconditions.checkNotNull(profile, "Observed profiles can't be null");
            this.observedProfiles.add(profile);
            return this;
        }

        public Builder removeObservedProfile(DeviceProfile profile) {
            SDKPreconditions.checkNotNull(profile, "Observed profiles can't be null");
            this.observedProfiles.remove((Object)profile);
            return this;
        }

        @Override
        public GeneralConfigurator kontaktScanFilters(List<KontaktScanFilter> kontaktScanFilters) {
            this.kontaktScanFilters.clear();
            this.kontaktScanFilters.addAll(kontaktScanFilters);
            return this;
        }

        public ScanContext build() {
            ScanContextValidator.validate(this.scanPeriod);
            ScanContextValidator.validateMonitoringSyncInterval(this.monitoringSyncInterval);
            ScanContextValidator.validateResolveShuffleInterval(this.resolveInterval);
            ScanContextValidator.validateDeviceUpdateCallbackInterval(this.deviceUpdateCallbackInterval);
            ScanContextValidator.validateCacheFileName(this.cacheFileName);
            ScanContextValidator.validateEddystoneFiltersCount(this.eddystoneFilters);
            ScanContextValidator.validateIBeaconFiltersCount(this.iBeaconFilters);
            ScanContextValidator.validateIBeaconRegionsCount(this.iBeaconRegions);
            ScanContextValidator.validateNamespacesCount(this.eddystoneNamespaces);
            ScanContextValidator.validate(this.activityCheckConfiguration);
            ScanContextValidator.validate(this.forceScanConfiguration);
            ScanContextValidator.validate(this.activityCheckConfiguration, this.scanPeriod);
            if (this.iBeaconRegions.isEmpty()) {
                this.iBeaconRegions.add(BeaconRegion.EVERYWHERE);
            }
            if (this.eddystoneNamespaces.isEmpty()) {
                this.eddystoneNamespaces.add(EddystoneNamespace.EVERYWHERE);
            }
            return new ScanContext(this);
        }
    }
}

