/*
 * Decompiled with CFR 0.152.
 */
package com.kontakt.sdk.android.ble.configuration;

import android.bluetooth.BluetoothAdapter;
import android.os.ParcelUuid;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.List;

public class KontaktScanFilter {
    public static final KontaktScanFilter KONTAKT_SERVICE_DATA_FILTER = new Builder().setServiceData(ParcelUuid.fromString((String)"0000fe6a-0000-1000-8000-00805f9b34fb"), new byte[0]).build();
    public static final KontaktScanFilter IBEACON_MANUFACTURER_DATA_FILTER = new Builder().setManufacturerData(76, new byte[0]).build();
    public static final KontaktScanFilter KONTAKT_NAME_FILTER = new Builder().setDeviceName("Kontakt").build();
    public static final List<KontaktScanFilter> DEFAULT_FILTERS_LIST = Arrays.asList(KONTAKT_NAME_FILTER, KONTAKT_SERVICE_DATA_FILTER, IBEACON_MANUFACTURER_DATA_FILTER);
    private final String mDeviceName;
    private final String mDeviceAddress;
    private final ParcelUuid mServiceUuid;
    private final ParcelUuid mServiceUuidMask;
    private final ParcelUuid mServiceDataUuid;
    private final byte[] mServiceData;
    private final byte[] mServiceDataMask;
    private final int mManufacturerId;
    private final byte[] mManufacturerData;
    private final byte[] mManufacturerDataMask;
    private final EnumSet<FilterType> filterTypes;

    private KontaktScanFilter(String name, String deviceAddress, ParcelUuid uuid, ParcelUuid uuidMask, ParcelUuid serviceDataUuid, byte[] serviceData, byte[] serviceDataMask, int manufacturerId, byte[] manufacturerData, byte[] manufacturerDataMask, EnumSet<FilterType> filterTypes) {
        this.mDeviceName = name;
        this.mServiceUuid = uuid;
        this.mServiceUuidMask = uuidMask;
        this.mDeviceAddress = deviceAddress;
        this.mServiceDataUuid = serviceDataUuid;
        this.mServiceData = serviceData;
        this.mServiceDataMask = serviceDataMask;
        this.mManufacturerId = manufacturerId;
        this.mManufacturerData = manufacturerData;
        this.mManufacturerDataMask = manufacturerDataMask;
        this.filterTypes = filterTypes;
    }

    public String toString() {
        return "KontaktScanFilter [mDeviceName=" + this.mDeviceName + ", mDeviceAddress=" + this.mDeviceAddress + ", mUuid=" + this.mServiceUuid + ", mUuidMask=" + this.mServiceUuidMask + ", mServiceDataUuid=" + this.mServiceDataUuid + ", mServiceData=" + Arrays.toString(this.mServiceData) + ", mServiceDataMask=" + Arrays.toString(this.mServiceDataMask) + ", mManufacturerId=" + this.mManufacturerId + ", mManufacturerData=" + Arrays.toString(this.mManufacturerData) + ", mManufacturerDataMask=" + Arrays.toString(this.mManufacturerDataMask) + "]";
    }

    public byte[] getManufacturerData() {
        return this.mManufacturerData;
    }

    public byte[] getManufacturerDataMask() {
        return this.mManufacturerDataMask;
    }

    public byte[] getServiceData() {
        return this.mServiceData;
    }

    public byte[] getServiceDataMask() {
        return this.mServiceDataMask;
    }

    public int getManufacturerId() {
        return this.mManufacturerId;
    }

    public ParcelUuid getServiceDataUuid() {
        return this.mServiceDataUuid;
    }

    public ParcelUuid getServiceUuid() {
        return this.mServiceUuid;
    }

    public ParcelUuid getServiceUuidMask() {
        return this.mServiceUuidMask;
    }

    public String getDeviceAddress() {
        return this.mDeviceAddress;
    }

    public String getDeviceName() {
        return this.mDeviceName;
    }

    public EnumSet<FilterType> getFilterTypes() {
        return this.filterTypes;
    }

    public static enum FilterType {
        DEVICE_ADDRESS,
        SERVICE_DATA,
        MANUFACTURER_DATA,
        DEVICE_NAME,
        SERVICE_UUID;

    }

    public static final class Builder {
        private String mDeviceName;
        private String mDeviceAddress;
        private ParcelUuid mServiceUuid;
        private ParcelUuid mUuidMask;
        private ParcelUuid mServiceDataUuid;
        private byte[] mServiceData;
        private byte[] mServiceDataMask;
        private int mManufacturerId = -1;
        private byte[] mManufacturerData;
        private byte[] mManufacturerDataMask;
        private EnumSet<FilterType> filterTypes = EnumSet.noneOf(FilterType.class);

        public Builder setDeviceName(String deviceName) {
            this.mDeviceName = deviceName;
            this.filterTypes.add(FilterType.DEVICE_NAME);
            return this;
        }

        public Builder setDeviceAddress(String deviceAddress) {
            if (deviceAddress != null && !BluetoothAdapter.checkBluetoothAddress((String)deviceAddress)) {
                throw new IllegalArgumentException("invalid device address " + deviceAddress);
            }
            this.mDeviceAddress = deviceAddress;
            this.filterTypes.add(FilterType.DEVICE_ADDRESS);
            return this;
        }

        public Builder setServiceUuid(ParcelUuid serviceUuid) {
            this.mServiceUuid = serviceUuid;
            this.mUuidMask = null;
            this.filterTypes.add(FilterType.SERVICE_UUID);
            return this;
        }

        public Builder setServiceUuid(ParcelUuid serviceUuid, ParcelUuid uuidMask) {
            if (this.mUuidMask != null && this.mServiceUuid == null) {
                throw new IllegalArgumentException("uuid is null while uuidMask is not null!");
            }
            this.mServiceUuid = serviceUuid;
            this.mUuidMask = uuidMask;
            this.filterTypes.add(FilterType.SERVICE_UUID);
            return this;
        }

        public Builder setServiceData(ParcelUuid serviceDataUuid, byte[] serviceData) {
            if (serviceDataUuid == null) {
                throw new IllegalArgumentException("serviceDataUuid is null");
            }
            this.mServiceDataUuid = serviceDataUuid;
            this.mServiceData = serviceData;
            this.mServiceDataMask = null;
            this.filterTypes.add(FilterType.SERVICE_DATA);
            return this;
        }

        public Builder setServiceData(ParcelUuid serviceDataUuid, byte[] serviceData, byte[] serviceDataMask) {
            if (serviceDataUuid == null) {
                throw new IllegalArgumentException("serviceDataUuid is null");
            }
            if (this.mServiceDataMask != null) {
                if (this.mServiceData == null) {
                    throw new IllegalArgumentException("serviceData is null while serviceDataMask is not null");
                }
                if (this.mServiceData.length != this.mServiceDataMask.length) {
                    throw new IllegalArgumentException("size mismatch for service data and service data mask");
                }
            }
            this.mServiceDataUuid = serviceDataUuid;
            this.mServiceData = serviceData;
            this.mServiceDataMask = serviceDataMask;
            this.filterTypes.add(FilterType.SERVICE_DATA);
            return this;
        }

        public Builder setManufacturerData(int manufacturerId, byte[] manufacturerData) {
            if (manufacturerData != null && manufacturerId < 0) {
                throw new IllegalArgumentException("invalid manufacture id");
            }
            this.mManufacturerId = manufacturerId;
            this.mManufacturerData = manufacturerData;
            this.mManufacturerDataMask = null;
            this.filterTypes.add(FilterType.MANUFACTURER_DATA);
            return this;
        }

        public Builder setManufacturerData(int manufacturerId, byte[] manufacturerData, byte[] manufacturerDataMask) {
            if (manufacturerData != null && manufacturerId < 0) {
                throw new IllegalArgumentException("invalid manufacture id");
            }
            if (this.mManufacturerDataMask != null) {
                if (this.mManufacturerData == null) {
                    throw new IllegalArgumentException("manufacturerData is null while manufacturerDataMask is not null");
                }
                if (this.mManufacturerData.length != this.mManufacturerDataMask.length) {
                    throw new IllegalArgumentException("size mismatch for manufacturerData and manufacturerDataMask");
                }
            }
            this.mManufacturerId = manufacturerId;
            this.mManufacturerData = manufacturerData;
            this.mManufacturerDataMask = manufacturerDataMask;
            this.filterTypes.add(FilterType.MANUFACTURER_DATA);
            return this;
        }

        public KontaktScanFilter build() {
            return new KontaktScanFilter(this.mDeviceName, this.mDeviceAddress, this.mServiceUuid, this.mUuidMask, this.mServiceDataUuid, this.mServiceData, this.mServiceDataMask, this.mManufacturerId, this.mManufacturerData, this.mManufacturerDataMask, this.filterTypes);
        }
    }
}

