/*
 * Decompiled with CFR 0.152.
 */
package com.kontakt.sdk.android.ble.cache;

import com.kontakt.sdk.android.ble.cache.FutureShufflesCache;
import com.kontakt.sdk.android.ble.cache.ResolveRequestStatus;
import com.kontakt.sdk.android.ble.cache.ResolverType;
import com.kontakt.sdk.android.ble.cache.SecureProfileResolveRequest;
import com.kontakt.sdk.android.ble.cache.SecureProfileResolveStrategy;
import com.kontakt.sdk.android.common.model.ResolvedId;
import com.kontakt.sdk.android.common.model.SecureProfileFutureUID;
import com.kontakt.sdk.android.common.model.SecureProfileUid;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;

class SecureProfileCacheResolveStrategy
implements SecureProfileResolveStrategy {
    private final FutureShufflesCache cache;

    SecureProfileCacheResolveStrategy(FutureShufflesCache cache) {
        this.cache = cache;
    }

    @Override
    public List<SecureProfileFutureUID> resolve(Map<SecureProfileUid, SecureProfileResolveRequest> requests) throws Exception {
        List<SecureProfileUid> toResolve = this.profilesToResolve(requests);
        if (toResolve.isEmpty()) {
            return Collections.emptyList();
        }
        List<SecureProfileFutureUID> futureIds = this.resolveProfiles(toResolve);
        this.updateRequests(requests, futureIds);
        return futureIds;
    }

    private List<SecureProfileUid> profilesToResolve(Map<SecureProfileUid, SecureProfileResolveRequest> requests) {
        ArrayList<SecureProfileUid> toResolve = new ArrayList<SecureProfileUid>();
        for (Map.Entry<SecureProfileUid, SecureProfileResolveRequest> entry : requests.entrySet()) {
            SecureProfileResolveRequest request = entry.getValue();
            if (ResolveRequestStatus.RESOLVED == request.getStatus()) continue;
            toResolve.add(entry.getKey());
        }
        return toResolve;
    }

    private List<SecureProfileFutureUID> resolveProfiles(List<SecureProfileUid> uids) {
        ArrayList<SecureProfileFutureUID> futureIds = new ArrayList<SecureProfileFutureUID>();
        for (SecureProfileUid secureUID : uids) {
            ResolvedId resolvedId = this.cache.get(secureUID.toString());
            if (resolvedId == null || FutureShufflesCache.PHANTOM_ENTRY.equals(resolvedId)) continue;
            SecureProfileFutureUID futureUID = new SecureProfileFutureUID.Builder().futureIds(new ArrayList<SecureProfileUid>()).uniqueId(resolvedId.getUniqueId()).queriedBy(secureUID).resolved(resolvedId.getSecureProfileUID()).build();
            futureIds.add(futureUID);
        }
        return futureIds;
    }

    private void updateRequests(Map<SecureProfileUid, SecureProfileResolveRequest> requests, List<SecureProfileFutureUID> futureIds) {
        for (SecureProfileFutureUID id : futureIds) {
            this.updateRequest(requests, id);
        }
    }

    private void updateRequest(Map<SecureProfileUid, SecureProfileResolveRequest> requests, SecureProfileFutureUID id) {
        SecureProfileResolveRequest request = requests.get(id.getQueriedBy());
        request.setResolvedBy(ResolverType.CACHE);
        if (ResolveRequestStatus.IGNORED == request.getStatus()) {
            return;
        }
        request.setStatus(ResolveRequestStatus.RESOLVED);
    }
}

