/*
 * Decompiled with CFR 0.152.
 */
package com.kontakt.sdk.android.ble.cache;

import com.kontakt.sdk.android.ble.cache.FutureShufflesCache;
import com.kontakt.sdk.android.ble.cache.IBeaconResolveRequest;
import com.kontakt.sdk.android.ble.cache.IBeaconResolveStrategy;
import com.kontakt.sdk.android.ble.cache.ResolveRequestStatus;
import com.kontakt.sdk.android.ble.cache.ResolverType;
import com.kontakt.sdk.android.common.model.IBeaconFutureId;
import com.kontakt.sdk.android.common.model.IBeaconId;
import com.kontakt.sdk.android.common.model.ResolvedId;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;

class IBeaconCacheResolveStrategy
implements IBeaconResolveStrategy {
    private final FutureShufflesCache cache;

    IBeaconCacheResolveStrategy(FutureShufflesCache cache) {
        this.cache = cache;
    }

    @Override
    public List<IBeaconFutureId> resolve(Map<IBeaconId, IBeaconResolveRequest> requests) throws Exception {
        List<IBeaconId> toResolve = this.iBeaconsToResolve(requests);
        if (toResolve.isEmpty()) {
            return Collections.emptyList();
        }
        List<IBeaconFutureId> futureIds = this.resolveIBeacons(toResolve);
        this.updateRequests(requests, futureIds);
        return futureIds;
    }

    private List<IBeaconId> iBeaconsToResolve(Map<IBeaconId, IBeaconResolveRequest> requests) {
        ArrayList<IBeaconId> toResolve = new ArrayList<IBeaconId>();
        for (Map.Entry<IBeaconId, IBeaconResolveRequest> entry : requests.entrySet()) {
            IBeaconResolveRequest request = entry.getValue();
            if (ResolveRequestStatus.RESOLVED == request.getStatus()) continue;
            toResolve.add(entry.getKey());
        }
        return toResolve;
    }

    private List<IBeaconFutureId> resolveIBeacons(List<IBeaconId> toResolve) {
        ArrayList<IBeaconFutureId> futureIds = new ArrayList<IBeaconFutureId>();
        for (IBeaconId beaconId : toResolve) {
            ResolvedId resolvedId = this.cache.get(beaconId.toString());
            if (resolvedId == null || FutureShufflesCache.PHANTOM_ENTRY.equals(resolvedId)) continue;
            IBeaconFutureId iBeaconFutureId = new IBeaconFutureId.Builder().futureIds(new ArrayList<IBeaconId>()).uniqueId(resolvedId.getUniqueId()).queriedBy(beaconId).resolved(resolvedId.getIBeaconId()).build();
            futureIds.add(iBeaconFutureId);
        }
        return futureIds;
    }

    private void updateRequests(Map<IBeaconId, IBeaconResolveRequest> requests, List<IBeaconFutureId> futureIds) {
        for (IBeaconFutureId id : futureIds) {
            this.updateRequest(requests, id);
        }
    }

    private void updateRequest(Map<IBeaconId, IBeaconResolveRequest> requests, IBeaconFutureId id) {
        IBeaconResolveRequest request = requests.get(id.getQueriedBy());
        request.setResolvedBy(ResolverType.CACHE);
        if (ResolveRequestStatus.IGNORED == request.getStatus()) {
            return;
        }
        request.setStatus(ResolveRequestStatus.RESOLVED);
    }
}

