/*
 * Decompiled with CFR 0.152.
 */
package com.kontakt.sdk.android.common.util;

import java.util.Collection;
import java.util.Iterator;

public abstract class SDKEqualsBuilder {
    static final SDKEqualsBuilder ACTIVE = new SDKEqualsBuilder(){

        @Override
        public SDKEqualsBuilder equals(int lhs, int rhs) {
            return lhs == rhs ? ACTIVE : FALSE;
        }

        @Override
        public SDKEqualsBuilder equals(boolean lhs, boolean rhs) {
            return lhs == rhs ? ACTIVE : FALSE;
        }

        @Override
        public SDKEqualsBuilder equals(long left, long right) {
            return left == right ? ACTIVE : FALSE;
        }

        @Override
        public SDKEqualsBuilder equals(float left, float right) {
            return left == right ? ACTIVE : FALSE;
        }

        @Override
        public SDKEqualsBuilder equals(double left, double right) {
            return left == right ? ACTIVE : FALSE;
        }

        @Override
        public SDKEqualsBuilder equals(char left, char right) {
            return left == right ? ACTIVE : FALSE;
        }

        @Override
        public SDKEqualsBuilder equals(Object left, Object right) {
            if (left == right) {
                return ACTIVE;
            }
            if (left == null || right == null) {
                return FALSE;
            }
            if (left.getClass() != right.getClass()) {
                return FALSE;
            }
            return left.equals(right) ? ACTIVE : FALSE;
        }

        @Override
        public SDKEqualsBuilder equals(Object[] left, Object[] right) {
            if (left == right) {
                return ACTIVE;
            }
            if (left == null || right == null) {
                return FALSE;
            }
            if (left.length != right.length) {
                return FALSE;
            }
            int size = left.length;
            for (int i = 0; i < size; ++i) {
                if (this.equals(left[i], right[i]) != FALSE) continue;
                return FALSE;
            }
            return ACTIVE;
        }

        @Override
        public SDKEqualsBuilder equals(Collection left, Collection right) {
            if (left == right) {
                return ACTIVE;
            }
            if (left == null || right == null) {
                return FALSE;
            }
            if (left.size() != right.size()) {
                return FALSE;
            }
            Iterator leftIterator = left.iterator();
            Iterator rightIterator = right.iterator();
            while (leftIterator.hasNext()) {
                Object rightObject;
                Object leftObject = leftIterator.next();
                if (leftObject.equals(rightObject = rightIterator.next())) continue;
                return FALSE;
            }
            return ACTIVE;
        }

        @Override
        public boolean result() {
            return true;
        }
    };
    static final SDKEqualsBuilder FALSE = new FalseSDKEqualsBuilder();

    private SDKEqualsBuilder() {
    }

    public abstract SDKEqualsBuilder equals(int var1, int var2);

    public abstract SDKEqualsBuilder equals(boolean var1, boolean var2);

    public abstract SDKEqualsBuilder equals(long var1, long var3);

    public abstract SDKEqualsBuilder equals(float var1, float var2);

    public abstract SDKEqualsBuilder equals(double var1, double var3);

    public abstract SDKEqualsBuilder equals(Object var1, Object var2);

    public abstract SDKEqualsBuilder equals(char var1, char var2);

    public abstract SDKEqualsBuilder equals(Object[] var1, Object[] var2);

    public abstract SDKEqualsBuilder equals(Collection var1, Collection var2);

    public abstract boolean result();

    public static SDKEqualsBuilder start() {
        return ACTIVE;
    }

    private static final class FalseSDKEqualsBuilder
    extends SDKEqualsBuilder {
        FalseSDKEqualsBuilder() {
        }

        @Override
        public SDKEqualsBuilder equals(int lhs, int rhs) {
            return this;
        }

        @Override
        public SDKEqualsBuilder equals(boolean lhs, boolean rhs) {
            return this;
        }

        @Override
        public SDKEqualsBuilder equals(long left, long right) {
            return this;
        }

        @Override
        public SDKEqualsBuilder equals(float left, float right) {
            return this;
        }

        @Override
        public SDKEqualsBuilder equals(double left, double right) {
            return this;
        }

        @Override
        public SDKEqualsBuilder equals(Object left, Object right) {
            return this;
        }

        @Override
        public SDKEqualsBuilder equals(char left, char right) {
            return this;
        }

        @Override
        public SDKEqualsBuilder equals(Object[] left, Object[] right) {
            return this;
        }

        @Override
        public SDKEqualsBuilder equals(Collection left, Collection right) {
            return this;
        }

        @Override
        public boolean result() {
            return false;
        }
    }
}

