/*
 * Decompiled with CFR 0.152.
 */
package com.kontakt.sdk.android.common.model;

import android.os.Parcel;
import android.os.Parcelable;
import com.kontakt.sdk.android.common.model.Coordinates;

public class PlaceCoordinates
implements Coordinates {
    public static final Parcelable.Creator<PlaceCoordinates> CREATOR = new Parcelable.Creator<PlaceCoordinates>(){

        public PlaceCoordinates createFromParcel(Parcel source) {
            return new PlaceCoordinates(source);
        }

        public PlaceCoordinates[] newArray(int size) {
            return new PlaceCoordinates[size];
        }
    };
    private final double x1;
    private final double y1;
    private final double x2;
    private final double y2;

    public PlaceCoordinates(double x1, double y1, double x2, double y2) {
        this.x1 = x1;
        this.y1 = y1;
        this.x2 = x2;
        this.y2 = y2;
    }

    protected PlaceCoordinates(Parcel in) {
        this.x1 = in.readDouble();
        this.y1 = in.readDouble();
        this.x2 = in.readDouble();
        this.y2 = in.readDouble();
    }

    public double getX1() {
        return this.x1;
    }

    public double getY1() {
        return this.y1;
    }

    public double getX2() {
        return this.x2;
    }

    public double getY2() {
        return this.y2;
    }

    @Override
    public Coordinates.Type getType() {
        return Coordinates.Type.PLACE;
    }

    public String toString() {
        return this.x1 + ":" + this.y1 + "," + this.x2 + ":" + this.y2;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PlaceCoordinates that = (PlaceCoordinates)o;
        if (Double.compare(that.x1, this.x1) != 0) {
            return false;
        }
        if (Double.compare(that.y1, this.y1) != 0) {
            return false;
        }
        if (Double.compare(that.x2, this.x2) != 0) {
            return false;
        }
        return Double.compare(that.y2, this.y2) == 0;
    }

    public int hashCode() {
        long temp = Double.doubleToLongBits(this.x1);
        int result = (int)(temp ^ temp >>> 32);
        temp = Double.doubleToLongBits(this.y1);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        temp = Double.doubleToLongBits(this.x2);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        temp = Double.doubleToLongBits(this.y2);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        return result;
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        dest.writeDouble(this.x1);
        dest.writeDouble(this.y1);
        dest.writeDouble(this.x2);
        dest.writeDouble(this.y2);
    }
}

