/*
 * Decompiled with CFR 0.152.
 */
package com.kontakt.sdk.android.common.model;

import android.os.Parcel;
import android.os.Parcelable;
import com.kontakt.sdk.android.common.model.Company;
import com.kontakt.sdk.android.common.util.HashCodeBuilder;
import com.kontakt.sdk.android.common.util.SDKEqualsBuilder;
import java.io.Serializable;
import java.util.UUID;

public class Manager
implements Parcelable {
    public static final Parcelable.Creator<Manager> CREATOR = new Parcelable.Creator<Manager>(){

        public Manager createFromParcel(Parcel source) {
            return new Manager(source);
        }

        public Manager[] newArray(int size) {
            return new Manager[size];
        }
    };
    private final String uniqueId;
    private final UUID id;
    private final UUID supervisorId;
    private final String firstName;
    private final String lastName;
    private final String email;
    private final Role role;
    private final Company company;

    public static Builder builder() {
        return new Builder();
    }

    private Manager() {
        this(new Builder());
    }

    Manager(Builder builder) {
        this.uniqueId = builder.uniqueId;
        this.id = builder.id;
        this.supervisorId = builder.supervisorId;
        this.firstName = builder.firstName;
        this.lastName = builder.lastName;
        this.email = builder.email;
        this.role = builder.role;
        this.company = builder.company;
    }

    protected Manager(Parcel in) {
        this.uniqueId = in.readString();
        this.id = (UUID)in.readSerializable();
        this.supervisorId = (UUID)in.readSerializable();
        this.firstName = in.readString();
        this.lastName = in.readString();
        this.email = in.readString();
        int tmpRole = in.readInt();
        this.role = tmpRole == -1 ? null : Role.values()[tmpRole];
        this.company = (Company)in.readParcelable(Company.class.getClassLoader());
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null || !(object instanceof Manager)) {
            return false;
        }
        Manager manager = (Manager)object;
        return SDKEqualsBuilder.start().equals(this.uniqueId, manager.uniqueId).equals(this.id, manager.id).equals(this.supervisorId, manager.supervisorId).equals(this.firstName, manager.firstName).equals(this.lastName, manager.lastName).equals(this.email, manager.email).equals((Object)this.role, (Object)manager.role).result();
    }

    public int hashCode() {
        return HashCodeBuilder.init().append(this.uniqueId).append(this.id).append(this.supervisorId).append(this.firstName).append(this.lastName).append(this.email).append((Object)this.role).build();
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        dest.writeString(this.uniqueId);
        dest.writeSerializable((Serializable)this.id);
        dest.writeSerializable((Serializable)this.supervisorId);
        dest.writeString(this.firstName);
        dest.writeString(this.lastName);
        dest.writeString(this.email);
        dest.writeInt(this.role == null ? -1 : this.role.ordinal());
        dest.writeParcelable((Parcelable)this.company, flags);
    }

    public String getUniqueId() {
        return this.uniqueId;
    }

    public UUID getId() {
        return this.id;
    }

    public UUID getSupervisorId() {
        return this.supervisorId;
    }

    public String getFirstName() {
        return this.firstName;
    }

    public String getLastName() {
        return this.lastName;
    }

    public String getEmail() {
        return this.email;
    }

    public Role getRole() {
        return this.role;
    }

    public Company getCompany() {
        return this.company;
    }

    public static class Builder {
        String uniqueId;
        UUID id;
        UUID supervisorId;
        String firstName;
        String lastName;
        String email;
        Role role;
        Company company;

        public Builder uniqueId(String uniqueId) {
            this.uniqueId = uniqueId;
            return this;
        }

        public Builder id(UUID id) {
            this.id = id;
            return this;
        }

        public Builder supervisorId(UUID supervisorId) {
            this.supervisorId = supervisorId;
            return this;
        }

        public Builder firstName(String firstName) {
            this.firstName = firstName;
            return this;
        }

        public Builder lastName(String lastName) {
            this.lastName = lastName;
            return this;
        }

        public Builder email(String email) {
            this.email = email;
            return this;
        }

        public Builder role(Role role) {
            this.role = role;
            return this;
        }

        public Builder company(Company company) {
            this.company = company;
            return this;
        }

        public Manager build() {
            return new Manager(this);
        }
    }

    public static enum Role {
        SUPERUSER,
        ADMIN,
        OPERATOR;

    }
}

