/*
 * Decompiled with CFR 0.152.
 */
package com.kontakt.sdk.android.common.log;

import android.util.Log;
import com.kontakt.sdk.android.common.log.LogLevel;
import java.lang.reflect.Method;
import java.util.EnumSet;
import java.util.Set;

public final class Logger {
    private static final String TAG = "kontakt.io SDK";
    private static final Set<LogLevel> LOG_LEVELS = EnumSet.of(LogLevel.DEBUG);
    private static boolean DEBUG_LOGGING_ENABLED = false;
    private static boolean CRASHLYTICS_LOGGING_ENABLED = false;
    private static Method CRASHLYTICS_LOG_METHOD = null;
    private static Method CRASHLYTICS_LOG_EXCEPTION_METHOD = null;

    private Logger() {
    }

    public static void setCrashlyticsLoggingEnabled(boolean state) {
        if (state) {
            try {
                Class<?> crashlytics = Class.forName("com.crashlytics.android.Crashlytics");
                CRASHLYTICS_LOG_METHOD = crashlytics.getMethod("log", String.class);
                CRASHLYTICS_LOG_EXCEPTION_METHOD = crashlytics.getMethod("logException", Throwable.class);
                CRASHLYTICS_LOGGING_ENABLED = true;
            }
            catch (Exception e) {
                e.printStackTrace();
                CRASHLYTICS_LOGGING_ENABLED = false;
            }
        }
    }

    public static void crashlyticsLog(String log) {
        if (CRASHLYTICS_LOGGING_ENABLED) {
            try {
                CRASHLYTICS_LOG_METHOD.invoke(null, Logger.toString(TAG, ": " + log));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public static void crashlyticsExceptionLog(Throwable throwable) {
        if (CRASHLYTICS_LOGGING_ENABLED) {
            try {
                CRASHLYTICS_LOG_EXCEPTION_METHOD.invoke(null, Logger.toString(TAG, ": " + throwable));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public static synchronized void setDebugLoggingEnabled(boolean state) {
        DEBUG_LOGGING_ENABLED = state;
    }

    public static synchronized void setLogLevelEnabled(LogLevel logLevel, boolean state) {
        if (state) {
            LOG_LEVELS.add(logLevel);
        } else {
            LOG_LEVELS.remove((Object)logLevel);
        }
    }

    public static synchronized void reset() {
        LOG_LEVELS.clear();
        DEBUG_LOGGING_ENABLED = false;
    }

    public static void v(String msg) {
        if (DEBUG_LOGGING_ENABLED) {
            Log.v((String)TAG, (String)msg);
        }
    }

    public static void v(String msg, Throwable tr) {
        if (DEBUG_LOGGING_ENABLED && LOG_LEVELS.contains((Object)LogLevel.VERBOSE)) {
            Log.v((String)TAG, (String)msg, (Throwable)tr);
        }
    }

    public static void d(String msg) {
        if (DEBUG_LOGGING_ENABLED && LOG_LEVELS.contains((Object)LogLevel.DEBUG)) {
            Log.d((String)TAG, (String)msg);
        }
    }

    public static void d(String msg, Throwable tr) {
        if (DEBUG_LOGGING_ENABLED && LOG_LEVELS.contains((Object)LogLevel.DEBUG)) {
            Log.d((String)TAG, (String)msg, (Throwable)tr);
        }
    }

    public static void i(String msg) {
        if (DEBUG_LOGGING_ENABLED && LOG_LEVELS.contains((Object)LogLevel.INFO)) {
            Log.i((String)TAG, (String)msg);
        }
    }

    public static void i(String msg, Throwable tr) {
        if (DEBUG_LOGGING_ENABLED && LOG_LEVELS.contains((Object)LogLevel.INFO)) {
            Log.i((String)TAG, (String)msg, (Throwable)tr);
        }
    }

    public static void w(String msg) {
        if (DEBUG_LOGGING_ENABLED && LOG_LEVELS.contains((Object)LogLevel.WARNING)) {
            Log.w((String)TAG, (String)msg);
        }
    }

    public static void w(String msg, Throwable tr) {
        if (DEBUG_LOGGING_ENABLED && LOG_LEVELS.contains((Object)LogLevel.WARNING)) {
            Log.w((String)TAG, (String)msg, (Throwable)tr);
        }
    }

    public static void w(Throwable tr) {
        if (DEBUG_LOGGING_ENABLED && LOG_LEVELS.contains((Object)LogLevel.WARNING)) {
            Log.w((String)TAG, (Throwable)tr);
        }
    }

    public static void e(String msg) {
        if (DEBUG_LOGGING_ENABLED && LOG_LEVELS.contains((Object)LogLevel.ERROR)) {
            Log.e((String)TAG, (String)msg);
        }
    }

    public static void e(String msg, Throwable tr) {
        if (DEBUG_LOGGING_ENABLED && LOG_LEVELS.contains((Object)LogLevel.ERROR)) {
            Log.e((String)TAG, (String)msg, (Throwable)tr);
        }
    }

    private static String toString(String ... strings) {
        if (strings == null || strings.length == 0) {
            return "";
        }
        StringBuilder builder = new StringBuilder();
        for (String s : strings) {
            builder.append(s);
        }
        return builder.toString();
    }
}

