/*
 * Decompiled with CFR 0.152.
 */
package com.kontakt.sdk.android.cloud.api.executor.proximities;

import com.kontakt.sdk.android.cloud.api.executor.PaginatedRequestExecutor;
import com.kontakt.sdk.android.cloud.api.service.ProximitiesService;
import com.kontakt.sdk.android.cloud.response.paginated.Proximities;
import com.kontakt.sdk.android.common.Order;
import com.kontakt.sdk.android.common.model.OrderBy;
import com.kontakt.sdk.android.common.util.SDKPreconditions;
import java.util.Map;
import java.util.UUID;
import retrofit2.Call;

public class ProximitiesRequestExecutor
extends PaginatedRequestExecutor<Proximities> {
    private final ProximitiesService proximitiesService;
    private UUID mappedBy;

    public ProximitiesRequestExecutor(ProximitiesService proximitiesService) {
        this.proximitiesService = proximitiesService;
    }

    public ProximitiesRequestExecutor mappedBy(UUID proximity) {
        SDKPreconditions.checkNotNull(proximity, "proximity cannot be null");
        this.mappedBy = proximity;
        return this;
    }

    @Override
    public ProximitiesRequestExecutor startIndex(int startIndex) {
        super.startIndex(startIndex);
        return this;
    }

    @Override
    public ProximitiesRequestExecutor maxResult(int maxResult) {
        super.maxResult(maxResult);
        return this;
    }

    @Override
    public ProximitiesRequestExecutor filter(String query) {
        super.filter(query);
        return this;
    }

    @Override
    public ProximitiesRequestExecutor orderBy(OrderBy orderBy, Order order) {
        super.orderBy(orderBy, order);
        return this;
    }

    @Override
    public ProximitiesRequestExecutor eTag(String eTag) {
        super.eTag(eTag);
        return this;
    }

    @Override
    protected Call<Proximities> prepareCall() {
        Call<Proximities> call = this.eTag != null ? this.proximitiesService.getProximities(this.params(), this.eTag) : this.proximitiesService.getProximities(this.params());
        return call;
    }

    @Override
    protected Map<String, String> params() {
        Map<String, String> params = super.params();
        if (this.mappedBy != null) {
            params.put("proximity", this.mappedBy.toString());
        }
        return params;
    }
}

